/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.base.extractors;

import java.lang.reflect.Method;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import org.drools.base.base.BaseClassFieldReader;
import org.drools.base.base.ValueResolver;
import org.drools.base.base.ValueType;
import org.drools.util.FloatHelper;

public abstract class BaseObjectClassFieldReader
extends BaseClassFieldReader {
    private static final long serialVersionUID = 510L;

    public BaseObjectClassFieldReader() {
    }

    protected BaseObjectClassFieldReader(int index, Class<?> fieldType, ValueType valueType) {
        super(index, fieldType, valueType);
    }

    @Override
    public abstract Object getValue(ValueResolver var1, Object var2);

    @Override
    public boolean getBooleanValue(ValueResolver valueResolver, Object object) {
        Object value = this.getValue(valueResolver, object);
        if (value instanceof Boolean) {
            Boolean b = (Boolean)value;
            return b;
        }
        throw new RuntimeException("Conversion to boolean not supported from " + this.getExtractToClass().getName());
    }

    @Override
    public double getDecimalValue(ValueResolver valueResolver, Object object) {
        Object value = this.getValue(valueResolver, object);
        if (value instanceof Character) {
            Character c = (Character)value;
            return c.charValue();
        }
        if (value instanceof Number) {
            Number n = (Number)value;
            return FloatHelper.cleanDouble((double)n.doubleValue());
        }
        throw new RuntimeException("Conversion to double not supported from " + this.getExtractToClass().getName());
    }

    @Override
    public long getWholeNumberValue(ValueResolver valueResolver, Object object) {
        Object value = this.getValue(valueResolver, object);
        if (value instanceof Character) {
            Character c = (Character)value;
            return c.charValue();
        }
        if (value instanceof Number) {
            Number n = (Number)value;
            return n.longValue();
        }
        if (value instanceof Date) {
            Date d = (Date)value;
            return d.getTime();
        }
        if (value instanceof LocalDate) {
            LocalDate ld = (LocalDate)value;
            return Date.from(ld.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant()).getTime();
        }
        if (value instanceof LocalDateTime) {
            LocalDateTime ldt = (LocalDateTime)value;
            return Date.from(ldt.atZone(ZoneId.systemDefault()).toInstant()).getTime();
        }
        if (value instanceof ZonedDateTime) {
            ZonedDateTime zdt = (ZonedDateTime)value;
            return Date.from(zdt.toInstant()).getTime();
        }
        throw new RuntimeException("Conversion to long not supported from " + this.getExtractToClass().getName());
    }

    @Override
    public boolean isNullValue(ValueResolver valueResolver, Object object) {
        return object == null || this.getValue(valueResolver, object) == null;
    }

    @Override
    public Method getNativeReadMethod() {
        try {
            return this.getClass().getMethod(this.getNativeReadMethodName(), ValueResolver.class, Object.class);
        }
        catch (Exception e) {
            throw new RuntimeException("This is a bug. Please report to development team: " + e.getMessage(), e);
        }
    }

    @Override
    public String getNativeReadMethodName() {
        Class<?> type = this.getExtractToClass();
        if (!type.isPrimitive()) {
            return "getValue";
        }
        if (type == Integer.TYPE || type == Long.TYPE || type == Short.TYPE || type == Byte.TYPE || type == Character.TYPE) {
            return "getWholeNumberValue";
        }
        if (type == Float.TYPE || type == Double.TYPE) {
            return "getDecimalValue";
        }
        return "get" + type.getName().substring(0, 1).toUpperCase() + type.getName().substring(1) + "Value";
    }

    @Override
    public int getHashCode(ValueResolver valueResolver, Object object) {
        Object value = this.getValue(valueResolver, object);
        return value != null ? value.hashCode() : 0;
    }
}

