/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.base.extractors;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import org.drools.base.base.ClassWireable;
import org.drools.base.base.ValueResolver;
import org.drools.base.base.ValueType;
import org.drools.base.rule.accessor.AcceptsReadAccessor;
import org.drools.base.rule.accessor.ReadAccessor;
import org.drools.util.ClassUtils;
import org.drools.util.StringUtils;

public class ArrayElementReader
implements AcceptsReadAccessor,
ReadAccessor,
ClassWireable,
Externalizable {
    private ReadAccessor arrayReadAccessor;
    private int index;
    private Class type;

    public ArrayElementReader() {
    }

    public ArrayElementReader(ReadAccessor arrayExtractor, int index, Class<?> type) {
        this.arrayReadAccessor = arrayExtractor;
        this.index = index;
        this.type = type;
    }

    @Override
    public Class<?> getExtractToClass() {
        return this.type;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.arrayReadAccessor = (ReadAccessor)in.readObject();
        this.index = in.readInt();
        this.type = (Class)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.arrayReadAccessor);
        out.writeInt(this.index);
        out.writeObject(this.type);
    }

    @Override
    public void setReadAccessor(ReadAccessor readAccessor) {
        this.arrayReadAccessor = readAccessor;
    }

    public ReadAccessor getReadAccessor() {
        return this.arrayReadAccessor;
    }

    @Override
    public String getExtractToClassName() {
        return ClassUtils.canonicalName((Class)this.type);
    }

    @Override
    public boolean getBooleanValue(ValueResolver valueResolver, Object object) {
        Object[] array = (Object[])this.arrayReadAccessor.getValue(valueResolver, object);
        return (Boolean)array[this.index];
    }

    @Override
    public double getDecimalValue(ValueResolver valueResolver, Object object) {
        Object[] array = (Object[])this.arrayReadAccessor.getValue(valueResolver, object);
        return ((Number)array[this.index]).doubleValue();
    }

    @Override
    public long getWholeNumberValue(ValueResolver valueResolver, Object object) {
        Object[] array = (Object[])this.arrayReadAccessor.getValue(valueResolver, object);
        return ((Number)array[this.index]).longValue();
    }

    @Override
    public Method getNativeReadMethod() {
        try {
            return this.getClass().getDeclaredMethod(this.getNativeReadMethodName(), ValueResolver.class, Object.class);
        }
        catch (Exception e) {
            throw new RuntimeException("This is a bug. Please report to development team: " + e.getMessage(), e);
        }
    }

    @Override
    public String getNativeReadMethodName() {
        String method = "";
        if (this.type != null && this.type.isPrimitive()) {
            if (this.type == Integer.TYPE || this.type == Long.TYPE || this.type == Short.TYPE || this.type == Byte.TYPE) {
                return "getWholeNumberValue";
            }
            if (this.type == Float.TYPE || this.type == Double.TYPE) {
                return "getDecimalValue";
            }
            method = StringUtils.ucFirst((String)this.type.getName());
        }
        return "get" + method + "Value";
    }

    @Override
    public Object getValue(ValueResolver valueResolver, Object object) {
        Object[] array = (Object[])this.arrayReadAccessor.getValue(valueResolver, object);
        return array[this.index];
    }

    @Override
    public ValueType getValueType() {
        return ValueType.OBJECT_TYPE;
    }

    @Override
    public boolean isNullValue(ValueResolver valueResolver, Object object) {
        Object[] array = (Object[])this.arrayReadAccessor.getValue(valueResolver, object);
        return array[this.index] == null;
    }

    @Override
    public int getHashCode(ValueResolver valueResolver, Object object) {
        Object[] array = (Object[])this.arrayReadAccessor.getValue(valueResolver, object);
        Object value = array[this.index];
        return value != null ? value.hashCode() : 0;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.arrayReadAccessor == null ? 0 : this.arrayReadAccessor.hashCode());
        result = 31 * result + this.index;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArrayElementReader other = (ArrayElementReader)obj;
        if (this.arrayReadAccessor == null ? other.arrayReadAccessor != null : !this.arrayReadAccessor.equals(other.arrayReadAccessor)) {
            return false;
        }
        return this.index == other.index;
    }

    @Override
    public boolean isGlobal() {
        return false;
    }

    @Override
    public boolean isSelfReference() {
        return false;
    }

    @Override
    public int getHashCode(Object object) {
        return this.getHashCode(null, object);
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public Object getValue(Object object) {
        return this.getValue(null, object);
    }

    public boolean isNullValue(Object object) {
        return this.isNullValue(null, object);
    }

    @Override
    public void wire(Class<?> klass) {
        this.type = klass;
    }

    @Override
    public String getClassName() {
        return this.type.getName();
    }

    @Override
    public Class<?> getClassType() {
        return this.type;
    }
}

