/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.prototype;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import org.drools.base.base.ObjectType;
import org.drools.base.base.ValueType;
import org.kie.api.prototype.Prototype;
import org.kie.api.prototype.PrototypeFactInstance;

public class PrototypeObjectType
implements ObjectType {
    protected Prototype prototype;
    private boolean isEvent;

    public PrototypeObjectType() {
    }

    public PrototypeObjectType(Prototype prototype) {
        this.prototype = prototype;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.prototype = (Prototype)in.readObject();
        this.isEvent = in.readBoolean();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.prototype);
        out.writeBoolean(this.isEvent);
    }

    public Prototype getPrototype() {
        return this.prototype;
    }

    public boolean matches(Object object) {
        if (object instanceof PrototypeFactInstance) {
            PrototypeFactInstance f = (PrototypeFactInstance)object;
            return this.prototype.equals(f.getPrototype());
        }
        return false;
    }

    @Override
    public boolean isAssignableFrom(Class<?> clazz) {
        return false;
    }

    @Override
    public boolean isAssignableTo(Class<?> clazz) {
        return false;
    }

    @Override
    public boolean isAssignableFrom(ObjectType objectType) {
        if (!(objectType instanceof PrototypeObjectType)) {
            return false;
        }
        return this.prototype.equals(((PrototypeObjectType)objectType).getPrototype());
    }

    @Override
    public ValueType getValueType() {
        return ValueType.PROTOTYPE_TYPE;
    }

    @Override
    public boolean isEvent() {
        return this.isEvent;
    }

    public void setEvent(boolean isEvent) {
        this.isEvent = isEvent;
    }

    @Override
    public Object getTypeKey() {
        return this.prototype.getName();
    }

    @Override
    public boolean isPrototype() {
        return true;
    }

    @Override
    public String getClassName() {
        return this.prototype.getFullName();
    }

    @Override
    public boolean hasField(String name) {
        return this.prototype.getField(name) != null;
    }

    public Collection<String> getFieldNames() {
        return this.prototype.getFieldNames();
    }

    public String toString() {
        return "[PrototypeObjectType " + (this.isEvent ? "event=" : "template=") + this.prototype.getName() + "]";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PrototypeObjectType)) {
            return false;
        }
        PrototypeObjectType other = (PrototypeObjectType)object;
        return this.prototype.equals(other.prototype);
    }

    public int hashCode() {
        return this.prototype.hashCode();
    }
}

