/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.reteoo;

import org.drools.base.common.NetworkNode;

public class NodeTypeEnums {
    public static final int ObjectSourceMask = 1;
    public static final int TupleSourceMask = 4;
    public static final int ObjectSinkMask = 8;
    public static final int TupleSinkMask = 16;
    public static final int TupleNodeMask = 32;
    public static final int LeftInputAdapterMask = 64;
    public static final int TerminalNodeMask = 128;
    public static final int EndNodeMask = 256;
    public static final int BetaMask = 512;
    public static final int MemoryFactoryMask = 1024;
    public static final int shift = 15;
    public static final int EntryPointNode = 3276809;
    public static final int ReteNode = 3932169;
    public static final int ObjectTypeNode = 4259849;
    public static final int AlphaNode = 4587529;
    public static final int WindowNode = 4916233;
    public static final int RightInputAdapterNode = 5244209;
    public static final int RuleTerminalNode = 5899696;
    public static final int QueryTerminalNode = 6227376;
    public static final int LeftInputAdapterNode = 6882412;
    public static final int AlphaTerminalNode = 7210092;
    public static final int EvalConditionNode = 7537716;
    public static final int TimerConditionNode = 7865396;
    public static final int AsyncSendNode = 8193076;
    public static final int AsyncReceiveNode = 8520756;
    public static final int FromNode = 8848436;
    public static final int ReactiveFromNode = 9176116;
    public static final int QueryElementNode = 9831476;
    public static final int ConditionalBranchNode = 10159156;
    public static final int BetaNode = 10487348;
    public static final int JoinNode = 10815028;
    public static final int NotNode = 11142708;
    public static final int ExistsNode = 11470388;
    public static final int AccumulateNode = 11798068;
    public static final int MockBetaNode = 13107764;
    public static final int MockAlphaNode = 16384009;

    public static boolean isObjectSource(NetworkNode node) {
        return (node.getType() & 1) != 0;
    }

    public static boolean isObjectSink(NetworkNode node) {
        return (node.getType() & 8) != 0;
    }

    public static boolean isLeftTupleSource(NetworkNode node) {
        return (node.getType() & 4) != 0;
    }

    public static boolean isBetaNode(NetworkNode node) {
        return (node.getType() & 0x200) != 0;
    }

    public static boolean isBetaNodeWithRian(NetworkNode node) {
        return NodeTypeEnums.isBetaNode(node) && node.isRightInputIsRiaNode();
    }

    public static boolean isTerminalNode(NetworkNode node) {
        return (node.getType() & 0x80) != 0;
    }

    public static boolean isLeftTupleSink(NetworkNode node) {
        return (node.getType() & 0x10) != 0;
    }

    public static boolean isEndNode(NetworkNode node) {
        return (node.getType() & 0x100) != 0;
    }

    public static boolean isLeftTupleNode(NetworkNode node) {
        return (node.getType() & 0x20) != 0;
    }

    public static boolean isMemoryFactory(NetworkNode node) {
        return (node.getType() & 0x400) != 0;
    }

    public static boolean isLeftInputAdapterNode(NetworkNode node) {
        return (node.getType() & 0x40) != 0;
    }
}

