/*
 * Decompiled with CFR 0.152.
 */
package bsh.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.Objects;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class ReferenceCache<K, V> {
    private final ConcurrentMap<CacheReference<K>, Future<CacheReference<V>>> cache;
    private final ReferenceFactory<K, V> keyFactory;
    private final ReferenceFactory<K, V> valueFactory;
    private final ReferenceFactory<K, V> lookupFactory;
    private final ReferenceQueueMonitor<? super Object> queue;
    private static final ExecutorService taskService = Executors.newCachedThreadPool(new DaemonThreadFactory());

    public ReferenceCache(Type keyType, Type valueType) {
        this(keyType, valueType, 0);
    }

    public ReferenceCache(Type keyType, Type valueType, int initialSize) {
        this.keyFactory = this.toFactory(keyType);
        this.valueFactory = this.toFactory(valueType);
        this.lookupFactory = new HardReferenceFactory();
        this.cache = new ConcurrentHashMap<CacheReference<K>, Future<CacheReference<V>>>(initialSize);
        this.queue = new ReferenceQueueMonitor();
        Thread t = new Thread(this.queue);
        t.setDaemon(true);
        t.start();
    }

    protected abstract V create(K var1);

    public V get(K key) {
        if (null == key) {
            return null;
        }
        CacheReference<? super Object> refKey = this.lookupFactory.createKey(key, this.queue);
        if (this.cache.containsKey(refKey)) {
            V value = this.dereferenceValue((Future)this.cache.get(refKey));
            if (null != value) {
                return value;
            }
            this.cache.remove(refKey);
        }
        this.init(key);
        return this.dereferenceValue((Future)this.cache.get(refKey));
    }

    public void init(K key) {
        if (null == key) {
            return;
        }
        CacheReference<? super Object> refKey = this.keyFactory.createKey(key, this.queue);
        if (this.cache.containsKey(refKey)) {
            return;
        }
        FutureTask<CacheReference> task = new FutureTask<CacheReference>(() -> {
            V created = Objects.requireNonNull(this.create(key), "Reference cache create value may not return null.");
            return this.valueFactory.createValue(created, this.queue);
        });
        this.cache.put(refKey, task);
        taskService.execute(task);
    }

    public boolean remove(K key) {
        if (null == key) {
            return false;
        }
        CacheReference<? super Object> keyRef = this.lookupFactory.createKey(key, this.queue);
        return ((CacheKey)CacheKey.class.cast(keyRef)).removeCacheEntry();
    }

    public int size() {
        return this.cache.size();
    }

    public void clear() {
        this.cache.clear();
    }

    private final ReferenceFactory<K, V> toFactory(Type type) {
        switch (type) {
            case Hard: {
                return new HardReferenceFactory();
            }
            case Weak: {
                return new WeakReferenceFactory();
            }
            case Soft: {
                return new SoftReferenceFactory();
            }
        }
        return null;
    }

    private V dereferenceValue(CacheReference<V> refValue) {
        return refValue.get();
    }

    private V dereferenceValue(Future<CacheReference<V>> futureValue) {
        if (null == futureValue) {
            return null;
        }
        try {
            return this.dereferenceValue(futureValue.get());
        }
        catch (Throwable e) {
            throw new CompletionException(e.getCause());
        }
    }

    public static enum Type {
        Weak,
        Soft,
        Hard;

    }

    private static interface ReferenceFactory<K, V> {
        public CacheReference<K> createKey(K var1, ReferenceQueue<? super K> var2);

        public CacheReference<V> createValue(V var1, ReferenceQueue<? super V> var2);
    }

    private class HardReferenceFactory
    implements ReferenceFactory<K, V> {
        private HardReferenceFactory() {
        }

        @Override
        public CacheReference<K> createKey(final K key, ReferenceQueue<? super K> queue) {
            return new CacheKey<K>(key){

                @Override
                public K get() {
                    return key;
                }
            };
        }

        @Override
        public CacheReference<V> createValue(final V value, ReferenceQueue<? super V> queue) {
            return new CacheReference<V>(){

                @Override
                public V get() {
                    return value;
                }
            };
        }
    }

    private class ReferenceQueueMonitor<T>
    extends ReferenceQueue<T>
    implements Runnable {
        private ReferenceQueueMonitor() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Reference reference = super.remove();
                        reference.clear();
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }

    private static interface CacheReference<T> {
        public T get();
    }

    private abstract class CacheKey<T>
    implements CacheReference<T> {
        private final int hashCode;

        public CacheKey(T key) {
            this.hashCode = key.hashCode() + key.toString().chars().sum();
        }

        @Override
        public abstract T get();

        public boolean removeCacheEntry() {
            return null != ReferenceCache.this.cache.remove(this);
        }

        public boolean equals(Object obj) {
            return this.hashCode == obj.hashCode();
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    private class WeakReferenceFactory
    implements ReferenceFactory<K, V> {
        private WeakReferenceFactory() {
        }

        @Override
        public CacheReference<K> createKey(final K key, final ReferenceQueue<? super K> queue) {
            return new CacheKey<K>(key){
                final Reference<K> ref;
                {
                    super(key2);
                    this.ref = new WeakReference<K>(key, queue){

                        @Override
                        public void clear() {
                            this.removeCacheEntry();
                            super.clear();
                        }
                    };
                }

                @Override
                public K get() {
                    return this.ref.get();
                }
            };
        }

        @Override
        public CacheReference<V> createValue(V value, ReferenceQueue<? super V> queue) {
            return new WeakReferenceValue(value, queue);
        }

        private class WeakReferenceValue<T>
        extends WeakReference<T>
        implements CacheReference<T> {
            WeakReferenceValue(T value, ReferenceQueue<? super T> queue) {
                super(value, queue);
            }
        }
    }

    private class SoftReferenceFactory
    implements ReferenceFactory<K, V> {
        private SoftReferenceFactory() {
        }

        @Override
        public CacheReference<K> createKey(final K key, final ReferenceQueue<? super K> queue) {
            return new CacheKey<K>(key){
                final Reference<K> ref;
                {
                    super(key2);
                    this.ref = new SoftReference<K>(key, queue){

                        @Override
                        public void clear() {
                            this.removeCacheEntry();
                            super.clear();
                        }
                    };
                }

                @Override
                public K get() {
                    return this.ref.get();
                }
            };
        }

        @Override
        public CacheReference<V> createValue(V value, ReferenceQueue<? super V> queue) {
            return new SoftReferenceValue(value, queue);
        }

        private class SoftReferenceValue<T>
        extends SoftReference<T>
        implements CacheReference<T> {
            SoftReferenceValue(T value, ReferenceQueue<? super T> queue) {
                super(value, queue);
            }
        }
    }

    private static final class DaemonThreadFactory
    implements ThreadFactory {
        private final ThreadGroup group = Thread.currentThread().getThreadGroup();
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix = "pool-referencecache-futuretask-thread-";

        private DaemonThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, "pool-referencecache-futuretask-thread-" + this.threadNumber.getAndIncrement(), 0L);
            if (!t.isDaemon()) {
                t.setDaemon(true);
            }
            if (t.getPriority() != 10) {
                t.setPriority(10);
            }
            return t;
        }
    }
}

