/*
 * Decompiled with CFR 0.152.
 */
package bsh.servlet;

import bsh.FileReader;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;

public class Remote {
    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.out.println("usage: Remote URL(http|bsh) file [ file ] ... ");
            System.exit(1);
        }
        String url = args[0];
        String text = Remote.getFile(args[1]);
        int ret = Remote.eval(url, text);
        System.exit(ret);
    }

    public static int eval(String url, String text) throws IOException {
        String returnValue = null;
        if (url.startsWith("http:")) {
            returnValue = Remote.doHttp(url, text);
        } else if (url.startsWith("bsh:")) {
            returnValue = Remote.doBsh(url, text);
        } else {
            throw new IOException("Unrecognized URL type.Scheme must be http:// or bsh://");
        }
        if (null != returnValue) {
            return Integer.parseInt(returnValue);
        }
        return 0;
    }

    /*
     * Exception decompiling
     */
    static String doBsh(String url, String text) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 27[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void sendLine(String line, OutputStream outPipe) throws IOException {
        outPipe.write(line.getBytes(StandardCharsets.UTF_8));
        outPipe.flush();
    }

    static String doHttp(String postURL, String text) {
        String returnValue = null;
        StringBuilder sb = new StringBuilder();
        sb.append("bsh.client=Remote");
        sb.append("&bsh.script=");
        try {
            sb.append(URLEncoder.encode(text, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        String formData = sb.toString();
        try {
            URL url = new URL(postURL);
            HttpURLConnection urlcon = (HttpURLConnection)url.openConnection();
            urlcon.setRequestMethod("POST");
            urlcon.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
            urlcon.setDoOutput(true);
            urlcon.setDoInput(true);
            PrintWriter pout = new PrintWriter((Writer)new OutputStreamWriter(urlcon.getOutputStream(), "8859_1"), true);
            pout.print(formData);
            pout.flush();
            int rc = urlcon.getResponseCode();
            if (rc != 200) {
                System.out.println("Error, HTTP response: " + rc);
            }
            returnValue = urlcon.getHeaderField("Bsh-Return");
            try (BufferedReader bin = new BufferedReader(new FileReader(urlcon.getInputStream()));){
                String line;
                while ((line = bin.readLine()) != null) {
                    System.out.println(line);
                }
            }
            System.out.println("Return Value: " + returnValue);
        }
        catch (MalformedURLException e) {
            System.out.println(e);
        }
        catch (IOException e2) {
            System.out.println(e2);
        }
        return returnValue;
    }

    static String getFile(String name) throws FileNotFoundException, IOException {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader bin = new BufferedReader(new FileReader(name));){
            String line;
            while ((line = bin.readLine()) != null) {
                sb.append(line).append("\n");
            }
        }
        return sb.toString();
    }
}

