/*
 * Decompiled with CFR 0.152.
 */
package bsh.classpath;

import bsh.ClassPathException;
import bsh.NameSource;
import bsh.classpath.ClassPathListener;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class BshClassPath
implements ClassPathListener,
NameSource {
    String name;
    private final Set<URL> path = ConcurrentHashMap.newKeySet();
    private final Set<BshClassPath> compPaths = ConcurrentHashMap.newKeySet();
    private final Map<String, Set<String>> packageMap = new ConcurrentHashMap<String, Set<String>>();
    private final Map<String, ClassSource> classSource = new ConcurrentHashMap<String, ClassSource>();
    private boolean mapsInitialized;
    private UnqualifiedNameTable unqNameTable;
    private boolean nameCompletionIncludesUnqNames = true;
    Vector<WeakReference<ClassPathListener>> listeners = new Vector();
    private static final Pattern slashDot = Pattern.compile("[/\\\\]");
    private static final Pattern moduleName = Pattern.compile("^modules/[^/]+/");
    private static final Pattern dotClass = Pattern.compile("\\.[^\\.]+$");
    private static final Pattern splitClass = Pattern.compile("\\.(?=[^.]+$)");
    private static URL[] userClassPathComp;
    private static BshClassPath userClassPath;
    private static BshClassPath bootClassPath;
    private List<NameSource.Listener> nameSourceListeners;
    private static MappingFeedback mappingFeedbackListener;

    public BshClassPath(String name) {
        this.name = name;
        this.reset();
    }

    public BshClassPath(String name, URL[] urls) {
        this(name);
        this.add(urls);
    }

    public void setPath(URL[] urls) {
        this.reset();
        this.add(urls);
    }

    public void addComponent(BshClassPath bcp) {
        if (bcp == null) {
            return;
        }
        this.compPaths.add(bcp);
        bcp.addListener(this);
    }

    public void add(URL[] urls) {
        this.path.addAll(Arrays.asList(urls));
        if (this.mapsInitialized) {
            this.map(urls);
        }
    }

    public void add(URL url) throws IOException {
        this.path.add(url);
        if (this.mapsInitialized) {
            this.map(url);
        }
    }

    public URL[] getPathComponents() {
        return this.getFullPath().toArray(new URL[0]);
    }

    public Set<String> getClassesForPackage(String pack) {
        this.insureInitialized();
        HashSet<String> set = new HashSet<String>();
        Collection c = this.packageMap.get(pack);
        if (c != null) {
            set.addAll(c);
        }
        this.compPaths.forEach(cp -> {
            Set<String> cf = cp.getClassesForPackage(pack);
            if (cf != null) {
                set.addAll(cf);
            }
        });
        return set;
    }

    public ClassSource getClassSource(String className) {
        ClassSource cs = this.classSource.get(className);
        if (cs != null) {
            return cs;
        }
        this.insureInitialized();
        Iterator<BshClassPath> it = this.compPaths.iterator();
        cs = this.classSource.get(className);
        while (cs == null && it.hasNext()) {
            cs = it.next().getClassSource(className);
        }
        return cs;
    }

    public void setClassSource(String className, ClassSource cs) {
        this.classSource.put(className, cs);
    }

    public void insureInitialized() {
        this.insureInitialized(true);
    }

    protected void insureInitialized(boolean topPath) {
        if (topPath && !this.mapsInitialized) {
            this.startClassMapping();
        }
        this.compPaths.forEach(cp -> cp.insureInitialized(false));
        if (!this.mapsInitialized) {
            this.map(this.path.toArray(new URL[0]));
        }
        if (topPath && !this.mapsInitialized) {
            this.endClassMapping();
        }
        this.mapsInitialized = true;
    }

    protected List<URL> getFullPath() {
        ArrayList<URL> list = new ArrayList<URL>();
        this.compPaths.forEach(cp -> {
            List<URL> l = cp.getFullPath();
            for (URL o : l) {
                if (list.contains(o)) continue;
                list.add(o);
            }
        });
        list.addAll(this.path);
        return list;
    }

    public String getClassNameByUnqName(String name) throws ClassPathException {
        this.insureInitialized();
        AmbiguousName aName = (AmbiguousName)this.getUnqualifiedNameTable().get(name);
        if (null == aName) {
            return null;
        }
        List<String> names = aName.get();
        if (names.size() != 1) {
            throw new ClassPathException("Ambiguous class names: " + names);
        }
        return names.get(0);
    }

    private UnqualifiedNameTable getUnqualifiedNameTable() {
        if (this.unqNameTable == null) {
            this.unqNameTable = this.buildUnqualifiedNameTable();
        }
        return this.unqNameTable;
    }

    private UnqualifiedNameTable buildUnqualifiedNameTable() {
        UnqualifiedNameTable unqNameTable = new UnqualifiedNameTable();
        this.compPaths.forEach(cp -> {
            Set<String> s = cp.classSource.keySet();
            s.forEach(nt -> unqNameTable.add((String)nt));
        });
        this.classSource.keySet().forEach(nt -> unqNameTable.add((String)nt));
        return unqNameTable;
    }

    @Override
    public String[] getAllNames() {
        this.insureInitialized();
        ArrayList names = new ArrayList();
        this.getPackagesSet().forEach(pack -> names.addAll(BshClassPath.removeInnerClassNames(this.getClassesForPackage((String)pack))));
        if (this.nameCompletionIncludesUnqNames) {
            names.addAll(this.getUnqualifiedNameTable().keySet());
        }
        return names.toArray(new String[names.size()]);
    }

    void map(URL[] urls) {
        for (int i = 0; i < urls.length; ++i) {
            try {
                this.map(urls[i]);
                continue;
            }
            catch (Exception e) {
                String s = "Error constructing classpath: " + urls[i] + ": " + e;
                this.errorWhileMapping(s);
                throw new RuntimeException("Failed to map class path " + i, e);
            }
        }
    }

    void map(URL url) throws IOException {
        if ("jrt".equals(url.getProtocol())) {
            this.classMapping("FileSystem: " + url);
            this.map(BshClassPath.searchJrtFSForClasses(url), new JrtClassSource(url));
        } else if ("jar".equals(url.getProtocol())) {
            this.classMapping("FileSystem: " + url);
            this.map(BshClassPath.searchJarFSForClasses(url), new JarClassSource(url));
        } else {
            String name = url.getFile();
            File f = new File(name);
            if (f.isDirectory()) {
                this.classMapping("Directory " + f.toString());
                this.map(BshClassPath.traverseDirForClasses(f), new DirClassSource(f));
            } else if (BshClassPath.isArchiveFileName(name)) {
                this.classMapping("Archive: " + url);
                this.map(BshClassPath.searchArchiveForClasses(url), new JarClassSource(url));
            } else {
                String s = "Not a classpath component: " + name;
                this.errorWhileMapping(s);
            }
        }
    }

    private void map(String[] classes, ClassSource source) {
        for (int i = 0; i < classes.length; ++i) {
            this.mapClass(classes[i], source);
        }
    }

    private void mapClass(String className, ClassSource source) {
        String[] sa = BshClassPath.splitClassname(className);
        String pack = sa[0];
        Set<String> set = this.packageMap.get(pack);
        if (set == null) {
            set = new HashSet<String>();
            this.packageMap.put(pack, set);
        }
        set.add(className);
        ClassSource obj = this.classSource.get(className);
        if (obj == null) {
            this.classSource.put(className, source);
        }
    }

    private void reset() {
        this.path.clear();
        this.compPaths.clear();
        this.clearCachedStructures();
    }

    private void clearCachedStructures() {
        this.mapsInitialized = false;
        this.packageMap.clear();
        this.classSource.clear();
        this.unqNameTable = null;
        this.nameSpaceChanged();
    }

    @Override
    public void classPathChanged() {
        this.clearCachedStructures();
        this.notifyListeners();
    }

    static String[] traverseDirForClasses(File dir2) throws IOException {
        List<String> list = BshClassPath.traverseDirForClassesAux(dir2, dir2);
        return list.toArray(new String[list.size()]);
    }

    static List<String> traverseDirForClassesAux(File topDir, File dir2) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        String top = topDir.getAbsolutePath();
        File[] children = dir2.listFiles();
        if (null == children) {
            children = new File[]{};
        }
        for (int i = 0; i < children.length; ++i) {
            File child = children[i];
            if (child.isDirectory()) {
                list.addAll(BshClassPath.traverseDirForClassesAux(topDir, child));
                continue;
            }
            String name = child.getAbsolutePath();
            if (!BshClassPath.isClassFileName(name)) continue;
            if (!name.startsWith(top)) {
                throw new IOException("problem parsing paths");
            }
            name = name.substring(top.length() + 1);
            name = BshClassPath.canonicalizeClassName(name);
            list.add(name);
        }
        return list;
    }

    static String[] searchJrtFSForClasses(URL url) throws IOException {
        String[] stringArray;
        block11: {
            Path path = FileSystems.getFileSystem(new URI("jrt:/")).getPath("modules", url.getPath());
            Stream<Path> stream = Files.walk(path, new FileVisitOption[0]);
            try {
                stringArray = (String[])stream.map(Path::toString).filter(BshClassPath::isClassFileName).map(BshClassPath::canonicalizeClassName).toArray(String[]::new);
                if (stream == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (URISyntaxException uRISyntaxException) {
                    return new String[0];
                }
            }
            stream.close();
        }
        return stringArray;
    }

    static String[] searchJarFSForClasses(URL url) throws IOException {
        String[] stringArray;
        block13: {
            try {
                FileSystems.newFileSystem(url.toURI(), new HashMap());
            }
            catch (FileSystemAlreadyExistsException fileSystemAlreadyExistsException) {
                // empty catch block
            }
            Path path = FileSystems.getFileSystem(url.toURI()).getPath("/", new String[0]);
            Stream<Path> stream = Files.walk(path, new FileVisitOption[0]);
            try {
                stringArray = (String[])stream.map(Path::toString).filter(BshClassPath::isClassFileName).map(BshClassPath::canonicalizeClassName).toArray(String[]::new);
                if (stream == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (URISyntaxException uRISyntaxException) {
                    return new String[0];
                }
            }
            stream.close();
        }
        return stringArray;
    }

    static String[] searchArchiveForClasses(URL url) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        ZipInputStream zip = new ZipInputStream(url.openStream());
        while (zip.available() == 1) {
            ZipEntry ze = zip.getNextEntry();
            if (ze == null || !BshClassPath.isClassFileName(ze.getName())) continue;
            list.add(BshClassPath.canonicalizeClassName(ze.getName()));
        }
        zip.close();
        return list.toArray(new String[list.size()]);
    }

    public static boolean isClassFileName(String name) {
        return name.toLowerCase().endsWith(".class");
    }

    public static boolean isArchiveFileName(String name) {
        return (name = name.toLowerCase()).endsWith(".jar") || name.endsWith(".zip") || name.endsWith(".jmod");
    }

    public static String canonicalizeClassName(String name) {
        String classname = name;
        if (classname.startsWith("modules/")) {
            classname = moduleName.matcher(classname).replaceFirst("");
        }
        if (classname.indexOf(47) >= 0 || classname.indexOf(92) >= 0) {
            classname = slashDot.matcher(classname).replaceAll(".");
        }
        if (classname.startsWith(".")) {
            classname = classname.substring(1);
        }
        if (classname.startsWith("class ")) {
            classname = classname.substring(6);
        }
        if (classname.startsWith("classes.")) {
            classname = classname.substring(8);
        }
        if (classname.endsWith(".class")) {
            classname = dotClass.matcher(classname).replaceFirst("");
        }
        return classname;
    }

    public static String[] splitClassname(String classname) {
        if ((classname = BshClassPath.canonicalizeClassName(classname)).indexOf(46) == -1) {
            return new String[]{"<unpackaged>", classname};
        }
        return splitClass.split(classname);
    }

    public static Collection<String> removeInnerClassNames(Collection<String> col) {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(col);
        Iterator it = list.iterator();
        while (it.hasNext()) {
            if (((String)it.next()).indexOf("$") == -1) continue;
            it.remove();
        }
        return list;
    }

    public static URL[] getUserClassPathComponents() throws ClassPathException {
        if (userClassPathComp != null) {
            return userClassPathComp;
        }
        String cp = System.getProperty("java.class.path");
        String[] paths = null == cp ? new String[]{} : cp.split(File.pathSeparator);
        URL[] urls = new URL[paths.length];
        try {
            for (int i = 0; i < paths.length; ++i) {
                urls[i] = new File(new File(paths[i]).getCanonicalPath()).toURI().toURL();
            }
        }
        catch (IOException e) {
            throw new ClassPathException("can't parse class path: " + e, e);
        }
        userClassPathComp = urls;
        return urls;
    }

    public Set<String> getPackagesSet() {
        this.insureInitialized();
        HashSet<String> set = new HashSet<String>();
        set.addAll(this.packageMap.keySet());
        this.compPaths.forEach(cp -> set.addAll(cp.packageMap.keySet()));
        return set;
    }

    public void addListener(ClassPathListener l) {
        this.listeners.addElement(new WeakReference<ClassPathListener>(l));
    }

    public void removeListener(ClassPathListener l) {
        Iterator<WeakReference<ClassPathListener>> it = this.listeners.iterator();
        while (it.hasNext()) {
            if (it.next().get() != l) continue;
            it.remove();
        }
    }

    void notifyListeners() {
        Iterator<WeakReference<ClassPathListener>> it = this.listeners.iterator();
        while (it.hasNext()) {
            ClassPathListener l = (ClassPathListener)it.next().get();
            if (l == null) {
                it.remove();
                continue;
            }
            l.classPathChanged();
        }
    }

    public static BshClassPath getUserClassPath() throws ClassPathException {
        if (userClassPath == null) {
            userClassPath = new BshClassPath("User Class Path", BshClassPath.getUserClassPathComponents());
        }
        return userClassPath;
    }

    public static BshClassPath getBootClassPath() throws ClassPathException {
        if (bootClassPath == null) {
            try {
                bootClassPath = new BshClassPath("Boot Class Path", new URL[]{BshClassPath.getRTJarPath()});
            }
            catch (MalformedURLException e) {
                throw new ClassPathException(" can't find boot jar: " + e, e);
            }
        }
        return bootClassPath;
    }

    private static URL getRTJarPath() throws MalformedURLException {
        String urlString = Class.class.getResource("/java/lang/String.class").toExternalForm();
        if (urlString.startsWith("jrt:/")) {
            return new URL(urlString.substring(0, urlString.indexOf(47, 5)));
        }
        return new URL(urlString.replaceFirst("[^!]*$", "/"));
    }

    public String toString() {
        return "BshClassPath " + this.name + "(" + super.toString() + ") path= " + this.path + "\ncompPaths = {" + this.compPaths + " }";
    }

    void nameSpaceChanged() {
        if (this.nameSourceListeners == null) {
            return;
        }
        for (int i = 0; i < this.nameSourceListeners.size(); ++i) {
            this.nameSourceListeners.get(i).nameSourceChanged(this);
        }
    }

    @Override
    public void addNameSourceListener(NameSource.Listener listener) {
        if (this.nameSourceListeners == null) {
            this.nameSourceListeners = new ArrayList<NameSource.Listener>();
        }
        this.nameSourceListeners.add(listener);
    }

    public static void addMappingFeedback(MappingFeedback mf) {
        if (mappingFeedbackListener != null) {
            throw new RuntimeException("Unimplemented: already a listener");
        }
        mappingFeedbackListener = mf;
    }

    void startClassMapping() {
        if (mappingFeedbackListener != null) {
            mappingFeedbackListener.startClassMapping();
        } else {
            System.err.println("Start ClassPath Mapping");
        }
    }

    void classMapping(String msg) {
        if (mappingFeedbackListener != null) {
            mappingFeedbackListener.classMapping(msg);
        } else {
            System.err.println("Mapping: " + msg);
        }
    }

    void errorWhileMapping(String s) {
        if (mappingFeedbackListener != null) {
            mappingFeedbackListener.errorWhileMapping(s);
        } else {
            System.err.println(s);
        }
    }

    void endClassMapping() {
        if (mappingFeedbackListener != null) {
            mappingFeedbackListener.endClassMapping();
        } else {
            System.err.println("End ClassPath Mapping");
        }
    }

    public boolean isMapsInitialized() {
        return this.mapsInitialized;
    }

    public void setMapsInitialized(boolean mapsInitialized) {
        this.mapsInitialized = mapsInitialized;
    }

    public UnqualifiedNameTable getUnqNameTable() {
        return this.unqNameTable;
    }

    public void setUnqNameTable(UnqualifiedNameTable unqNameTable) {
        this.unqNameTable = unqNameTable;
    }

    public boolean isNameCompletionIncludesUnqNames() {
        return this.nameCompletionIncludesUnqNames;
    }

    public void setNameCompletionIncludesUnqNames(boolean nameCompletionIncludesUnqNames) {
        this.nameCompletionIncludesUnqNames = nameCompletionIncludesUnqNames;
    }

    public List<NameSource.Listener> getNameSourceListeners() {
        return this.nameSourceListeners;
    }

    public void setNameSourceListeners(List<NameSource.Listener> nameSourceListeners) {
        this.nameSourceListeners = nameSourceListeners;
    }

    public static abstract class ClassSource {
        Object source;

        abstract byte[] getCode(String var1);
    }

    static class UnqualifiedNameTable
    extends HashMap<String, AmbiguousName> {
        private static final long serialVersionUID = 1L;

        UnqualifiedNameTable() {
        }

        void add(String fullname) {
            String name = BshClassPath.splitClassname(fullname)[1];
            if (!super.containsKey(name)) {
                super.put(name, new AmbiguousName(fullname));
            } else {
                ((AmbiguousName)super.get(name)).add(fullname);
            }
        }
    }

    public static class AmbiguousName {
        List<String> list = new ArrayList<String>();

        public AmbiguousName(String name) {
            this.list.add(name);
        }

        public void add(String name) {
            this.list.add(name);
        }

        public List<String> get() {
            return this.list;
        }
    }

    public static class JrtClassSource
    extends ClassSource {
        JrtClassSource(URL url) {
            this.source = url;
        }

        public URL getURL() {
            return (URL)this.source;
        }

        @Override
        public byte[] getCode(String className) {
            byte[] byArray;
            String n = '/' + className.replace('.', '/') + ".class";
            DataInputStream in = new DataInputStream((InputStream)new URL(this.source + n).getContent());
            try {
                byte[] bytes = new byte[in.available()];
                in.readFully(bytes);
                byArray = bytes;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    return new byte[0];
                }
            }
            in.close();
            return byArray;
        }

        public String toString() {
            return "Jrt: " + this.source;
        }
    }

    public static class JarClassSource
    extends ClassSource {
        JarClassSource(URL url) {
            this.source = url;
        }

        public URL getURL() {
            return (URL)this.source;
        }

        /*
         * Enabled aggressive exception aggregation
         */
        @Override
        public byte[] getCode(String className) {
            String n = '/' + className.replace('.', '/') + ".class";
            try (URLClassLoader urlc = new URLClassLoader(new URL[]{this.getURL()});){
                byte[] byArray;
                try (DataInputStream in = new DataInputStream(urlc.loadClass(className).getResourceAsStream(n));){
                    byte[] bytes = new byte[in.available()];
                    in.readFully(bytes);
                    byArray = bytes;
                }
                return byArray;
            }
            catch (IOException | ClassNotFoundException exception) {
                return new byte[0];
            }
        }

        public String toString() {
            return "Jar: " + this.source;
        }
    }

    public static class DirClassSource
    extends ClassSource {
        DirClassSource(File dir2) {
            this.source = dir2;
        }

        public File getDir() {
            return (File)this.source;
        }

        public String toString() {
            return "Dir: " + this.source;
        }

        @Override
        public byte[] getCode(String className) {
            return DirClassSource.readBytesFromFile(this.getDir(), className);
        }

        public static byte[] readBytesFromFile(File base, String className) {
            byte[] bytes;
            String n = className.replace('.', File.separatorChar) + ".class";
            File file = new File(base, n);
            if (!file.exists()) {
                return null;
            }
            try (FileInputStream fis = new FileInputStream(file);
                 DataInputStream dis = new DataInputStream(fis);){
                bytes = new byte[(int)file.length()];
                dis.readFully(bytes);
                dis.close();
            }
            catch (IOException ie) {
                throw new RuntimeException("Couldn't load file: " + file, ie);
            }
            return bytes;
        }
    }

    static interface MappingFeedback {
        public void startClassMapping();

        public void classMapping(String var1);

        public void errorWhileMapping(String var1);

        public void endClassMapping();
    }

    public static class GeneratedClassSource
    extends ClassSource {
        GeneratedClassSource(byte[] bytecode) {
            this.source = bytecode;
        }

        @Override
        public byte[] getCode(String className) {
            return (byte[])this.source;
        }
    }
}

