/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BSHType;
import bsh.BshClassManager;
import bsh.LHS;
import bsh.Modifiers;
import bsh.Primitive;
import bsh.Reflect;
import bsh.StringUtil;
import bsh.Types;
import bsh.UtilEvalError;
import java.io.Serializable;

public class Variable
implements Serializable,
BshClassManager.Listener {
    public static final int DECLARATION = 0;
    public static final int ASSIGNMENT = 1;
    String name;
    Class<?> type = null;
    String typeDescriptor;
    Object value;
    Modifiers modifiers;
    LHS lhs;

    Variable(String name, Class<?> type, LHS lhs) {
        this.name = name;
        this.lhs = lhs;
        this.type = type;
    }

    Variable(String name, Object value, Modifiers modifiers) throws UtilEvalError {
        this(name, (Class)null, value, modifiers);
    }

    Variable(String name, String typeDescriptor, Object value, Modifiers modifiers) throws UtilEvalError {
        this(name, (Class)null, value, modifiers);
        this.typeDescriptor = typeDescriptor;
    }

    Variable(String name, Class<?> type, Object value, Modifiers modifiers) throws UtilEvalError {
        this.name = name;
        this.type = type;
        this.setModifiers(modifiers);
        this.setValue(value, 0);
    }

    public void setValue(Object value, int context) throws UtilEvalError {
        if (this.hasModifier("final")) {
            if (this.value != null) {
                throw new UtilEvalError("Cannot re-assign final variable " + this.name + ".");
            }
            if (value == null) {
                return;
            }
        }
        if (this.type != null && this.type != Object.class && value != null) {
            value = this.value = Types.castObject(value, this.type, context == 0 ? 0 : 1);
        }
        this.value = value;
        if (this.value == null && context != 0) {
            this.value = Primitive.getDefaultValue(this.type);
        }
        if (this.lhs != null) {
            this.value = this.lhs.assign(this.value, false);
        }
    }

    void validateFinalIsSet(boolean isStatic) {
        if (!this.hasModifier("final") || this.value != null) {
            return;
        }
        if (isStatic == this.hasModifier("static")) {
            throw new RuntimeException((isStatic ? "Static f" : "F") + "inal variable " + this.name + " is not initialized.");
        }
    }

    Object getValue() throws UtilEvalError {
        if (this.lhs != null) {
            return this.type == null ? this.lhs.getValue() : Primitive.wrap(this.lhs.getValue(), this.type);
        }
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getType() {
        return this.type;
    }

    public String getTypeDescriptor() {
        if (null == this.typeDescriptor) {
            this.typeDescriptor = BSHType.getTypeDescriptor(this.type == null ? Object.class : this.type);
        }
        return this.typeDescriptor;
    }

    public Modifiers getModifiers() {
        if (this.modifiers == null) {
            this.setModifiers(new Modifiers(3));
        }
        return this.modifiers;
    }

    private void setModifiers(Modifiers modifiers) {
        this.modifiers = modifiers;
    }

    public boolean hasModifier(String name) {
        return this.getModifiers().hasModifier(name);
    }

    public void setConstant() {
        if (this.hasModifier("private") || this.hasModifier("protected")) {
            throw new IllegalArgumentException("Illegal modifier for interface field " + this.getName() + ". Only public static & final are permitted.");
        }
        this.getModifiers().setConstant();
    }

    public String toString() {
        return "Variable: " + StringUtil.variableString(this) + ", value:" + this.value + ", lhs = " + this.lhs;
    }

    @Override
    public void classLoaderChanged() {
        if (Reflect.isGeneratedClass(this.type)) {
            try {
                this.type = Reflect.getThisNS(this.type).getClass(this.type.getName());
            }
            catch (UtilEvalError utilEvalError) {
                // empty catch block
            }
        }
    }
}

