/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BSHArguments;
import bsh.BSHBlock;
import bsh.BshClassManager;
import bsh.BshMethod;
import bsh.CallStack;
import bsh.ClassGenerator;
import bsh.DelayedEvalBshMethod;
import bsh.EvalError;
import bsh.GeneratedClass;
import bsh.Interpreter;
import bsh.InterpreterError;
import bsh.LHS;
import bsh.NameSpace;
import bsh.Node;
import bsh.Primitive;
import bsh.Reflect;
import bsh.StringUtil;
import bsh.TargetError;
import bsh.Types;
import bsh.UtilEvalError;
import bsh.Variable;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class This
implements Serializable,
Runnable {
    final NameSpace namespace;
    transient Interpreter declaringInterpreter;
    public static final Map<String, NameSpace> contextStore = new ConcurrentHashMap<String, NameSpace>();
    private Map<Integer, Object> interfaces;
    private final InvocationHandler invocationHandler = new Handler();
    private static final ThreadLocal<NameSpace> CONTEXT_NAMESPACE = new ThreadLocal();
    private static final ThreadLocal<Interpreter> CONTEXT_INTERPRETER = new ThreadLocal();
    static final ThreadLocal<Map<String, Object[]>> CONTEXT_ARGS = ThreadLocal.withInitial(() -> new HashMap());

    static This getThis(NameSpace namespace, Interpreter declaringInterpreter) {
        return new This(namespace, declaringInterpreter);
    }

    public Object getInterface(Class<?> clas) {
        return this.getInterface(new Class[]{clas});
    }

    public Object getInterface(Class<?>[] ca) {
        if (this.interfaces == null) {
            this.interfaces = new HashMap<Integer, Object>();
        }
        int hash = 21;
        for (int i = 0; i < ca.length; ++i) {
            hash *= ca[i].hashCode() + 3;
        }
        Integer hashKey = hash;
        Object interf = this.interfaces.get(hashKey);
        if (interf == null) {
            interf = Proxy.newProxyInstance(ca[0].getClassLoader(), ca, this.invocationHandler);
            this.interfaces.put(hashKey, interf);
        }
        return interf;
    }

    This(NameSpace namespace, Interpreter declaringInterpreter) {
        this.namespace = namespace;
        this.declaringInterpreter = declaringInterpreter;
    }

    public NameSpace getNameSpace() {
        return this.namespace;
    }

    public String toString() {
        BshMethod toString = Reflect.getMethod(this.namespace, "toString", new Class[0]);
        if (null != toString) {
            try {
                return (String)toString.invoke(new Object[0], this.declaringInterpreter);
            }
            catch (EvalError evalError) {
                // empty catch block
            }
        }
        return "'this' reference to Bsh object: " + this.namespace;
    }

    @Override
    public void run() {
        try {
            this.invokeMethod("run", Reflect.ZERO_ARGS);
        }
        catch (EvalError e) {
            this.declaringInterpreter.error("Exception in runnable:" + e);
        }
    }

    public Object invokeMethod(String name, Object[] args) throws EvalError {
        return this.invokeMethod(name, args, null, null, null, false);
    }

    public Object invokeMethod(String methodName, Object[] args, boolean declaredOnly) throws EvalError {
        CallStack callstack = new CallStack(this.namespace);
        Node node = this.namespace.getNode();
        this.namespace.setNode(null);
        try {
            Object ret = this.invokeMethod(methodName, args, this.declaringInterpreter, callstack, node, declaredOnly);
            if (ret instanceof Primitive && ret != Primitive.VOID) {
                return ((Primitive)ret).getValue();
            }
            return ret;
        }
        catch (Exception e) {
            throw new EvalError(e.getMessage(), node, callstack, e);
        }
    }

    public Object invokeMethod(String methodName, Object[] args, Interpreter interpreter, CallStack callstack, Node callerInfo, boolean declaredOnly) throws EvalError {
        Class<?>[] types;
        BshMethod bshMethod;
        if (args == null) {
            args = Reflect.ZERO_ARGS;
        }
        if (interpreter == null) {
            interpreter = this.declaringInterpreter;
        }
        if (interpreter.getNameSpace() == null) {
            interpreter.setNameSpace(this.namespace);
        }
        if (callstack == null) {
            callstack = new CallStack(this.namespace);
        }
        if (callerInfo == null) {
            callerInfo = Node.JAVACODE;
        }
        if ((bshMethod = Reflect.getMethod(this.namespace, methodName, types = Types.getTypes(args), declaredOnly)) != null) {
            return bshMethod.invoke(args, interpreter, callstack, callerInfo);
        }
        if (methodName.equals("getClass") && args.length == 0) {
            return this.getClass();
        }
        if (methodName.equals("toString") && args.length == 0) {
            return this.toString();
        }
        if (methodName.equals("hashCode") && args.length == 0) {
            return this.hashCode();
        }
        if (methodName.equals("equals") && args.length == 1) {
            Object obj = args[0];
            return this == obj ? Boolean.TRUE : Boolean.FALSE;
        }
        if (methodName.equals("clone") && args.length == 0) {
            return this.cloneMethodImpl(callerInfo, callstack);
        }
        boolean[] outHasMethod = new boolean[1];
        Object result = this.namespace.invokeDefaultInvokeMethod(methodName, args, interpreter, callstack, callerInfo, outHasMethod);
        if (outHasMethod[0]) {
            return result;
        }
        try {
            return this.namespace.invokeCommand(methodName, args, interpreter, callstack, callerInfo, true);
        }
        catch (EvalError e) {
            throw new EvalError("Method " + StringUtil.methodString(methodName, types) + " not found in bsh scripted object: " + this.namespace.getName(), callerInfo, callstack, e);
        }
    }

    Object cloneMethodImpl(Node callerInfo, CallStack callstack) throws EvalError {
        return this.cloneMethodImpl(callerInfo, callstack, null);
    }

    Object cloneMethodImpl(Node callerInfo, CallStack callstack, Object clonedInstance) throws EvalError {
        NameSpace ns = new NameSpace(this.namespace.getParent(), this.namespace.getName() + " clone");
        try {
            if (null == clonedInstance) {
                if (null == this.namespace.classStatic) {
                    return ns.getThis(this.declaringInterpreter);
                }
                clonedInstance = this.namespace.classStatic.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            ns.setClassInstance(clonedInstance);
            ns.setClassStatic(this.namespace.classStatic);
            ns.isClass = true;
            ns.isMethod = true;
            for (Variable var : this.namespace.getVariables()) {
                ns.setVariableImpl(var);
            }
            NameSpace declaringNS = new NameSpace(ns, null);
            declaringNS.setClassInstance(clonedInstance);
            declaringNS.setClassStatic(ns.classStatic);
            declaringNS.isClass = true;
            declaringNS.isMethod = true;
            for (BshMethod method : this.namespace.getMethods()) {
                BshMethod cloneM = method.clone();
                cloneM.declaringNameSpace = declaringNS;
                ns.setMethod(cloneM);
            }
            Reflect.getLHSObjectField(clonedInstance, (Object)((Object)Keys.BSHTHIS) + ns.classStatic.getSimpleName()).assign(ns.getThis(this.declaringInterpreter));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new EvalError("Unable to clone from This reference: " + e.getMessage(), callerInfo, callstack);
        }
        catch (UtilEvalError e) {
            throw e.toEvalError("Unable to assign clone instance This: " + e.getMessage(), callerInfo, callstack);
        }
        return clonedInstance;
    }

    public Object[] enumValues() {
        return Reflect.getEnumConstants(this.getNameSpace().classStatic);
    }

    public static void bind(This ths, NameSpace namespace, Interpreter declaringInterpreter) {
        ths.namespace.setParent(namespace);
        ths.declaringInterpreter = declaringInterpreter;
    }

    static boolean isExposedThisMethod(String name) {
        return name.equals("invokeMethod") || name.equals("getInterface") || name.equals("wait") || name.equals("notify") || name.equals("notifyAll");
    }

    public static ConstructorArgs getConstructorArgs(Class<?> superClass, This classStaticThis, Object[] consArgs, int index) {
        int ourSelector;
        DelayedEvalBshMethod[] constructors;
        if (classStaticThis == null) {
            throw new InterpreterError("Unititialized class: no static");
        }
        if (index == -1) {
            return ConstructorArgs.DEFAULT;
        }
        try {
            Object cons = classStaticThis.getNameSpace().getVariable(Keys.BSHCONSTRUCTORS.toString());
            if (cons == Primitive.VOID) {
                throw new InterpreterError("Unable to find constructors array in class");
            }
            constructors = (DelayedEvalBshMethod[])cons;
        }
        catch (Exception e) {
            throw new InterpreterError("Unable to get instance initializers: " + e, e);
        }
        DelayedEvalBshMethod constructor = constructors[index];
        String altConstructor = constructor.getAltConstructor();
        if (altConstructor == null) {
            return ConstructorArgs.DEFAULT;
        }
        BSHArguments argsNode = constructor.getArgsNode();
        NameSpace consArgsNameSpace = new NameSpace(classStaticThis.getNameSpace(), "consArgs");
        String[] consArgNames = constructor.getParameterNames();
        Class<?>[] consArgTypes = constructor.getParameterTypes();
        for (int i = 0; i < consArgs.length; ++i) {
            try {
                consArgsNameSpace.setTypedVariable(consArgNames[i], consArgTypes[i], consArgs[i], null);
                continue;
            }
            catch (UtilEvalError e) {
                throw new InterpreterError("err setting local cons arg:" + e, e);
            }
        }
        CallStack callstack = new CallStack();
        callstack.push(consArgsNameSpace);
        Object[] args = constructor.getConstructorArgs();
        Interpreter interpreter = classStaticThis.declaringInterpreter;
        if (null != argsNode) {
            try {
                args = argsNode.getArguments(callstack, interpreter);
            }
            catch (EvalError e) {
                throw new InterpreterError("Error evaluating constructor args: " + e, e);
            }
        }
        Class<?>[] argTypes = Types.getTypes(args);
        args = Primitive.unwrap(args);
        if (altConstructor.equals("super")) {
            int i = BshClassManager.memberCache.get(superClass).findMemberIndex(superClass.getName(), argTypes);
            if (i == -1) {
                throw new InterpreterError("can't find super constructor for args!");
            }
            return new ConstructorArgs(i, args);
        }
        int i = Reflect.findMostSpecificBshMethodIndex(argTypes, Arrays.asList(constructors));
        if (i == -1) {
            throw new InterpreterError("can't find this constructor for args!");
        }
        int count = BshClassManager.memberCache.get(superClass).memberCount(superClass.getName());
        int selector = i + count;
        if (selector == (ourSelector = index + count)) {
            throw new InterpreterError("Recursive constructor call.");
        }
        return new ConstructorArgs(selector, args);
    }

    public static void initInstance(GeneratedClass instance, String className, Object[] args) {
        try {
            This instanceThis = This.initClassInstanceThis(instance, className);
            NameSpace instanceNameSpace = instanceThis.getNameSpace();
            ArrayList<String> parentNames = new ArrayList<String>();
            for (Class<?> clas = instance.getClass(); null != clas && !clas.getSimpleName().equals(className); clas = clas.getSuperclass()) {
                parentNames.add(0, clas.getSimpleName());
            }
            parentNames.forEach(name -> This.initClassInstanceThis(instance, name));
            if (instanceNameSpace.isEnum && CONTEXT_ARGS.get().containsKey(instance.toString())) {
                args = CONTEXT_ARGS.get().remove(instance.toString());
            }
            BshMethod constructor = instanceNameSpace.getMethod(Types.getBaseName(className), Types.getTypes(args), true);
            if (args.length > 0 && constructor == null) {
                throw new InterpreterError("Can't find constructor: " + StringUtil.methodString(className, args));
            }
            if (constructor != null) {
                constructor.invoke(args, instanceThis.declaringInterpreter);
            }
            for (Variable var : Reflect.getVariables(instance)) {
                var.validateFinalIsSet(false);
            }
        }
        catch (Exception e) {
            if (e instanceof TargetError) {
                e = (Exception)((TargetError)e).getTarget();
            }
            if (e instanceof InvocationTargetException) {
                e = (Exception)e.getCause();
            }
            throw new InterpreterError("Error in class instance initialization: " + e, e);
        }
    }

    static void registerConstructorContext(CallStack callstack, Interpreter interpreter) {
        if (callstack != null) {
            CONTEXT_NAMESPACE.set(callstack.top());
        } else {
            CONTEXT_NAMESPACE.remove();
        }
        if (interpreter != null) {
            CONTEXT_INTERPRETER.set(interpreter);
        } else {
            CONTEXT_INTERPRETER.remove();
        }
    }

    private static This initClassInstanceThis(Object instance, String className) {
        This instanceThis = Reflect.getClassInstanceThis(instance, className);
        if (null == instanceThis) {
            BSHBlock instanceInitBlock;
            This classStaticThis = Reflect.getClassStaticThis(instance.getClass(), className);
            NameSpace instanceNameSpace = classStaticThis.getNameSpace().copy();
            if (CONTEXT_NAMESPACE.get() != null) {
                instanceNameSpace.setParent(CONTEXT_NAMESPACE.get());
            }
            instanceThis = null != CONTEXT_INTERPRETER.get() ? instanceNameSpace.getThis(CONTEXT_INTERPRETER.get()) : instanceNameSpace.getThis(classStaticThis.declaringInterpreter);
            try {
                LHS lhs = Reflect.getLHSObjectField(instance, (Object)((Object)Keys.BSHTHIS) + className);
                lhs.assign(instanceThis, false);
            }
            catch (Exception e) {
                throw new InterpreterError("Error in class gen setup: " + e, e);
            }
            instanceNameSpace.setClassInstance(instance);
            try {
                instanceInitBlock = (BSHBlock)classStaticThis.getNameSpace().getVariable(Keys.BSHINIT.toString());
            }
            catch (Exception e) {
                throw new InterpreterError("unable to get instance initializer: " + e, e);
            }
            try {
                instanceInitBlock.evalBlock(new CallStack(instanceNameSpace), instanceThis.declaringInterpreter, true, ClassGenerator.ClassNodeFilter.CLASSINSTANCEMETHODS);
                instanceInitBlock.evalBlock(new CallStack(instanceNameSpace), instanceThis.declaringInterpreter, true, ClassGenerator.ClassNodeFilter.CLASSINSTANCEFIELDS);
            }
            catch (Exception e) {
                throw new InterpreterError("Error in class instance This initialization: " + e, e);
            }
        }
        return instanceThis;
    }

    public static void initStatic(Class<?> genClass) throws UtilEvalError {
        String className = genClass.getSimpleName();
        try {
            This staticThis = Reflect.getClassStaticThis(genClass, className);
            NameSpace classStaticNameSpace = staticThis.getNameSpace();
            Interpreter interpreter = staticThis.declaringInterpreter;
            if (null == interpreter) {
                throw new UtilEvalError("No namespace or interpreter for statitc This. Start interpreter for class not implemented yet.");
            }
            BSHBlock block = (BSHBlock)classStaticNameSpace.getVariable(Keys.BSHINIT.toString());
            CallStack callstack = new CallStack(classStaticNameSpace);
            block.evalBlock(callstack, interpreter, true, ClassGenerator.ClassNodeFilter.CLASSSTATICMETHODS);
            block.evalBlock(callstack, interpreter, true, ClassGenerator.ClassNodeFilter.CLASSSTATICFIELDS);
            for (Variable var : Reflect.getVariables(classStaticNameSpace)) {
                var.validateFinalIsSet(true);
            }
        }
        catch (Exception e) {
            throw new UtilEvalError("Exception in static init block <clinit> for class " + className + ". With message: " + e.getMessage(), e);
        }
    }

    public static This pullBshStatic(String uuid) {
        if (contextStore.containsKey(uuid)) {
            return contextStore.remove(uuid).getThis(null);
        }
        return This.getThis(null, null);
    }

    class Handler
    implements InvocationHandler,
    Serializable {
        Handler() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                return this.invokeImpl(proxy, method, args);
            }
            catch (TargetError te) {
                Throwable t = te.getTarget();
                Class<?> c = t.getClass();
                String msg = t.getMessage();
                try {
                    Throwable t2 = msg == null ? (Throwable)c.getConstructor(new Class[0]).newInstance(new Object[0]) : (Throwable)c.getConstructor(String.class).newInstance(msg);
                    t2.initCause(te);
                    throw t2;
                }
                catch (NoSuchMethodException e) {
                    throw t;
                }
            }
            catch (EvalError ee) {
                Interpreter.debug("EvalError in scripted interface: ", This.this.toString(), ": ", ee);
                throw ee;
            }
        }

        public Object invokeImpl(Object proxy, Method method, Object[] args) throws EvalError {
            String methodName = method.getName();
            BshMethod equalsMethod = Reflect.getMethod(This.this.namespace, "equals", new Class[]{Object.class});
            if (methodName.equals("equals") && equalsMethod == null) {
                Object obj = args[0];
                return proxy == obj;
            }
            BshMethod toStringMethod = Reflect.getMethod(This.this.namespace, "toString", new Class[0]);
            if (methodName.equals("toString") && toStringMethod == null) {
                Class<?>[] ints = proxy.getClass().getInterfaces();
                StringBuilder sb = new StringBuilder(This.this.toString() + "\nimplements:");
                for (int i = 0; i < ints.length; ++i) {
                    sb.append(" " + ints[i].getName() + (ints.length > 1 ? "," : ""));
                }
                return sb.toString();
            }
            Class<?>[] paramTypes = method.getParameterTypes();
            return Primitive.unwrap(This.this.invokeMethod(methodName, Primitive.wrap(args, paramTypes)));
        }
    }

    static enum Keys {
        BSHSTATIC{

            public String toString() {
                return "_bshStatic";
            }
        }
        ,
        BSHTHIS{

            public String toString() {
                return "_bshThis";
            }
        }
        ,
        BSHSUPER{

            public String toString() {
                return "_bshSuper";
            }
        }
        ,
        BSHINIT{

            public String toString() {
                return "_bshInstanceInitializer";
            }
        }
        ,
        BSHCONSTRUCTORS{

            public String toString() {
                return "_bshConstructors";
            }
        }
        ,
        BSHCLASSMODIFIERS{

            public String toString() {
                return "_bshClassModifiers";
            }
        };

    }

    public static class ConstructorArgs {
        public static final ConstructorArgs DEFAULT = new ConstructorArgs();
        public int selector = -1;
        Object[] args;
        int arg;

        ConstructorArgs() {
        }

        ConstructorArgs(int selector, Object[] args) {
            this.selector = selector;
            this.args = args;
        }

        Object next() {
            return this.args[this.arg++];
        }

        public boolean getBoolean() {
            return (Boolean)this.next();
        }

        public byte getByte() {
            return ((Number)this.next()).byteValue();
        }

        public char getChar() {
            return ((Character)this.next()).charValue();
        }

        public short getShort() {
            return ((Number)this.next()).shortValue();
        }

        public int getInt() {
            return ((Number)this.next()).intValue();
        }

        public long getLong() {
            return ((Number)this.next()).longValue();
        }

        public double getDouble() {
            return ((Number)this.next()).doubleValue();
        }

        public float getFloat() {
            return ((Number)this.next()).floatValue();
        }

        public Object getObject() {
            return this.next();
        }
    }
}

