/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.CallStack;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.InterpreterError;
import bsh.Node;
import bsh.Parser;
import bsh.ParserTreeConstants;
import bsh.Token;
import java.io.Serializable;
import java.util.NoSuchElementException;

class SimpleNode
implements Node,
Serializable {
    private static final long serialVersionUID = 1L;
    Token firstToken;
    Token lastToken;
    private String sourceFile;
    protected Node parent;
    protected Node[] children;
    protected int id;
    protected Parser parser;
    private int cursor = 0;
    private int lastRet = -1;

    public SimpleNode(int i) {
        this.id = i;
    }

    @Override
    public boolean hasPrevious() {
        return this.cursor > 0;
    }

    @Override
    public boolean hasNext() {
        return this.cursor < this.jjtGetNumChildren();
    }

    @Override
    public int nextIndex() {
        return this.cursor;
    }

    @Override
    public int previousIndex() {
        return this.cursor - 1;
    }

    @Override
    public Node next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.lastRet = this.cursor++;
        return this.children[this.lastRet];
    }

    @Override
    public Node previous() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        this.lastRet = --this.cursor;
        return this.children[this.cursor];
    }

    @Override
    public void remove() {
        if (this.lastRet < 0) {
            throw new IllegalStateException();
        }
        this.cursor = this.lastRet;
        Node[] c = new Node[this.children.length - 1];
        System.arraycopy(this.children, 0, c, 0, this.cursor);
        System.arraycopy(this.children, this.cursor + 1, c, this.cursor, c.length - this.cursor);
        this.children = c;
        this.lastRet = -1;
    }

    @Override
    public void set(Node e) {
        if (this.lastRet < 0) {
            throw new IllegalStateException();
        }
        this.children[this.lastRet] = e;
    }

    @Override
    public void add(Node e) {
        Node[] c = new Node[this.jjtGetNumChildren() + 1];
        System.arraycopy(this.children, 0, c, 0, this.cursor);
        System.arraycopy(this.children, this.cursor, c, this.cursor + 1, c.length - this.cursor - 1);
        this.children = c;
        this.children[this.cursor++] = e;
        this.lastRet = -1;
        e.jjtSetParent(this);
    }

    @Override
    public void jjtOpen() {
    }

    @Override
    public void jjtClose() {
    }

    @Override
    public void jjtSetParent(Node n) {
        this.parent = n;
    }

    @Override
    public Node jjtGetParent() {
        return this.parent;
    }

    @Override
    public void jjtAddChild(Node n, int i) {
        if (this.children == null) {
            this.children = new Node[i + 1];
        } else if (i >= this.children.length) {
            Node[] c = new Node[i + 1];
            System.arraycopy(this.children, 0, c, 0, this.children.length);
            this.children = c;
        }
        this.children[i] = n;
    }

    @Override
    public Node jjtGetChild(int i) {
        return this.children[i];
    }

    @Override
    public Node[] jjtGetChildren() {
        if (null == this.children) {
            this.children = new Node[0];
        }
        return this.children;
    }

    @Override
    public int jjtGetNumChildren() {
        return this.jjtGetChildren().length;
    }

    public String toString() {
        return ParserTreeConstants.jjtNodeName[this.id];
    }

    @Override
    public String toString(String prefix) {
        return prefix + this.toString();
    }

    @Override
    public void dump(String prefix) {
        System.out.println(this.toString(prefix));
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                Node n = this.children[i];
                if (n == null) continue;
                n.dump(prefix + " ");
            }
        }
    }

    @Override
    public Object eval(CallStack callstack, Interpreter interpreter) throws EvalError {
        throw new InterpreterError("Unimplemented or inappropriate for " + this.getClass().getName());
    }

    @Override
    public void setSourceFile(String sourceFile) {
        this.sourceFile = sourceFile;
    }

    @Override
    public String getSourceFile() {
        if (this.sourceFile == null) {
            if (this.parent != null) {
                return this.parent.getSourceFile();
            }
            return "<unknown file>";
        }
        return this.sourceFile;
    }

    @Override
    public int getLineNumber() {
        return this.firstToken.beginLine;
    }

    @Override
    public String getText() {
        StringBuilder text = new StringBuilder();
        Token t = this.firstToken;
        while (t != null) {
            text.append(t.image);
            if (!t.image.equals(".")) {
                text.append(" ");
            }
            if (t == this.lastToken || t.image.equals("{") || t.image.equals(";")) break;
            t = t.next;
        }
        return text.toString();
    }

    @Override
    public int getId() {
        return this.id;
    }
}

