/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BshClassManager;
import bsh.BshMethod;
import bsh.CallStack;
import bsh.Capabilities;
import bsh.EvalError;
import bsh.GeneratedClass;
import bsh.Interpreter;
import bsh.InterpreterError;
import bsh.Invocable;
import bsh.LHS;
import bsh.Modifiers;
import bsh.NameSpace;
import bsh.Node;
import bsh.Primitive;
import bsh.ReflectError;
import bsh.StringUtil;
import bsh.TargetError;
import bsh.This;
import bsh.Types;
import bsh.UtilEvalError;
import bsh.UtilTargetError;
import bsh.Variable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.Security;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public final class Reflect {
    public static final Object[] ZERO_ARGS = new Object[0];
    public static final Class<?>[] ZERO_TYPES = new Class[0];
    static final String GET_PREFIX = "get";
    static final String SET_PREFIX = "set";
    static final String IS_PREFIX = "is";
    private static final Map<String, String> ACCESSOR_NAMES = new WeakHashMap<String, String>();
    private static final Pattern DEFAULT_PACKAGE = Pattern.compile("[^\\.]+|bsh\\..*");
    private static final Pattern PACKAGE_ACCESS;
    static final Map<Class<?>, Object> instanceCache;

    public static Object invokeObjectMethod(Object object, String methodName, Object[] args, Interpreter interpreter, CallStack callstack, Node callerInfo) throws EvalError {
        if (object instanceof This && !This.isExposedThisMethod(methodName)) {
            return ((This)object).invokeMethod(methodName, args, interpreter, callstack, callerInfo, false);
        }
        BshClassManager bcm = interpreter.getClassManager();
        boolean isPrimitive = object instanceof Primitive;
        try {
            Class<?> type = object.getClass();
            if (isPrimitive) {
                if (methodName.equals("equals")) {
                    return ((Primitive)object).equals(args[0]);
                }
                if (object != Primitive.NULL && object != Primitive.VOID) {
                    type = ((Primitive)object).getType();
                    object = Primitive.unwrap(object);
                }
                if (methodName.equals("getType") || methodName.equals("getClass")) {
                    return object == Primitive.VOID ? ((Primitive)object).getType() : type;
                }
            }
            try {
                Invocable method = Reflect.resolveExpectedJavaMethod(bcm, type, object, methodName, args, false);
                NameSpace ns = Reflect.getThisNS(object);
                if (null != ns) {
                    ns.setNode(callerInfo);
                }
                return method.invoke(object, args);
            }
            catch (ReflectError re) {
                if (object == Primitive.VOID) {
                    throw new EvalError("Attempt to invoke method: " + methodName + "() on undefined", callerInfo, callstack, re);
                }
                if (isPrimitive && !interpreter.getStrictJava()) {
                    try {
                        if (!Types.isNumeric(object)) {
                            return Reflect.invokeObjectMethod(object, methodName, args, interpreter, callstack, callerInfo);
                        }
                        return Reflect.numericMathMethod(object, type, methodName, args, interpreter, callstack, callerInfo);
                    }
                    catch (TargetError te) {
                        throw te;
                    }
                    catch (EvalError evalError) {
                        // empty catch block
                    }
                }
                throw new EvalError("Error in method invocation: " + re.getMessage(), callerInfo, callstack, re);
            }
            catch (InvocationTargetException e) {
                throw Reflect.targetErrorFromTargetException(e, methodName, callstack, callerInfo);
            }
        }
        catch (UtilEvalError e) {
            throw e.toEvalError(callerInfo, callstack);
        }
    }

    static TargetError targetErrorFromTargetException(InvocationTargetException e, String methodName, CallStack callstack, Node callerInfo) {
        String msg = "Method Invocation " + methodName;
        Throwable te = e.getCause();
        boolean isNative = true;
        if (te instanceof EvalError) {
            isNative = te instanceof TargetError && ((TargetError)te).inNativeCode();
        }
        return new TargetError(msg, te, callerInfo, callstack, isNative);
    }

    private static Object numericMathMethod(Object object, Class<?> type, String methodName, Object[] args, Interpreter interpreter, CallStack callstack, Node callerInfo) throws EvalError {
        Class mathType = Types.isFloatingpoint(object) ? BigDecimal.class : BigInteger.class;
        try {
            return Reflect.invokeMathMethod(mathType, object, type, methodName, args, interpreter, callstack, callerInfo);
        }
        catch (TargetError te) {
            throw te.reThrow("Method found on " + mathType.getSimpleName() + " but with error");
        }
        catch (EvalError ee) {
            return Reflect.invokeMathMethod(Types.isFloatingpoint(object) ? BigInteger.class : BigDecimal.class, object, type, methodName, args, interpreter, callstack, callerInfo);
        }
    }

    private static Object invokeMathMethod(Class<?> mathType, Object object, Class<?> returnType, String methodName, Object[] args, Interpreter interpreter, CallStack callstack, Node callerInfo) throws EvalError {
        Object retrn = Reflect.invokeObjectMethod(Primitive.castWrapper(mathType, object), methodName, args, interpreter, callstack, callerInfo);
        if (retrn instanceof Primitive && ((Primitive)retrn).getType() == mathType) {
            return Primitive.wrap(Primitive.castWrapper(returnType, retrn), returnType);
        }
        return retrn;
    }

    public static Object invokeStaticMethod(BshClassManager bcm, Class<?> clas, String methodName, Object[] args, Node callerInfo) throws ReflectError, UtilEvalError, InvocationTargetException {
        Interpreter.debug("invoke static Method");
        NameSpace ns = Reflect.getThisNS(clas);
        if (null != ns) {
            ns.setNode(callerInfo);
        }
        Invocable method = Reflect.resolveExpectedJavaMethod(bcm, clas, null, methodName, args, true);
        return method.invoke(null, args);
    }

    public static Object getStaticFieldValue(Class<?> clas, String fieldName) throws UtilEvalError, ReflectError {
        return Reflect.getFieldValue(clas, null, fieldName, true);
    }

    public static Object getObjectFieldValue(Object object, String fieldName) throws UtilEvalError, ReflectError {
        if (object instanceof This) {
            return ((This)object).namespace.getVariable(fieldName);
        }
        if (object == Primitive.NULL) {
            throw new UtilTargetError(new NullPointerException("Attempt to access field '" + fieldName + "' on null value"));
        }
        try {
            return Reflect.getFieldValue(object.getClass(), object, fieldName, false);
        }
        catch (ReflectError e) {
            if (Reflect.hasObjectPropertyGetter(object.getClass(), fieldName)) {
                return Reflect.getObjectProperty(object, fieldName);
            }
            throw e;
        }
    }

    static LHS getLHSStaticField(Class<?> clas, String fieldName) throws UtilEvalError, ReflectError {
        try {
            Invocable f = Reflect.resolveExpectedJavaField(clas, fieldName, true);
            return new LHS(f);
        }
        catch (ReflectError e) {
            Variable var;
            NameSpace ns = Reflect.getThisNS(clas);
            if (Reflect.isGeneratedClass(clas) && null != ns && ns.isClass && null != (var = ns.getVariableImpl(fieldName, true)) && (!var.hasModifier("private") || Capabilities.haveAccessibility())) {
                return new LHS(ns, fieldName);
            }
            if (Reflect.hasObjectPropertySetter(clas, fieldName)) {
                return new LHS(clas, (Object)fieldName);
            }
            throw e;
        }
    }

    static LHS getLHSObjectField(Object object, String fieldName) throws UtilEvalError, ReflectError {
        if (object instanceof This) {
            return new LHS(((This)object).namespace, fieldName, false);
        }
        try {
            Invocable f = Reflect.resolveExpectedJavaField(object.getClass(), fieldName, false);
            return new LHS(object, f);
        }
        catch (ReflectError e) {
            Variable var;
            NameSpace ns = Reflect.getThisNS(object);
            if (Reflect.isGeneratedClass(object.getClass()) && null != ns && ns.isClass && null != (var = ns.getVariableImpl(fieldName, true)) && (!var.hasModifier("private") || Capabilities.haveAccessibility())) {
                return new LHS(ns, fieldName);
            }
            if (Reflect.hasObjectPropertySetter(object.getClass(), fieldName)) {
                return new LHS(object, (Object)fieldName);
            }
            throw e;
        }
    }

    private static Object getFieldValue(Class<?> clas, Object object, String fieldName, boolean staticOnly) throws UtilEvalError, ReflectError {
        try {
            Invocable f = Reflect.resolveExpectedJavaField(clas, fieldName, staticOnly);
            return f.invoke(object, new Object[0]);
        }
        catch (ReflectError e) {
            NameSpace ns = Reflect.getThisNS(clas);
            if (Reflect.isGeneratedClass(clas) && null != ns && ns.isClass) {
                if (staticOnly) {
                    Variable var = ns.getVariableImpl(fieldName, true);
                    Object val = Primitive.VOID;
                    if (null != var && (!var.hasModifier("private") || Capabilities.haveAccessibility())) {
                        val = ns.unwrapVariable(var);
                    }
                    if (Primitive.VOID != val) {
                        return val;
                    }
                } else {
                    ns = Reflect.getThisNS(object);
                    if (null != ns) {
                        Variable var = ns.getVariableImpl(fieldName, true);
                        Object val = Primitive.VOID;
                        if (null != var && (!var.hasModifier("private") || Capabilities.haveAccessibility())) {
                            val = ns.unwrapVariable(var);
                        }
                        if (Primitive.VOID != val) {
                            return val;
                        }
                    }
                }
            }
            throw e;
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof InterpreterError) {
                throw (InterpreterError)e.getCause();
            }
            if (e.getCause() instanceof UtilEvalError) {
                throw new UtilTargetError(e.getCause());
            }
            throw new ReflectError("Can't access field: " + fieldName, e.getCause());
        }
    }

    protected static Invocable resolveJavaField(Class<?> clas, String fieldName, boolean staticOnly) throws UtilEvalError {
        try {
            return Reflect.resolveExpectedJavaField(clas, fieldName, staticOnly);
        }
        catch (ReflectError e) {
            return null;
        }
    }

    protected static Invocable resolveExpectedJavaField(Class<?> clas, String fieldName, boolean staticOnly) throws UtilEvalError, ReflectError {
        Invocable field = BshClassManager.memberCache.get(clas).findField(fieldName);
        if (null == field) {
            throw new ReflectError("No such field: " + fieldName + " for class: " + clas.getName());
        }
        if (staticOnly && !field.isStatic()) {
            throw new UtilEvalError("Can't reach instance field: " + fieldName + " from static context: " + clas.getName());
        }
        return field;
    }

    protected static Invocable resolveExpectedJavaMethod(BshClassManager bcm, Class<?> clas, Object object, String name, Object[] args, boolean staticOnly) throws ReflectError, UtilEvalError {
        if (object == Primitive.NULL) {
            throw new UtilTargetError(new NullPointerException("Attempt to invoke method " + name + " on null value"));
        }
        Class<?>[] types = Types.getTypes(args);
        Invocable method = Reflect.resolveJavaMethod(clas, name, types, staticOnly);
        if (null != bcm && bcm.getStrictJava() && method != null && method.getDeclaringClass().isInterface() && method.getDeclaringClass() != clas && Modifier.isStatic(method.getModifiers())) {
            method = null;
        }
        if (method == null) {
            throw new ReflectError((staticOnly ? "Static method " : "Method ") + StringUtil.methodString(name, types) + " not found in class'" + clas.getName() + "'");
        }
        return method;
    }

    protected static Invocable resolveJavaMethod(Class<?> clas, String name, Class<?>[] types, boolean staticOnly) throws UtilEvalError {
        if (clas == null) {
            throw new InterpreterError("null class");
        }
        Invocable method = BshClassManager.memberCache.get(clas).findMethod(name, types);
        Interpreter.debug("resolved java method: ", method, " on class: ", clas);
        Reflect.checkFoundStaticMethod(method, staticOnly, clas);
        return method;
    }

    static BshMethod staticMethodImport(Class<?> baseClass, String methodName) {
        Invocable method = BshClassManager.memberCache.get(baseClass).findStaticMethod(methodName);
        if (null != method) {
            return new BshMethod(method, null);
        }
        return null;
    }

    static Object constructObject(Class<?> clas, Object[] args) throws ReflectError, InvocationTargetException {
        return Reflect.constructObject(clas, null, args);
    }

    static Object constructObject(Class<?> clas, Object object, Object[] args) throws ReflectError, InvocationTargetException {
        if (null == clas) {
            return Primitive.NULL;
        }
        if (clas.isInterface()) {
            throw new ReflectError("Can't create instance of an interface: " + clas);
        }
        Class<?>[] types = Types.getTypes(args);
        if (clas.isMemberClass() && !Reflect.isStatic(clas) && null != object) {
            types = (Class[])Stream.concat(Stream.of(object.getClass()), Stream.of(types)).toArray(Class[]::new);
        }
        Interpreter.debug("Looking for most specific constructor: ", clas);
        Invocable con = BshClassManager.memberCache.get(clas).findMethod(clas.getName(), types);
        if (con == null || args.length != con.getParameterCount() && !con.isVarArgs() && !con.isInnerClass()) {
            throw Reflect.cantFindConstructor(clas, types);
        }
        try {
            return con.invoke(object, args);
        }
        catch (InvocationTargetException e) {
            if (e.getCause().getCause() instanceof IllegalAccessException) {
                throw new ReflectError("We don't have permission to create an instance. " + e.getCause().getCause().getMessage() + " Use setAccessibility(true) to enable access.", e.getCause().getCause());
            }
            throw e;
        }
    }

    public static BshMethod findMostSpecificBshMethod(Class<?>[] idealMatch, List<BshMethod> methods) {
        Interpreter.debug("find most specific BshMethod for: " + Arrays.toString(idealMatch));
        int match = Reflect.findMostSpecificBshMethodIndex(idealMatch, methods);
        return match == -1 ? null : methods.get(match);
    }

    public static int findMostSpecificBshMethodIndex(Class<?>[] idealMatch, List<BshMethod> methods) {
        for (int i = 0; i < methods.size(); ++i) {
            Interpreter.debug("  " + i + ":" + methods.get(i).toString() + " " + methods.get(i).getClass().getName());
        }
        ArrayList<Object[]> candidateSigs = new ArrayList<Object[]>();
        ArrayList<Integer> remap = new ArrayList<Integer>();
        int i = 0;
        for (BshMethod m : methods) {
            Class<?>[] parameterTypes = m.getParameterTypes();
            if (idealMatch.length == parameterTypes.length) {
                remap.add(i);
                candidateSigs.add(parameterTypes);
            }
            ++i;
        }
        Class[][] sigs = (Class[][])candidateSigs.toArray((T[])new Class[candidateSigs.size()][]);
        int match = Reflect.findMostSpecificSignature(idealMatch, sigs);
        if (match >= 0) {
            match = (Integer)remap.get(match);
            Interpreter.debug(" remap: " + remap);
            Interpreter.debug(" match:" + match);
            return match;
        }
        candidateSigs.clear();
        remap.clear();
        i = 0;
        for (BshMethod m : methods) {
            Class<?>[] parameterTypes = m.getParameterTypes();
            if (m.isVarArgs() && idealMatch.length >= parameterTypes.length - 1) {
                Object[] candidateSig = new Class[idealMatch.length];
                System.arraycopy(parameterTypes, 0, candidateSig, 0, parameterTypes.length - 1);
                Class<?> arrayCompType = parameterTypes[parameterTypes.length - 1].getComponentType();
                Arrays.fill(candidateSig, parameterTypes.length - 1, idealMatch.length, arrayCompType);
                remap.add(i);
                candidateSigs.add(candidateSig);
            }
            ++i;
        }
        sigs = (Class[][])candidateSigs.toArray((T[])new Class[candidateSigs.size()][]);
        match = Reflect.findMostSpecificSignature(idealMatch, sigs);
        if (match >= 0) {
            match = (Integer)remap.get(match);
            Interpreter.debug(" remap (varargs): " + Arrays.toString((Object[])remap.toArray(new Integer[0])));
            Interpreter.debug(" match (varargs):" + match);
        }
        return match;
    }

    public static Invocable findMostSpecificInvocable(Class<?>[] idealMatch, List<Invocable> methods) {
        Interpreter.debug("find most specific Invocable for: " + Arrays.toString(idealMatch));
        int match = Reflect.findMostSpecificInvocableIndex(idealMatch, methods);
        return match == -1 ? null : methods.get(match);
    }

    public static int findMostSpecificInvocableIndex(Class<?>[] idealMatch, List<Invocable> methods) {
        for (int i = 0; i < methods.size(); ++i) {
            Interpreter.debug("  " + i + "=" + methods.get(i).toString());
        }
        ArrayList<Object[]> candidateSigs = new ArrayList<Object[]>();
        ArrayList<Integer> remap = new ArrayList<Integer>();
        int i = 0;
        for (Invocable method : methods) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (idealMatch.length == parameterTypes.length) {
                remap.add(i);
                candidateSigs.add(parameterTypes);
            }
            ++i;
        }
        Class[][] sigs = (Class[][])candidateSigs.toArray((T[])new Class[candidateSigs.size()][]);
        int match = Reflect.findMostSpecificSignature(idealMatch, sigs);
        if (match >= 0) {
            match = (Integer)remap.get(match);
            Interpreter.debug(" remap=" + Arrays.toString((Object[])remap.toArray(new Integer[0])));
            Interpreter.debug(" match=" + match);
            return match;
        }
        candidateSigs.clear();
        remap.clear();
        i = 0;
        for (Invocable method : methods) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (method.isVarArgs() && idealMatch.length >= parameterTypes.length - 1) {
                Object[] candidateSig = new Class[idealMatch.length];
                System.arraycopy(parameterTypes, 0, candidateSig, 0, parameterTypes.length - 1);
                Arrays.fill(candidateSig, parameterTypes.length - 1, idealMatch.length, method.getVarArgsComponentType());
                remap.add(i);
                candidateSigs.add(candidateSig);
            }
            ++i;
        }
        sigs = (Class[][])candidateSigs.toArray((T[])new Class[candidateSigs.size()][]);
        match = Reflect.findMostSpecificSignature(idealMatch, sigs);
        if (match >= 0) {
            match = (Integer)remap.get(match);
        }
        Interpreter.debug(" remap (varargs) =" + Arrays.toString((Object[])remap.toArray(new Integer[0])));
        Interpreter.debug(" match (varargs) =" + match);
        return match;
    }

    static int findMostSpecificSignature(Class<?>[] idealMatch, Class<?>[][] candidates) {
        for (int round = 1; round <= 4; ++round) {
            Class<?>[] bestMatch = null;
            int bestMatchIndex = -1;
            for (int i = 0; i < candidates.length; ++i) {
                Class<?>[] targetMatch = candidates[i];
                if (null != bestMatch && Types.areSignaturesEqual(targetMatch, bestMatch) || !Types.isSignatureAssignable(idealMatch, targetMatch, round) || bestMatch != null && !Types.areSignaturesEqual(idealMatch, targetMatch) && (!Types.isSignatureAssignable(targetMatch, bestMatch, 1) || Types.areSignaturesEqual(idealMatch, bestMatch))) continue;
                bestMatch = targetMatch;
                bestMatchIndex = i;
            }
            if (bestMatch == null) continue;
            return bestMatchIndex;
        }
        return -1;
    }

    static String accessorName(String prefix, String propName) {
        if (!ACCESSOR_NAMES.containsKey(propName)) {
            char[] ch = propName.toCharArray();
            ch[0] = Character.toUpperCase(ch[0]);
            ACCESSOR_NAMES.put(propName, new String(ch));
        }
        return prefix + ACCESSOR_NAMES.get(propName);
    }

    public static boolean hasObjectPropertyGetter(Class<?> clas, String propName) {
        if (Types.isPropertyType(clas)) {
            return true;
        }
        return BshClassManager.memberCache.get(clas).hasMember(propName) && null != BshClassManager.memberCache.get(clas).findGetter(propName);
    }

    public static boolean hasObjectPropertySetter(Class<?> clas, String propName) {
        if (Types.isPropertyType(clas)) {
            return true;
        }
        return BshClassManager.memberCache.get(clas).hasMember(propName) && null != BshClassManager.memberCache.get(clas).findSetter(propName);
    }

    public static Object getObjectProperty(Object obj, String propName) {
        if (Types.isPropertyTypeEntry(obj)) {
            switch (propName) {
                case "key": {
                    return ((Map.Entry)obj).getKey();
                }
                case "val": 
                case "value": {
                    return ((Map.Entry)obj).getValue();
                }
            }
        }
        return Reflect.getObjectProperty(obj, (Object)propName);
    }

    public static Object getObjectProperty(Object obj, Object propName) {
        Invocable getter;
        if (Types.isPropertyTypeMap(obj)) {
            Map map = (Map)obj;
            if (map.containsKey(propName)) {
                return map.get(propName);
            }
            return Primitive.VOID;
        }
        if (Types.isPropertyTypeEntry(obj)) {
            Map.Entry entre = (Map.Entry)obj;
            if (propName.equals(entre.getKey())) {
                return entre.getValue();
            }
            return Primitive.VOID;
        }
        Class cls = obj.getClass();
        if (Types.isPropertyTypeEntryList(cls)) {
            Map.Entry entre = Reflect.getEntryForKey(propName, (Map.Entry[])obj);
            if (null != entre) {
                return entre.getValue();
            }
            return Primitive.VOID;
        }
        if (obj instanceof Class) {
            cls = (Class)obj;
        }
        if (null == (getter = BshClassManager.memberCache.get(cls).findGetter(propName.toString()))) {
            Interpreter.debug("property getter not found");
            return Primitive.VOID;
        }
        try {
            return getter.invoke(obj, new Object[0]);
        }
        catch (InvocationTargetException e) {
            Interpreter.debug("Property accessor threw exception");
            return Primitive.VOID;
        }
    }

    public static Map.Entry getEntryForKey(Object key, Map.Entry[] entries) {
        for (Map.Entry ntre : entries) {
            if (!key.equals(ntre.getKey())) continue;
            return ntre;
        }
        return null;
    }

    public static Object setObjectProperty(Object obj, String propName, Object value) {
        if (Types.isPropertyTypeEntry(obj)) {
            switch (propName) {
                case "val": 
                case "value": {
                    return ((Map.Entry)obj).setValue(value);
                }
            }
        }
        return Reflect.setObjectProperty(obj, (Object)propName, value);
    }

    public static Object setObjectProperty(Object obj, Object propName, Object value) {
        Invocable setter;
        if (Types.isPropertyTypeMap(obj)) {
            return ((Map)obj).put(propName, Primitive.unwrap(value));
        }
        if (Types.isPropertyTypeEntry(obj)) {
            Map.Entry entre = (Map.Entry)obj;
            if (propName.equals(entre.getKey())) {
                return entre.setValue(Primitive.unwrap(value));
            }
            throw new ReflectError("No such property setter: " + propName + " for type: " + StringUtil.typeString(obj));
        }
        Class cls = obj.getClass();
        if (Types.isPropertyTypeEntryList(cls)) {
            return Reflect.getEntryForKey(propName, (Map.Entry[])obj).setValue(Primitive.unwrap(value));
        }
        if (obj instanceof Class) {
            cls = (Class)obj;
        }
        if (null == (setter = BshClassManager.memberCache.get(cls).findSetter(propName.toString()))) {
            throw new ReflectError("No such property setter: " + propName + " for type: " + StringUtil.typeString(cls));
        }
        try {
            return setter.invoke(obj, Primitive.unwrap(value));
        }
        catch (InvocationTargetException e) {
            throw new ReflectError("Property accessor threw exception: " + e.getCause(), e.getCause());
        }
    }

    public static Object invokeCompiledCommand(Class<?> commandClass, Object[] args, Interpreter interpreter, CallStack callstack, Node callerInfo) throws UtilEvalError {
        Object[] invokeArgs = new Object[args.length + 2];
        invokeArgs[0] = interpreter;
        invokeArgs[1] = callstack;
        System.arraycopy(args, 0, invokeArgs, 2, args.length);
        BshClassManager bcm = interpreter.getClassManager();
        try {
            return Reflect.invokeStaticMethod(bcm, commandClass, "invoke", invokeArgs, callerInfo);
        }
        catch (InvocationTargetException e) {
            throw new UtilEvalError("Error in compiled command: " + e.getCause(), e);
        }
        catch (ReflectError e) {
            throw new UtilEvalError("Error invoking compiled command: " + e, e);
        }
    }

    static void logInvokeMethod(String msg, Invocable method, List<Object> params) {
        if (Interpreter.DEBUG.get().booleanValue()) {
            Reflect.logInvokeMethod(msg, method, params.toArray());
        }
    }

    static void logInvokeMethod(String msg, Invocable method, Object[] args) {
        if (Interpreter.DEBUG.get().booleanValue()) {
            Interpreter.debug(msg, method, " with args:");
            for (int i = 0; i < args.length; ++i) {
                Object arg = args[i];
                Interpreter.debug("args[", i, "] = ", arg, " type = ", arg == null ? "<unknown>" : arg.getClass());
            }
        }
    }

    private static void checkFoundStaticMethod(Invocable method, boolean staticOnly, Class<?> clas) throws UtilEvalError {
        if (method != null && staticOnly && !method.isStatic()) {
            throw new UtilEvalError("Cannot reach instance method: " + StringUtil.methodString(method.getName(), method.getParameterTypes()) + " from static context: " + clas.getName());
        }
    }

    private static ReflectError cantFindConstructor(Class<?> clas, Class<?>[] types) {
        if (types.length == 0) {
            return new ReflectError("Can't find default constructor for: " + clas);
        }
        return new ReflectError("Can't find constructor: " + StringUtil.methodString(clas.getName(), types) + " in class: " + clas.getName());
    }

    public static boolean isGeneratedClass(Class<?> type) {
        return null != type && type != GeneratedClass.class && GeneratedClass.class.isAssignableFrom(type);
    }

    public static This getClassStaticThis(Class<?> clas, String className) {
        try {
            return (This)Reflect.getStaticFieldValue(clas, (Object)((Object)This.Keys.BSHSTATIC) + className);
        }
        catch (Exception e) {
            throw new InterpreterError("Unable to get class static space: " + e, e);
        }
    }

    public static This getClassInstanceThis(Object instance, String className) {
        try {
            Object o = Reflect.getObjectFieldValue(instance, (Object)((Object)This.Keys.BSHTHIS) + className);
            return (This)Primitive.unwrap(o);
        }
        catch (Exception e) {
            throw new InterpreterError("Generated class: Error getting This " + e, e);
        }
    }

    public static NameSpace getThisNS(Class<?> type) {
        if (!Reflect.isGeneratedClass(type)) {
            return null;
        }
        try {
            return Reflect.getClassStaticThis(type, (String)type.getSimpleName()).namespace;
        }
        catch (Exception e) {
            if (e.getCause() instanceof UtilTargetError) {
                throw new InterpreterError(e.getCause().getCause().getMessage(), e.getCause().getCause());
            }
            return null;
        }
    }

    public static NameSpace getThisNS(Object object) {
        if (null == object) {
            return null;
        }
        Class<?> type = object.getClass();
        if (!Reflect.isGeneratedClass(type)) {
            return null;
        }
        try {
            if (object instanceof Proxy) {
                return Reflect.getThisNS(type.getInterfaces()[0]);
            }
            return Reflect.getClassInstanceThis((Object)object, (String)type.getSimpleName()).namespace;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String[] getVariableNames(NameSpace ns) {
        if (ns == null) {
            return new String[0];
        }
        return (String[])Stream.of(ns.getVariableNames()).filter(name -> !name.matches("_?bsh.*")).toArray(String[]::new);
    }

    public static String[] getMethodNames(NameSpace ns) {
        if (ns == null) {
            return new String[0];
        }
        return ns.getMethodNames();
    }

    public static BshMethod getMethod(Class<?> type, String name, Class<?>[] sig) {
        return Reflect.getMethod(Reflect.getThisNS(type), name, sig);
    }

    public static BshMethod getMethod(Object object, String name, Class<?>[] sig) {
        return Reflect.getMethod(Reflect.getThisNS(object), name, sig);
    }

    public static BshMethod getMethod(NameSpace ns, String name, Class<?>[] sig) {
        return Reflect.getMethod(ns, name, sig, true);
    }

    public static BshMethod getMethod(NameSpace ns, String name, Class<?>[] sig, boolean declaredOnly) {
        if (null == ns) {
            return null;
        }
        try {
            return ns.getMethod(name, sig, declaredOnly);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static BshMethod getDeclaredMethod(Class<?> type, String name, Class<?>[] sig) {
        if (!Reflect.isGeneratedClass(type)) {
            return null;
        }
        BshMethod meth = Reflect.getMethod(type, name, sig);
        if (null == meth && !type.isInterface()) {
            return Reflect.getMethod(Reflect.getNewInstance(type), name, sig);
        }
        return meth;
    }

    public static BshMethod[] getMethods(Class<?> type) {
        return Reflect.getMethods(Reflect.getThisNS(type));
    }

    public static BshMethod[] getMethods(Object object) {
        return Reflect.getMethods(Reflect.getThisNS(object));
    }

    public static BshMethod[] getMethods(NameSpace ns) {
        if (ns == null) {
            return new BshMethod[0];
        }
        return ns.getMethods();
    }

    public static BshMethod[] getDeclaredMethods(Class<?> type) {
        if (!Reflect.isGeneratedClass(type)) {
            return new BshMethod[0];
        }
        if (type.isInterface()) {
            return Reflect.getMethods(type);
        }
        return Reflect.getMethods(Reflect.getNewInstance(type));
    }

    public static Variable getVariable(Class<?> type, String name) {
        return Reflect.getVariable(Reflect.getThisNS(type), name);
    }

    public static Variable getVariable(Object object, String name) {
        return Reflect.getVariable(Reflect.getThisNS(object), name);
    }

    public static Variable getVariable(NameSpace ns, String name) {
        if (null == ns) {
            return null;
        }
        try {
            return ns.getVariableImpl(name, false);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Variable getDeclaredVariable(Class<?> type, String name) {
        if (!Reflect.isGeneratedClass(type)) {
            return null;
        }
        Variable var = Reflect.getVariable(type, name);
        if (null == var && !type.isInterface()) {
            return Reflect.getVariable(Reflect.getNewInstance(type), name);
        }
        return var;
    }

    public static Variable[] getVariables(Class<?> type) {
        return Reflect.getVariables(Reflect.getThisNS(type));
    }

    public static Variable[] getVariables(Object object) {
        return Reflect.getVariables(Reflect.getThisNS(object));
    }

    public static Variable[] getVariables(NameSpace ns) {
        return Reflect.getVariables(ns, Reflect.getVariableNames(ns));
    }

    public static Variable[] getVariables(NameSpace ns, String[] names) {
        if (null == ns || null == names) {
            return new Variable[0];
        }
        return (Variable[])Stream.of(names).map(name -> Reflect.getVariable(ns, name)).filter(Objects::nonNull).toArray(Variable[]::new);
    }

    public static Variable[] getDeclaredVariables(Class<?> type) {
        if (!Reflect.isGeneratedClass(type)) {
            return new Variable[0];
        }
        if (type.isInterface()) {
            return Reflect.getVariables(type);
        }
        return Reflect.getVariables(Reflect.getNewInstance(type));
    }

    public static Modifiers getClassModifiers(Class<?> type) {
        try {
            return (Modifiers)Reflect.getVariable(type, This.Keys.BSHCLASSMODIFIERS.toString()).getValue();
        }
        catch (Exception e) {
            return new Modifiers(type.isInterface() ? 1 : 0);
        }
    }

    public static Object getNewInstance(Class<?> type) {
        if (instanceCache.containsKey(type)) {
            return instanceCache.get(type);
        }
        try {
            instanceCache.put(type, type.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (IllegalArgumentException | ReflectiveOperationException | SecurityException e) {
            instanceCache.put(type, null);
        }
        return instanceCache.get(type);
    }

    static boolean isPrivate(Member member) {
        return Modifier.isPrivate(member.getModifiers());
    }

    static boolean isPrivate(Class<?> clazz) {
        return Modifier.isPrivate(clazz.getModifiers());
    }

    static boolean isPublic(Member member) {
        return Modifier.isPublic(member.getModifiers());
    }

    static boolean isPublic(Class<?> clazz) {
        return Modifier.isPublic(clazz.getModifiers());
    }

    public static boolean isStatic(Member member) {
        return Modifier.isStatic(member.getModifiers());
    }

    public static boolean isStatic(Class<?> clazz) {
        return Modifier.isStatic(clazz.getModifiers());
    }

    public static boolean hasModifier(String name, int modifiers) {
        return Modifier.toString(modifiers).contains(name);
    }

    public static boolean isPackageScope(Class<?> clazz) {
        return DEFAULT_PACKAGE.matcher(clazz.getName()).matches();
    }

    public static boolean isPackageAccessible(Class<?> clazz) {
        return Capabilities.haveAccessibility() || !PACKAGE_ACCESS.matcher(clazz.getName()).matches();
    }

    static <T> T[] getEnumConstants(Class<T> enm) {
        return Stream.of(enm.getFields()).filter(f -> f.getType() == enm).map(f -> {
            try {
                return f.get(null);
            }
            catch (Exception e) {
                return null;
            }
        }).filter(Objects::nonNull).toArray(len -> (Object[])Array.newInstance(enm, len));
    }

    static {
        String packageAccess = Security.getProperty("package.access");
        if (null == packageAccess) {
            packageAccess = "null";
        }
        PACKAGE_ACCESS = Pattern.compile("(?:" + packageAccess.replace(',', '|') + ").*");
        instanceCache = new WeakHashMap();
    }
}

