/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.InterpreterError;
import bsh.StringUtil;
import bsh.Types;
import bsh.UtilEvalError;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;

public final class Primitive
implements Serializable {
    private static final long serialVersionUID = 1L;
    static final Map<Class<?>, Class<?>> wrapperMap = new HashMap();
    private Object value;
    public static final Primitive TRUE;
    public static final Primitive FALSE;
    public static final Primitive ZERO_CHAR;
    public static final Primitive ZERO_BYTE;
    public static final Primitive ZERO_SHORT;
    public static final Primitive ZERO_INT;
    public static final Primitive ZERO_LONG;
    public static final Primitive ZERO_FLOAT;
    public static final Primitive ZERO_DOUBLE;
    public static final Primitive ZERO_BIG_INTEGER;
    public static final Primitive ZERO_BIG_DECIMAL;
    public static final Primitive NULL;
    public static final Primitive VOID;
    private static final BigInteger INTEGER_MAX;
    private static final BigInteger INTEGER_MIN;
    static final BigInteger LONG_MAX;
    static final BigInteger LONG_MIN;

    private Object readResolve() throws ObjectStreamException {
        if (this.value == Special.NULL_VALUE) {
            return NULL;
        }
        return this;
    }

    private Primitive(Object value) {
        if (value == null) {
            throw new InterpreterError("Use Primitve.NULL instead of Primitive(null)");
        }
        this.value = value;
    }

    public Primitive(boolean value) {
        this(value ? Boolean.TRUE : Boolean.FALSE);
    }

    public Primitive(byte value) {
        this((Object)value);
    }

    public Primitive(short value) {
        this((Object)value);
    }

    public Primitive(char value) {
        this(Character.valueOf(value));
    }

    public Primitive(int value) {
        this((Object)value);
    }

    public Primitive(long value) {
        this((Object)value);
    }

    public Primitive(float value) {
        this(Float.valueOf(value));
    }

    public Primitive(double value) {
        this((Object)value);
    }

    public Primitive(BigInteger value) {
        this((Object)value);
    }

    public Primitive(BigDecimal value) {
        this((Object)(null != value && value.scale() == 0 ? value.setScale(1) : value));
    }

    public Object getValue() {
        if (this.value == Special.NULL_VALUE) {
            return null;
        }
        if (this.value == Special.VOID_TYPE) {
            throw new InterpreterError("attempt to unwrap void type");
        }
        return this.value;
    }

    public String toString() {
        if (this.value == Special.NULL_VALUE) {
            return "null";
        }
        if (this.value == Special.VOID_TYPE) {
            return "void";
        }
        return this.value.toString();
    }

    public Class<?> getType() {
        if (this == VOID) {
            return Void.TYPE;
        }
        if (this == NULL) {
            return null;
        }
        return Primitive.unboxType(this.value.getClass());
    }

    public static Primitive shrinkWrap(Object number) {
        BigInteger bi;
        if (!(number instanceof Number)) {
            throw new InterpreterError("Can only shrink wrap Number types");
        }
        Number value = (Number)number;
        if (Types.isFloatingpoint(number)) {
            if (!Double.isInfinite(value.doubleValue())) {
                return new Primitive(value.doubleValue());
            }
            return new Primitive((BigDecimal)number);
        }
        BigInteger bigInteger = bi = number instanceof BigInteger ? (BigInteger)number : BigInteger.valueOf(value.longValue());
        if (bi.compareTo(INTEGER_MIN) >= 0 && bi.compareTo(INTEGER_MAX) <= 0) {
            return new Primitive(bi.intValue());
        }
        if (bi.compareTo(LONG_MIN) >= 0 && bi.compareTo(LONG_MAX) <= 0) {
            return new Primitive(bi.longValue());
        }
        return new Primitive(bi);
    }

    public boolean isNumber() {
        return !(this.value instanceof Boolean) && this != NULL && this != VOID && Types.isNumeric(this.value);
    }

    public Number numberValue() {
        Object value = this.value;
        if (value instanceof Character) {
            value = (int)((Character)value).charValue();
        }
        if (value instanceof Number) {
            return (Number)value;
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1 : 0;
        }
        throw new InterpreterError("Primitive not a number");
    }

    public boolean equals(Object obj) {
        Primitive pobj;
        if (!(obj instanceof Primitive)) {
            if (wrapperMap.containsKey(obj.getClass())) {
                obj = new Primitive(obj);
            } else {
                return false;
            }
        }
        if ((pobj = (Primitive)obj).isNumber() && this.isNumber()) {
            if (this.getType() == BigDecimal.class) {
                return this.value.equals(Primitive.castNumber(BigDecimal.class, pobj.numberValue()));
            }
            if (pobj.getType() == BigDecimal.class) {
                return pobj.value.equals(Primitive.castNumber(BigDecimal.class, this.numberValue()));
            }
            if (Types.isFloatingpoint(this.value) || Types.isFloatingpoint(pobj.value)) {
                return this.numberValue().doubleValue() == pobj.numberValue().doubleValue();
            }
            if (this.getType() == BigInteger.class) {
                return this.value.equals(Primitive.castNumber(BigInteger.class, pobj.numberValue()));
            }
            if (pobj.getType() == BigInteger.class) {
                return pobj.value.equals(Primitive.castNumber(BigInteger.class, this.numberValue()));
            }
            return this.numberValue().longValue() == pobj.numberValue().longValue();
        }
        return this.value.equals(pobj.value);
    }

    public int hashCode() {
        return this.value.hashCode() * 21;
    }

    public static Object unwrap(Object obj) {
        if (obj == VOID) {
            return null;
        }
        if (obj instanceof Primitive) {
            return ((Primitive)obj).getValue();
        }
        return obj;
    }

    public static Object[] unwrap(Object[] args) {
        if (args == null) {
            return null;
        }
        Object[] oa = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            oa[i] = Primitive.unwrap(args[i]);
        }
        return oa;
    }

    public static Object[] wrap(Object[] args, Class<?>[] paramTypes) {
        if (args == null) {
            return null;
        }
        Object[] oa = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            oa[i] = Primitive.wrap(args[i], paramTypes[i]);
        }
        return oa;
    }

    public static Object wrap(Object value, Class<?> type) {
        if (type == Void.TYPE) {
            return VOID;
        }
        if (value == null) {
            return NULL;
        }
        if (Types.isPrimitive(type)) {
            if (value instanceof Boolean) {
                return (Boolean)value != false ? TRUE : FALSE;
            }
            if (Primitive.isWrapperType(value.getClass())) {
                return new Primitive(value);
            }
        }
        return value;
    }

    public static Primitive getDefaultValue(Class<?> type) {
        if (type == null) {
            return NULL;
        }
        if (Boolean.TYPE == type || Boolean.class == type) {
            return FALSE;
        }
        if (Character.TYPE == type || Character.class == type) {
            return ZERO_CHAR;
        }
        if (Byte.TYPE == type || Byte.class == type) {
            return ZERO_BYTE;
        }
        if (Short.TYPE == type || Short.class == type) {
            return ZERO_SHORT;
        }
        if (Integer.TYPE == type || Integer.class == type) {
            return ZERO_INT;
        }
        if (Long.TYPE == type || Long.class == type) {
            return ZERO_LONG;
        }
        if (Float.TYPE == type || Float.class == type) {
            return ZERO_FLOAT;
        }
        if (Double.TYPE == type || Double.class == type) {
            return ZERO_DOUBLE;
        }
        if (BigInteger.class == type) {
            return ZERO_BIG_INTEGER;
        }
        if (BigDecimal.class == type) {
            return ZERO_BIG_DECIMAL;
        }
        return NULL;
    }

    public static Class<?> boxType(Class<?> primitiveType) {
        Class<?> c = wrapperMap.get(primitiveType);
        if (c != null && !c.isPrimitive()) {
            return c;
        }
        throw new InterpreterError("Not a primitive type: " + primitiveType);
    }

    public static Class<?> unboxType(Class<?> wrapperType) {
        Class<?> c = wrapperMap.get(wrapperType);
        if (c != null && (c.isPrimitive() || c == wrapperType)) {
            return c;
        }
        throw new InterpreterError("Not a primitive wrapper type: " + wrapperType);
    }

    public Primitive castToType(Class<?> toType, int operation) throws UtilEvalError {
        return Primitive.castPrimitive(toType, this.getType(), this, false, operation);
    }

    static Primitive castPrimitive(Class<?> toType, Class<?> fromType, Primitive fromValue, boolean checkOnly, int operation) throws UtilEvalError {
        if (fromType == Void.TYPE) {
            if (checkOnly) {
                return Types.INVALID_CAST;
            }
            throw Types.castError(StringUtil.typeString(toType), "void value", operation);
        }
        if (!checkOnly && fromValue.isNumber() && Types.isNumeric(toType)) {
            return new Primitive(Primitive.castNumber(toType, fromValue.numberValue()));
        }
        if (toType.isPrimitive()) {
            if (fromType == null && !VOID.equals(fromValue)) {
                return checkOnly ? Types.VALID_CAST : Primitive.getDefaultValue(toType);
            }
            if (toType == Boolean.TYPE) {
                return checkOnly ? Types.VALID_CAST : new Primitive(Primitive.castWrapper(toType, fromValue));
            }
        } else {
            if (fromType == null) {
                return checkOnly ? Types.VALID_CAST : NULL;
            }
            if (checkOnly) {
                return Types.INVALID_CAST;
            }
            throw Types.castError("object type " + toType.getName(), "primitive value", operation);
        }
        if (checkOnly && fromType == Boolean.TYPE) {
            if (toType != Boolean.TYPE) {
                return Types.INVALID_CAST;
            }
            return Types.VALID_CAST;
        }
        if (operation == 1 && !Types.isJavaAssignable(toType, fromType) && checkOnly) {
            return Types.INVALID_CAST;
        }
        return checkOnly ? Types.VALID_CAST : new Primitive(Primitive.castWrapper(toType, fromValue));
    }

    public static boolean isWrapperType(Class<?> type) {
        return null != type && wrapperMap.containsKey(type) && !type.isPrimitive();
    }

    static Object castWrapper(Class<?> toType, Object value) {
        if (VOID.equals(value)) {
            return value;
        }
        value = Primitive.unwrap(value);
        if (!Primitive.isWrapperType(toType) && !toType.isPrimitive()) {
            throw new InterpreterError("invalid type in castWrapper: " + toType);
        }
        if (value instanceof Character) {
            value = (int)((Character)value).charValue();
        }
        if (toType == Boolean.TYPE) {
            if (value instanceof Boolean) {
                return value;
            }
            if (value instanceof String) {
                return !"".equals(String.valueOf(value));
            }
            if (value instanceof Number) {
                return ((Number)value).intValue() != 0;
            }
            return value != null;
        }
        if (value == null && toType.isPrimitive()) {
            value = Primitive.unwrap(Primitive.getDefaultValue(toType));
        }
        if (value instanceof String) {
            try {
                value = Double.parseDouble(String.valueOf(value));
            }
            catch (NumberFormatException nfe) {
                throw new InterpreterError("cannot cast string \"" + value + "\" to number", nfe);
            }
        }
        if (value instanceof Boolean) {
            value = (Boolean)value != false ? 1 : 0;
        }
        if (!(value instanceof Number)) {
            throw new InterpreterError("bad type in cast " + StringUtil.typeValueString(value));
        }
        return Primitive.castNumber(toType, (Number)value);
    }

    static Object castNumber(Class<?> toType, Number number) {
        if (toType.isInstance(number) || toType == Primitive.unboxType(number.getClass())) {
            return number;
        }
        if ((toType == Byte.class || toType == Byte.TYPE) && number.shortValue() <= 255 && number.shortValue() >= -128) {
            return number.byteValue();
        }
        if ((toType == Short.class || toType == Short.TYPE) && number.intValue() <= Short.MAX_VALUE && number.intValue() >= Short.MIN_VALUE) {
            return number.shortValue();
        }
        if ((toType == Character.class || toType == Character.TYPE) && number.intValue() <= 65535 && number.intValue() >= 0) {
            return Character.valueOf((char)number.intValue());
        }
        if ((toType == Integer.class || toType == Integer.TYPE) && number.longValue() <= Integer.MAX_VALUE && number.longValue() >= Integer.MIN_VALUE) {
            if (number instanceof Byte) {
                return Byte.toUnsignedInt(number.byteValue());
            }
            return number.intValue();
        }
        if (!(toType != Float.class && toType != Float.TYPE || Float.isInfinite(number.floatValue()))) {
            return Float.valueOf(number.floatValue());
        }
        if (!(toType != Double.class && toType != Double.TYPE || Double.isInfinite(number.doubleValue()))) {
            return number.doubleValue();
        }
        if (number.doubleValue() == 0.0) {
            if (toType == Long.class || toType == Long.TYPE) {
                return 0L;
            }
            if (toType == BigInteger.class) {
                return BigInteger.ZERO;
            }
            if (toType == BigDecimal.class) {
                return BigDecimal.ZERO.setScale(1);
            }
        } else if (number.doubleValue() == 1.0) {
            if (toType == Long.class || toType == Long.TYPE) {
                return 1L;
            }
            if (toType == BigInteger.class) {
                return BigInteger.ONE;
            }
            if (toType == BigDecimal.class) {
                return BigDecimal.ONE.setScale(1);
            }
        } else {
            if (toType == BigDecimal.class) {
                if (number instanceof BigInteger) {
                    return new BigDecimal((BigInteger)number).setScale(1);
                }
                if (Types.isFloatingpoint(number)) {
                    return BigDecimal.valueOf(number.doubleValue());
                }
                return new BigDecimal(number.longValue()).setScale(1);
            }
            BigInteger bi = null;
            bi = number instanceof BigInteger ? (BigInteger)number : (number instanceof BigDecimal ? ((BigDecimal)number).toBigInteger() : (Types.isFloatingpoint(number) ? BigDecimal.valueOf(number.doubleValue()).toBigInteger() : BigInteger.valueOf(number.longValue())));
            if ((toType == Long.class || toType == Long.TYPE) && bi.compareTo(LONG_MIN) >= 0 && bi.compareTo(LONG_MAX) <= 0) {
                return number.longValue();
            }
            if (toType == BigInteger.class) {
                return bi;
            }
        }
        throw new InterpreterError("cannot assign number " + number + " to type " + toType.getSimpleName());
    }

    static Object castNumberStrictJava(Class<?> toType, Number number) {
        if (toType == Byte.class || toType == Byte.TYPE) {
            return number.byteValue();
        }
        if (toType == Short.class || toType == Short.TYPE) {
            return number.shortValue();
        }
        if (toType == Character.class || toType == Character.TYPE) {
            return Character.valueOf((char)number.intValue());
        }
        if (toType == Integer.class || toType == Integer.TYPE) {
            return number.intValue();
        }
        if (toType == Long.class || toType == Long.TYPE) {
            return number.longValue();
        }
        if (toType == Float.class || toType == Float.TYPE) {
            return Float.valueOf(number.floatValue());
        }
        if (toType == Double.class || toType == Double.TYPE) {
            return number.doubleValue();
        }
        return Primitive.castNumber(toType, number);
    }

    static {
        wrapperMap.put(Boolean.TYPE, Boolean.class);
        wrapperMap.put(Byte.TYPE, Byte.class);
        wrapperMap.put(Short.TYPE, Short.class);
        wrapperMap.put(Character.TYPE, Character.class);
        wrapperMap.put(Integer.TYPE, Integer.class);
        wrapperMap.put(Long.TYPE, Long.class);
        wrapperMap.put(Float.TYPE, Float.class);
        wrapperMap.put(Double.TYPE, Double.class);
        wrapperMap.put(Boolean.class, Boolean.TYPE);
        wrapperMap.put(Byte.class, Byte.TYPE);
        wrapperMap.put(Short.class, Short.TYPE);
        wrapperMap.put(Character.class, Character.TYPE);
        wrapperMap.put(Integer.class, Integer.TYPE);
        wrapperMap.put(Long.class, Long.TYPE);
        wrapperMap.put(Float.class, Float.TYPE);
        wrapperMap.put(Double.class, Double.TYPE);
        wrapperMap.put(BigInteger.class, BigInteger.class);
        wrapperMap.put(BigDecimal.class, BigDecimal.class);
        TRUE = new Primitive(true);
        FALSE = new Primitive(false);
        ZERO_CHAR = new Primitive('\u0000');
        ZERO_BYTE = new Primitive(0);
        ZERO_SHORT = new Primitive(0);
        ZERO_INT = new Primitive(0);
        ZERO_LONG = new Primitive(0L);
        ZERO_FLOAT = new Primitive(0.0f);
        ZERO_DOUBLE = new Primitive(0.0);
        ZERO_BIG_INTEGER = new Primitive(BigInteger.ZERO);
        ZERO_BIG_DECIMAL = new Primitive(BigDecimal.ZERO);
        NULL = new Primitive((Object)Special.NULL_VALUE);
        VOID = new Primitive((Object)Special.VOID_TYPE);
        INTEGER_MAX = BigInteger.valueOf(Integer.MAX_VALUE);
        INTEGER_MIN = BigInteger.valueOf(Integer.MIN_VALUE);
        LONG_MAX = BigInteger.valueOf(Long.MAX_VALUE);
        LONG_MIN = BigInteger.valueOf(Long.MIN_VALUE);
    }

    private static enum Special {
        NULL_VALUE,
        VOID_TYPE;

    }
}

