/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.EvalError;
import bsh.Interpreter;
import bsh.Token;

public class ParseException
extends EvalError {
    private static final long serialVersionUID = 1L;
    private static String sourceFile = null;
    public Token currentToken;
    public int[][] expectedTokenSequences;
    public String[] tokenImage;

    public void setErrorSourceFile(String file) {
        sourceFile = file;
    }

    @Override
    public String getErrorSourceFile() {
        return sourceFile;
    }

    public ParseException(Token currentTokenVal, int[][] expectedTokenSequencesVal, String[] tokenImageVal) {
        super(ParseException.initialise(currentTokenVal, expectedTokenSequencesVal, tokenImageVal), null, null);
        this.currentToken = currentTokenVal;
        this.expectedTokenSequences = expectedTokenSequencesVal;
        this.tokenImage = tokenImageVal;
    }

    public ParseException() {
        this("");
    }

    public ParseException(String message) {
        super(message, null, null);
    }

    public ParseException(String message, Throwable cause) {
        super(message, null, null, cause);
    }

    private static String initialise(Token currentToken, int[][] expectedTokenSequences, String[] tokenImage) {
        StringBuilder retval = new StringBuilder("Unable to parse code syntax. Encountered:");
        if (null != currentToken) {
            Token tok = currentToken;
            while (null != (tok = tok.next)) {
                retval.append(" ").append(ParseException.add_escapes(tok.image));
            }
            retval.append(" at line ").append(currentToken.next.beginLine).append(", column ").append(currentToken.next.beginColumn);
            if (null != sourceFile) {
                retval.append(" in: ").append(sourceFile);
            }
        }
        if (Interpreter.DEBUG.get().booleanValue() && expectedTokenSequences.length != 0) {
            retval.append(System.getProperty("line.separator", "\n")).append("Exppected");
            if (expectedTokenSequences.length > 1) {
                retval.append(" one of");
            }
            retval.append(": ");
            for (int i = 0; i < expectedTokenSequences.length; ++i) {
                for (int j = 0; j < expectedTokenSequences[i].length; ++j) {
                    retval.append(tokenImage[expectedTokenSequences[i][j]].replace('\"', ' ').trim()).append(' ');
                }
            }
        }
        return retval.toString();
    }

    static String add_escapes(String str) {
        StringBuilder retval = new StringBuilder();
        block10: for (int i = 0; i < str.length(); ++i) {
            switch (str.charAt(i)) {
                case '\b': {
                    retval.append("\\b");
                    continue block10;
                }
                case '\t': {
                    retval.append("\\t");
                    continue block10;
                }
                case '\n': {
                    retval.append("\\n");
                    continue block10;
                }
                case '\f': {
                    retval.append("\\f");
                    continue block10;
                }
                case '\r': {
                    retval.append("\\r");
                    continue block10;
                }
                case '\"': {
                    retval.append("\\\"");
                    continue block10;
                }
                case '\'': {
                    retval.append("\\'");
                    continue block10;
                }
                case '\\': {
                    retval.append("\\\\");
                    continue block10;
                }
                default: {
                    char ch = str.charAt(i);
                    if (ch < ' ' || ch > '~') {
                        String s = "0000" + Integer.toString(ch, 16);
                        retval.append("\\u" + s.substring(s.length() - 4, s.length()));
                        continue block10;
                    }
                    retval.append(ch);
                }
            }
        }
        return retval.toString();
    }

    @Override
    public int getErrorLineNumber() {
        return this.currentToken.next.beginLine;
    }

    @Override
    public String getErrorText() {
        return this.getMessage();
    }

    @Override
    public String getMessage() {
        return ParseException.initialise(this.currentToken, this.expectedTokenSequences, this.tokenImage);
    }

    public String getMessage(boolean debug) {
        return this.getMessage();
    }

    @Override
    public String toString() {
        return this.getMessage();
    }
}

