/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;

public class Modifiers
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int CLASS = 0;
    public static final int INTERFACE = 1;
    public static final int METHOD = 2;
    public static final int FIELD = 3;
    public static final int PARAMETER = 4;
    public static final int CONSTRUCTOR = 5;
    public static final Map<String, Integer> CONST = new HashMap<String, Integer>(17);
    private static final int ACCESS_MODIFIERS = 7;
    private String type;
    private int valid;
    private int context;
    private int modifiers = 0;

    public Modifiers(int context) {
        this.appliedContext(context);
    }

    public void addModifier(String name) {
        this.addModifier(this.toModifier(name));
    }

    public void addModifier(int mod) {
        if ((this.valid & mod) == 0) {
            throw new IllegalStateException(this.type + " cannot be declared '" + this.toModifier(mod) + "'");
        }
        if (mod < 7 && (this.modifiers & 7) > 0 && (this.modifiers | mod) != this.modifiers) {
            throw new IllegalStateException("public/private/protected cannot be used in combination.");
        }
        this.modifiers |= mod;
    }

    public void addModifiers(int mods) {
        for (int mod = 1; mod <= mods; mod *= 2) {
            if ((mods & mod) == 0) continue;
            this.addModifier(mod);
        }
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public void changeContext(int context) {
        int mods = this.modifiers;
        this.modifiers = 0;
        this.appliedContext(context);
        this.addModifiers(mods);
    }

    public boolean isAppliedContext(int context) {
        return this.context == context;
    }

    public boolean hasModifier(String name) {
        return this.hasModifier(this.toModifier(name));
    }

    public boolean hasModifier(int mod) {
        return (this.modifiers & mod) != 0;
    }

    public void setConstant() {
        this.modifiers = 25;
    }

    private void appliedContext(int context) {
        this.context = context;
        switch (context) {
            case 0: {
                this.valid = Modifier.classModifiers();
                this.type = "Class";
                break;
            }
            case 1: {
                this.valid = Modifier.interfaceModifiers();
                this.type = "Interface";
                break;
            }
            case 2: {
                this.valid = Modifier.methodModifiers() | CONST.get("default");
                this.type = "Method";
                break;
            }
            case 3: {
                this.valid = Modifier.fieldModifiers() | CONST.get("enum");
                this.type = "Field";
                break;
            }
            case 4: {
                this.valid = Modifier.parameterModifiers();
                this.type = "Parameter";
                break;
            }
            case 5: {
                this.valid = Modifier.constructorModifiers();
                this.type = "Constructor";
                break;
            }
            default: {
                this.valid = 0;
                this.type = "Unknown";
            }
        }
    }

    private int toModifier(String name) {
        Integer mod = CONST.get(name);
        if (null == mod) {
            throw new IllegalStateException("Unknown modifier: '" + name + "'");
        }
        return mod;
    }

    private String toModifier(int mod) {
        for (String name : CONST.keySet()) {
            if (mod != CONST.get(name)) continue;
            return name;
        }
        return String.valueOf(mod);
    }

    public String toString() {
        return "Modifiers: " + Modifier.toString(this.modifiers) + ((this.modifiers & CONST.get("enum")) != 0 ? " enum" : ((this.modifiers & CONST.get("default")) != 0 ? " default" : ""));
    }

    static {
        CONST.put("public", 1);
        CONST.put("private", 2);
        CONST.put("protected", 4);
        CONST.put("static", 8);
        CONST.put("final", 16);
        CONST.put("synchronized", 32);
        CONST.put("volatile", 64);
        CONST.put("transient", 128);
        CONST.put("native", 256);
        CONST.put("interface", 512);
        CONST.put("abstract", 1024);
        CONST.put("strict", 2048);
        CONST.put("synthetic", 4096);
        CONST.put("annotation", 8192);
        CONST.put("enum", 16384);
        CONST.put("mandated", 32768);
        CONST.put("default", 65536);
    }
}

