/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.ExecutingInvocable;
import bsh.Invocable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.regex.Pattern;

class MethodInvocable
extends ExecutingInvocable {
    private static final Pattern PROPERTY_PATTERN = Pattern.compile("(?:[gs]et|is)\\p{javaUpperCase}.*");
    private final Class<?> type;
    private Method method;
    private boolean getter = false;
    private boolean setter = false;

    MethodInvocable(Method method) {
        super(method);
        this.method = method;
        this.type = method.getReturnType();
        this.lastParameterIndex = this.getParameterCount() - (this.isVarArgs() ? 1 : 0);
        if (PROPERTY_PATTERN.matcher(this.getName()).matches()) {
            this.setter = this.getName().startsWith("set");
            this.getter = !this.setter && this.getParameterCount() == 0 && this.type != Void.TYPE;
            this.setter &= this.getParameterCount() == 1 && this.type == Void.TYPE;
            if (this.getter && this.getName().startsWith("is")) {
                this.getter = this.type == Boolean.class || this.type == Boolean.TYPE;
            }
        }
    }

    @Override
    public boolean isGetter() {
        return this.getter;
    }

    @Override
    public boolean isSetter() {
        return this.setter;
    }

    @Override
    public Class<?> getReturnType() {
        return this.type;
    }

    @Override
    protected MethodHandle lookup(MethodHandle m) {
        assert (m == null);
        assert (this.method != null);
        try {
            MethodHandle methodHandle = super.lookup(MethodInvocable.getHandle(this.method));
            return methodHandle;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.method = null;
        }
    }

    private static MethodHandle getHandle(Method method) {
        String methodName = method.getName();
        Class<?>[] types = method.getParameterTypes();
        Class<?> origClz = method.getDeclaringClass();
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        Object handle = null;
        Class<?> clz = origClz;
        while (clz != null && handle == null) {
            try {
                if (method != null) {
                    return lookup.unreflect(method);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            for (Class<?> intf : clz.getInterfaces()) {
                try {
                    method = intf.getDeclaredMethod(methodName, types);
                    return lookup.unreflect(method);
                }
                catch (IllegalAccessException | NoSuchMethodException | SecurityException exception) {
                }
            }
            if ((clz = clz.getSuperclass()) == null) continue;
            try {
                method = clz.getDeclaredMethod(methodName, types);
            }
            catch (NoSuchMethodException | SecurityException e) {
                method = null;
            }
        }
        throw new RuntimeException("MethodHandle lookup failed to find a " + methodName + " in " + origClz.getName());
    }

    @Override
    public Invocable.ParameterType collectParamaters(Object base, Object[] params) throws Throwable {
        Invocable.ParameterType pt = super.collectParamaters(base, params);
        if (!this.isStatic()) {
            this.parameters.add(0, base);
        }
        return new Invocable.ParameterType(this.parameters, pt.isFixedArity);
    }
}

