/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BSHType;
import bsh.Capabilities;
import bsh.ConstructorInvocable;
import bsh.FieldAccess;
import bsh.MethodInvocable;
import bsh.Primitive;
import bsh.Reflect;
import bsh.Types;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;

public abstract class Invocable
implements Member {
    private MethodHandle handle = null;
    private final boolean isStatic;
    private final boolean isSynthetic;
    private final String toString;
    private final String name;
    private final int flags;
    private final Class<?> declaringClass;
    protected final List<Object> parameters = new ArrayList<Object>();
    protected int lastParameterIndex;

    public static Invocable get(Method m) {
        return new MethodInvocable(m);
    }

    public static Invocable get(Constructor<?> c) {
        return new ConstructorInvocable(c);
    }

    public static FieldAccess get(Field f) {
        return new FieldAccess(f);
    }

    <M extends AccessibleObject> Invocable(M member) {
        this.flags = ((Member)((Object)member)).getModifiers();
        this.declaringClass = ((Member)((Object)member)).getDeclaringClass();
        this.name = ((Member)((Object)member)).getName();
        this.toString = member.toString();
        this.lastParameterIndex = 0;
        this.isStatic = Reflect.isStatic((Member)((Object)member));
        this.isSynthetic = ((Member)((Object)member)).isSynthetic();
        if (Capabilities.haveAccessibility() && ((Member)((Object)member)).getDeclaringClass() != Class.class) {
            member.setAccessible(true);
        }
    }

    abstract Class<?>[] getParameterTypes();

    abstract Class<?> getReturnType();

    abstract int getParameterCount();

    abstract MethodHandle lookup(MethodHandle var1);

    public boolean isInnerClass() {
        return false;
    }

    public boolean isVarArgs() {
        return false;
    }

    public Class<?> getVarArgsType() {
        return Void.TYPE;
    }

    public Class<?> getVarArgsComponentType() {
        return Void.TYPE;
    }

    public boolean isGetter() {
        return false;
    }

    public boolean isSetter() {
        return false;
    }

    @Override
    public int getModifiers() {
        return this.flags;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    @Override
    public boolean isSynthetic() {
        return this.isSynthetic;
    }

    protected int getLastParameterIndex() {
        return this.lastParameterIndex;
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this.declaringClass;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public MethodHandle getMethodHandle() {
        if (null == this.handle) {
            this.handle = this.lookup(null);
        }
        return this.handle;
    }

    public MethodType methodType() {
        return MethodType.methodType(this.getReturnType(), this.getParameterTypes());
    }

    public String getMethodDescriptor() {
        return this.methodType().toMethodDescriptorString();
    }

    public String[] getParamTypeDescriptors() {
        return (String[])this.methodType().parameterList().stream().map(BSHType::getTypeDescriptor).toArray(String[]::new);
    }

    public String getReturnTypeDescriptor() {
        return BSHType.getTypeDescriptor(this.getReturnType());
    }

    public ParameterType collectParamaters(Object base, Object[] params) throws Throwable {
        if (this.getLastParameterIndex() > params.length) {
            throw new InvocationTargetException(null, "Insufficient parameters passed for method: " + this.getName() + Arrays.asList(this.getParameterTypes()));
        }
        this.parameters.clear();
        for (int i = 0; i < this.getLastParameterIndex(); ++i) {
            this.parameters.add(this.coerceToType(params[i], this.getParameterTypes()[i]));
        }
        return new ParameterType(this.parameters, false);
    }

    protected Object coerceToType(Object param, Class<?> type) throws Throwable {
        Class<?> pClass = Types.getType(param);
        if (null == pClass || !type.isAssignableFrom(pClass)) {
            param = Types.castObject(param, type, 0);
        }
        return Primitive.unwrap(param);
    }

    private synchronized Object invokeTarget(Object base, Object[] pars) throws Throwable {
        Reflect.logInvokeMethod("Invoking method (entry): ", this, pars);
        ParameterType pt = this.collectParamaters(base, pars);
        List<Object> params = pt.params;
        Reflect.logInvokeMethod("Invoking method (after): ", this, params);
        if (this.getParameterCount() > 0) {
            MethodHandle mh = this.getMethodHandle();
            if (pt.isFixedArity) {
                mh = mh.asFixedArity();
            }
            return mh.invokeWithArguments(params);
        }
        if (this.isStatic() || this instanceof ConstructorInvocable) {
            return this.getMethodHandle().invoke();
        }
        return this.getMethodHandle().invoke(params.get(0));
    }

    public synchronized Object invoke(Object base, Object ... pars) throws InvocationTargetException {
        if (null == pars) {
            pars = Reflect.ZERO_ARGS;
        }
        try {
            return Primitive.wrap(this.invokeTarget(base, pars), this.getReturnType());
        }
        catch (Throwable ite) {
            throw new InvocationTargetException(ite);
        }
    }

    public String toString() {
        return this.toString;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        Invocable member = (Invocable)o;
        if (!this.getName().equals(member.getName()) || this.getDeclaringClass() != member.getDeclaringClass() || this.getParameterCount() != member.getParameterCount() || this.getReturnType() != member.getReturnType() || this.getModifiers() != member.getModifiers()) {
            return false;
        }
        for (int i = 0; i < this.getParameterCount(); ++i) {
            if (this.getParameterTypes()[i] == member.getParameterTypes()[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ this.getName().hashCode() ^ this.getDeclaringClass().hashCode() ^ this.getParameterCount() ^ this.getReturnType().hashCode() ^ this.getModifiers() ^ Stream.of(this.getParameterTypes()).map(t -> null == t ? 39 : t.hashCode()).reduce(75, (a, b) -> a ^ b);
    }

    static class ParameterType {
        List<Object> params;
        boolean isFixedArity;

        ParameterType(List<Object> params, boolean isFixedArity) {
            this.params = params;
            this.isFixedArity = isFixedArity;
        }
    }
}

