/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.Invocable;
import bsh.Types;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Executable;
import java.util.Arrays;

abstract class ExecutingInvocable
extends Invocable {
    private final Class<?> varArgsType;
    private final Class<?>[] parameterTypes;
    private final int parameterCount;
    private final boolean isVarargs;

    <M extends Executable> ExecutingInvocable(M member) {
        super(member);
        this.parameterTypes = member.getParameterTypes();
        this.parameterCount = member.getParameterCount();
        this.isVarargs = member.isVarArgs();
        this.lastParameterIndex = this.parameterCount > 1 ? this.parameterCount - 1 : 0;
        this.varArgsType = this.isVarArgs() ? this.getParameterTypes()[this.lastParameterIndex] : Void.TYPE;
    }

    @Override
    public boolean isVarArgs() {
        return this.isVarargs;
    }

    @Override
    public int getParameterCount() {
        return this.parameterCount;
    }

    @Override
    public Class<?>[] getParameterTypes() {
        return this.parameterTypes;
    }

    @Override
    public Class<?> getVarArgsType() {
        return this.varArgsType;
    }

    @Override
    public Class<?> getVarArgsComponentType() {
        return Types.arrayElementType(this.getVarArgsType());
    }

    @Override
    protected MethodHandle lookup(MethodHandle m) {
        if (this.isVarArgs() && null != m) {
            return m.asVarargsCollector(this.getVarArgsType());
        }
        return m;
    }

    @Override
    public Invocable.ParameterType collectParamaters(Object base, Object[] params) throws Throwable {
        super.collectParamaters(base, params);
        boolean isFixedArity = false;
        if (this.isVarArgs()) {
            if (this.getLastParameterIndex() < params.length) {
                if (this.getParameterCount() == params.length && params[this.getLastParameterIndex()].getClass().isArray() && this.getVarArgsComponentType().isAssignableFrom(params[this.getLastParameterIndex()].getClass().getComponentType())) {
                    isFixedArity = true;
                    this.parameters.add(params[this.getLastParameterIndex()]);
                } else {
                    Object[] varargs = Arrays.copyOfRange(params, this.getLastParameterIndex(), params.length);
                    for (int i = 0; i < varargs.length; ++i) {
                        this.parameters.add(super.coerceToType(varargs[i], this.getVarArgsComponentType()));
                    }
                }
            }
        } else if (null != params && this.getLastParameterIndex() < params.length) {
            this.parameters.add(super.coerceToType(params[this.getLastParameterIndex()], this.getParameterTypes()[this.getLastParameterIndex()]));
        }
        return new Invocable.ParameterType(this.parameters, isFixedArity);
    }
}

