/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BSHBlock;
import bsh.BSHClassDeclaration;
import bsh.BSHEnumConstant;
import bsh.BSHFormalParameters;
import bsh.BSHMethodDeclaration;
import bsh.BSHReturnType;
import bsh.BSHTypedVariableDeclaration;
import bsh.BSHVariableDeclarator;
import bsh.BshClassManager;
import bsh.CallStack;
import bsh.ClassGeneratorUtil;
import bsh.DelayedEvalBshMethod;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.Invocable;
import bsh.Modifiers;
import bsh.NameSpace;
import bsh.Node;
import bsh.Reflect;
import bsh.ReflectError;
import bsh.This;
import bsh.Types;
import bsh.UtilEvalError;
import bsh.Variable;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;

public final class ClassGenerator {
    private static ClassGenerator cg;

    public static ClassGenerator getClassGenerator() {
        if (cg == null) {
            cg = new ClassGenerator();
        }
        return cg;
    }

    public Class<?> generateClass(String name, Modifiers modifiers, Class<?>[] interfaces, Class<?> superClass, BSHBlock block, Type type, CallStack callstack, Interpreter interpreter) throws EvalError {
        return ClassGenerator.generateClassImpl(name, modifiers, interfaces, superClass, block, type, callstack, interpreter);
    }

    public Object invokeSuperclassMethod(BshClassManager bcm, Object instance, Class<?> classStatic, String methodName, Object[] args) throws UtilEvalError, ReflectError, InvocationTargetException {
        return ClassGenerator.invokeSuperclassMethodImpl(bcm, instance, classStatic, methodName, args);
    }

    public static Class<?> generateClassImpl(String name, Modifiers modifiers, Class<?>[] interfaces, Class<?> superClass, BSHBlock block, Type type, CallStack callstack, Interpreter interpreter) throws EvalError {
        NameSpace enclosingNameSpace = callstack.top();
        String packageName = enclosingNameSpace.getPackage();
        String className = enclosingNameSpace.isClass ? enclosingNameSpace.getName() + "$" + name : name;
        String fqClassName = packageName == null ? className : packageName + "." + className;
        BshClassManager bcm = interpreter.getClassManager();
        NameSpace classStaticNameSpace = new NameSpace(enclosingNameSpace, className);
        classStaticNameSpace.isClass = true;
        callstack.push(classStaticNameSpace);
        block.evalBlock(callstack, interpreter, true, ClassNodeFilter.CLASSCLASSES);
        Variable[] variables = ClassGenerator.getDeclaredVariables(block, callstack, interpreter, packageName);
        DelayedEvalBshMethod[] methods = ClassGenerator.getDeclaredMethods(block, callstack, interpreter, packageName, superClass);
        callstack.pop();
        classStaticNameSpace.getThis(interpreter);
        ClassGeneratorUtil classGenerator = new ClassGeneratorUtil(modifiers, className, packageName, superClass, interfaces, variables, methods, classStaticNameSpace, type);
        classGenerator.initStaticNameSpace(classStaticNameSpace, block);
        Class<?> genClass = bcm.getAssociatedClass(fqClassName);
        if (genClass == null) {
            byte[] code = classGenerator.generateClass();
            if (Interpreter.getSaveClasses()) {
                ClassGenerator.saveClasses(className, code);
            }
            genClass = bcm.defineClass(fqClassName, code);
            Interpreter.debug("Define ", fqClassName, " as ", genClass);
        }
        enclosingNameSpace.importClass(fqClassName.replace('$', '.'));
        classStaticNameSpace.setClassStatic(genClass);
        Interpreter.debug(classStaticNameSpace);
        if (interpreter.getStrictJava()) {
            ClassGeneratorUtil.checkAbstractMethodImplementation(genClass);
        }
        return genClass;
    }

    private static void saveClasses(String className, byte[] code) {
        String dir2 = Interpreter.getSaveClassesDir();
        if (dir2 != null) {
            try (FileOutputStream out = new FileOutputStream(dir2 + "/" + className + ".class");){
                out.write(code);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    static Variable[] getDeclaredVariables(BSHBlock body, CallStack callstack, Interpreter interpreter, String defaultPackage) {
        ArrayList<Variable> vars = new ArrayList<Variable>();
        for (int child = 0; child < body.jjtGetNumChildren(); ++child) {
            BSHVariableDeclarator[] vardec;
            Node node = body.jjtGetChild(child);
            if (node instanceof BSHEnumConstant) {
                BSHEnumConstant enm = (BSHEnumConstant)node;
                try {
                    Variable var = new Variable(enm.getName(), enm.getType(), null, enm.mods);
                    vars.add(var);
                }
                catch (UtilEvalError var) {}
                continue;
            }
            if (!(node instanceof BSHTypedVariableDeclaration)) continue;
            BSHTypedVariableDeclaration tvd = (BSHTypedVariableDeclaration)node;
            Modifiers modifiers = tvd.modifiers;
            for (BSHVariableDeclarator aVardec : vardec = tvd.getDeclarators()) {
                String name = aVardec.name;
                try {
                    Class<?> type = tvd.evalType(callstack, interpreter);
                    Variable var = new Variable(name, type, null, modifiers);
                    vars.add(var);
                }
                catch (EvalError | UtilEvalError exception) {
                    // empty catch block
                }
            }
        }
        return vars.toArray(new Variable[vars.size()]);
    }

    static DelayedEvalBshMethod[] getDeclaredMethods(BSHBlock body, CallStack callstack, Interpreter interpreter, String defaultPackage, Class<?> superClass) throws EvalError {
        ArrayList<DelayedEvalBshMethod> methods = new ArrayList<DelayedEvalBshMethod>();
        if (callstack.top().getName().indexOf("$anon") > -1) {
            String classBaseName = Types.getBaseName(callstack.top().getName());
            Invocable con = BshClassManager.memberCache.get(superClass).findMethod(superClass.getName(), This.CONTEXT_ARGS.get().get(classBaseName));
            DelayedEvalBshMethod bm = new DelayedEvalBshMethod(classBaseName, con, callstack.top());
            methods.add(bm);
        }
        for (int child = 0; child < body.jjtGetNumChildren(); ++child) {
            Node node = body.jjtGetChild(child);
            if (!(node instanceof BSHMethodDeclaration)) continue;
            BSHMethodDeclaration md = (BSHMethodDeclaration)node;
            md.insureNodesParsed();
            Modifiers modifiers = md.modifiers;
            String name = md.name;
            String returnType = md.getReturnTypeDescriptor(callstack, interpreter, defaultPackage);
            BSHReturnType returnTypeNode = md.getReturnTypeNode();
            BSHFormalParameters paramTypesNode = md.paramsNode;
            String[] paramTypes = paramTypesNode.getTypeDescriptors(callstack, interpreter, defaultPackage);
            DelayedEvalBshMethod bm = new DelayedEvalBshMethod(name, returnType, returnTypeNode, md.paramsNode.getParamNames(), paramTypes, paramTypesNode, md.blockNode, null, modifiers, md.isVarArgs, callstack, interpreter);
            methods.add(bm);
        }
        return methods.toArray(new DelayedEvalBshMethod[methods.size()]);
    }

    public static Object invokeSuperclassMethodImpl(BshClassManager bcm, Object instance, Class<?> classStatic, String methodName, Object[] args) throws UtilEvalError, ReflectError, InvocationTargetException {
        String superName;
        Class<?> superClass = classStatic.getSuperclass();
        Class<?> clas = instance.getClass();
        Invocable superMethod = Reflect.resolveJavaMethod(clas, superName = (Object)((Object)This.Keys.BSHSUPER) + superClass.getSimpleName() + methodName, Types.getTypes(args), false);
        if (superMethod != null) {
            return superMethod.invoke(instance, args);
        }
        superMethod = Reflect.resolveExpectedJavaMethod(bcm, superClass, instance, methodName, args, false);
        return superMethod.invoke(instance, args);
    }

    static enum Type {
        CLASS,
        INTERFACE,
        ENUM;

    }

    static class ClassNodeFilter
    implements BSHBlock.NodeFilter {
        public static ClassNodeFilter CLASSSTATICFIELDS = new ClassNodeFilter(Context.STATIC, Types.FIELDS);
        public static ClassNodeFilter CLASSSTATICMETHODS = new ClassNodeFilter(Context.STATIC, Types.METHODS);
        public static ClassNodeFilter CLASSINSTANCEFIELDS = new ClassNodeFilter(Context.INSTANCE, Types.FIELDS);
        public static ClassNodeFilter CLASSINSTANCEMETHODS = new ClassNodeFilter(Context.INSTANCE, Types.METHODS);
        public static ClassNodeFilter CLASSCLASSES = new ClassNodeFilter(Context.CLASSES);
        Context context;
        Types types = Types.ALL;

        private ClassNodeFilter(Context context) {
            this.context = context;
        }

        private ClassNodeFilter(Context context, Types types) {
            this.context = context;
            this.types = types;
        }

        @Override
        public boolean isVisible(Node node) {
            if (this.context == Context.CLASSES) {
                return node instanceof BSHClassDeclaration;
            }
            if (node instanceof BSHClassDeclaration) {
                return false;
            }
            if (this.context == Context.STATIC) {
                return this.types == Types.METHODS ? this.isStaticMethod(node) : this.isStatic(node);
            }
            return this.types == Types.METHODS ? this.isInstanceMethod(node) : this.isNonStatic(node);
        }

        private boolean isStatic(Node node) {
            if (node.jjtGetParent().jjtGetParent() instanceof BSHClassDeclaration && ((BSHClassDeclaration)node.jjtGetParent().jjtGetParent()).type == Type.INTERFACE) {
                return true;
            }
            if (node instanceof BSHTypedVariableDeclaration) {
                return ((BSHTypedVariableDeclaration)node).modifiers.hasModifier("static");
            }
            if (node instanceof BSHBlock) {
                return ((BSHBlock)node).isStatic;
            }
            return false;
        }

        private boolean isNonStatic(Node node) {
            if (node instanceof BSHMethodDeclaration) {
                return false;
            }
            return !this.isStatic(node);
        }

        private boolean isStaticMethod(Node node) {
            if (node instanceof BSHMethodDeclaration) {
                return ((BSHMethodDeclaration)node).modifiers.hasModifier("static");
            }
            return false;
        }

        private boolean isInstanceMethod(Node node) {
            if (node instanceof BSHMethodDeclaration) {
                return !((BSHMethodDeclaration)node).modifiers.hasModifier("static");
            }
            return false;
        }

        private static enum Types {
            ALL,
            METHODS,
            FIELDS;

        }

        private static enum Context {
            STATIC,
            INSTANCE,
            CLASSES;

        }
    }
}

