/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BshClassManager;
import bsh.UtilEvalError;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class Capabilities
implements Supplier<Boolean>,
Consumer<Boolean> {
    static final Capabilities instance = new Capabilities();
    private volatile boolean accessibility = false;
    private static final ThreadLocal<Boolean> ACCESSIBILITY = ThreadLocal.withInitial(instance);
    private static final Map<String, Class<?>> classes = new WeakHashMap();

    private Capabilities() {
    }

    public static boolean haveSwing() {
        return Capabilities.classExists("javax.swing.JButton");
    }

    public static boolean haveAccessibility() {
        return ACCESSIBILITY.get();
    }

    public static void setAccessibility(boolean b) {
        if (!b) {
            ACCESSIBILITY.set(Boolean.FALSE);
        } else {
            String.class.getDeclaredMethods();
            try {
                Field member = String.class.getDeclaredField("value");
                ((AccessibleObject)member).setAccessible(true);
                ((AccessibleObject)member).setAccessible(false);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
            ACCESSIBILITY.set(Boolean.TRUE);
        }
        BshClassManager.memberCache.clear();
    }

    public static boolean classExists(String name) {
        if (!classes.containsKey(name)) {
            try {
                classes.put(name, Class.forName(name));
            }
            catch (ClassNotFoundException e) {
                classes.put(name, null);
            }
        }
        return Capabilities.getExisting(name) != null;
    }

    public static Class<?> getExisting(String name) {
        return classes.get(name);
    }

    @Override
    public Boolean get() {
        return this.accessibility;
    }

    @Override
    public void accept(Boolean t) {
        this.accessibility = t;
    }

    public static class Unavailable
    extends UtilEvalError {
        public Unavailable(String s) {
            super(s);
        }

        public Unavailable(String s, Throwable cause) {
            super(s, cause);
        }
    }
}

