/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BSHBlock;
import bsh.BSHMethodDeclaration;
import bsh.BshClassManager;
import bsh.CallStack;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.InterpreterError;
import bsh.Invocable;
import bsh.Modifiers;
import bsh.NameSpace;
import bsh.Node;
import bsh.Primitive;
import bsh.Reflect;
import bsh.ReflectError;
import bsh.ReturnControl;
import bsh.StringUtil;
import bsh.TargetError;
import bsh.This;
import bsh.Types;
import bsh.UtilEvalError;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.stream.IntStream;

public class BshMethod
implements Serializable,
Cloneable,
BshClassManager.Listener {
    private static final long serialVersionUID = 1L;
    NameSpace declaringNameSpace;
    Modifiers modifiers;
    private String name;
    private Class<?> creturnType;
    private String[] paramNames;
    private int paramCount;
    private Class<?>[] cparamTypes;
    private Modifiers[] paramModifiers;
    protected BSHBlock methodBody;
    private Invocable javaMethod;
    private Object javaObject;
    protected boolean isVarArgs;
    boolean isScriptedObject = false;
    private boolean reload = false;

    BshMethod(BSHMethodDeclaration method, NameSpace declaringNameSpace, Modifiers modifiers, boolean isScriptedObject) {
        this(method.name, method.returnType, method.paramsNode.getParamNames(), method.paramsNode.paramTypes, method.paramsNode.getParamModifiers(), method.blockNode, declaringNameSpace, modifiers, method.isVarArgs);
        this.isScriptedObject = isScriptedObject;
    }

    BshMethod(String name, Class<?> returnType, String[] paramNames, Class<?>[] paramTypes, Modifiers[] paramModifiers, BSHBlock methodBody, NameSpace declaringNameSpace, Modifiers modifiers, boolean isVarArgs) {
        this.name = name;
        this.creturnType = returnType;
        this.paramNames = paramNames;
        this.paramModifiers = paramModifiers;
        if (paramNames != null) {
            this.paramCount = paramNames.length;
        }
        this.cparamTypes = paramTypes;
        this.methodBody = methodBody;
        this.declaringNameSpace = declaringNameSpace;
        this.modifiers = modifiers;
        this.isVarArgs = isVarArgs;
    }

    BshMethod(Invocable method, Object object) {
        this(method.getName(), method.getReturnType(), null, method.getParameterTypes(), null, null, null, null, method.isVarArgs());
        this.javaMethod = method;
        this.javaObject = object;
    }

    public BshMethod clone() {
        BshMethod returnClone = null;
        try {
            returnClone = (BshMethod)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return returnClone;
    }

    public Class<?>[] getParameterTypes() {
        if (null == this.javaMethod) {
            this.reloadTypes();
            return this.cparamTypes;
        }
        return this.javaMethod.getParameterTypes();
    }

    public String[] getParameterNames() {
        if (null == this.paramNames) {
            this.paramNames = (String[])IntStream.range(97, 97 + this.getParameterCount()).boxed().map(n -> String.valueOf((char)n.intValue())).toArray(String[]::new);
        }
        return this.paramNames;
    }

    public Modifiers[] getParameterModifiers() {
        if (null == this.paramModifiers) {
            this.paramModifiers = new Modifiers[this.getParameterCount()];
        }
        return this.paramModifiers;
    }

    public int getParameterCount() {
        if (null == this.javaMethod) {
            return this.paramCount;
        }
        return this.javaMethod.getParameterCount();
    }

    public Class<?> getReturnType() {
        if (null == this.javaMethod) {
            this.reloadTypes();
            return this.creturnType;
        }
        return this.javaMethod.getReturnType();
    }

    public Modifiers getModifiers() {
        if (this.modifiers == null) {
            this.modifiers = new Modifiers(2);
        }
        return this.modifiers;
    }

    public String getName() {
        if (null == this.javaMethod) {
            return this.name;
        }
        return this.javaMethod.getName();
    }

    public boolean isVarArgs() {
        if (null == this.javaMethod) {
            return this.isVarArgs;
        }
        return this.javaMethod.isVarArgs();
    }

    public Object invoke(Object[] argValues, Interpreter interpreter) throws EvalError {
        return this.invoke(argValues, interpreter, null, null, false);
    }

    public Object invoke(Object[] argValues, Interpreter interpreter, CallStack callstack, Node callerInfo) throws EvalError {
        return this.invoke(argValues, interpreter, callstack, callerInfo, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object invoke(Object[] argValues, Interpreter interpreter, CallStack callstack, Node callerInfo, boolean overrideNameSpace) throws EvalError {
        Interpreter.debug("Bsh method invoke: ", this.name, " overrideNameSpace: ", overrideNameSpace);
        if (argValues != null) {
            for (int i = 0; i < argValues.length; ++i) {
                if (argValues[i] != null) continue;
                throw new Error("HERE!");
            }
        }
        if (this.javaMethod != null) {
            try {
                return this.javaMethod.invoke(this.javaObject, argValues);
            }
            catch (ReflectError e) {
                throw new EvalError("Error invoking Java method: " + e, callerInfo, callstack);
            }
            catch (InvocationTargetException e2) {
                throw new TargetError("Exception invoking imported object method.", e2, callerInfo, callstack, true);
            }
        }
        if (this.modifiers != null && this.modifiers.hasModifier("synchronized")) {
            Object lock;
            if (this.declaringNameSpace.isClass) {
                try {
                    lock = this.declaringNameSpace.getClassInstance();
                }
                catch (UtilEvalError e) {
                    throw new InterpreterError("Can't get class instance for synchronized method.");
                }
            } else {
                lock = this.declaringNameSpace.getThis(interpreter);
            }
            Object object = lock;
            synchronized (object) {
                return this.invokeImpl(argValues, interpreter, callstack, callerInfo, overrideNameSpace);
            }
        }
        return this.invokeImpl(argValues, interpreter, callstack, callerInfo, overrideNameSpace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object invokeImpl(Object[] argValues, Interpreter interpreter, CallStack callstack, Node callerInfo, boolean overrideNameSpace) throws EvalError {
        String className;
        This thiz;
        NameSpace localNameSpace;
        if (this.hasModifier("abstract")) {
            throw new EvalError("Cannot invoke abstract method " + this.name, callerInfo, callstack);
        }
        Class<?> returnType = this.getReturnType();
        Class<?>[] paramTypes = this.getParameterTypes();
        if (callstack == null) {
            callstack = new CallStack(this.declaringNameSpace);
        }
        if (argValues == null) {
            argValues = Reflect.ZERO_ARGS;
        }
        if (!this.isVarArgs() && argValues.length != this.getParameterCount()) {
            throw new EvalError("Wrong number of arguments for local method: " + this.name, callerInfo, callstack);
        }
        if (overrideNameSpace) {
            localNameSpace = callstack.top();
        } else {
            localNameSpace = new NameSpace(this.declaringNameSpace, this.name);
            localNameSpace.isMethod = true;
        }
        localNameSpace.setNode(callerInfo);
        int lastParamIndex = this.getParameterCount() - 1;
        Object varArgs = null;
        if (this.isVarArgs()) {
            Class<?> lastP = paramTypes[lastParamIndex];
            if (this.getParameterCount() == argValues.length && (argValues[lastParamIndex] == null || argValues[lastParamIndex].getClass().isArray() && lastP.getComponentType().isAssignableFrom(argValues[lastParamIndex].getClass().getComponentType()))) {
                varArgs = null;
            } else if (argValues.length >= this.getParameterCount() - 1) {
                varArgs = Array.newInstance(paramTypes[lastParamIndex].getComponentType(), argValues.length - lastParamIndex);
            }
        }
        for (int i = 0; i < argValues.length; ++i) {
            Class<?> paramType;
            int k = i >= lastParamIndex ? lastParamIndex : i;
            Class<?> clazz = paramType = varArgs != null && k == lastParamIndex ? paramTypes[k].getComponentType() : paramTypes[k];
            if (null != paramType) {
                try {
                    argValues[i] = Types.castObject(argValues[i], paramType, 1);
                }
                catch (UtilEvalError e) {
                    throw new EvalError("Invalid argument: `" + this.paramNames[k] + "' for method: " + this.name + " : " + e.getMessage(), callerInfo, callstack);
                }
                try {
                    if (varArgs != null && i >= lastParamIndex) {
                        Array.set(varArgs, i - k, Primitive.unwrap(argValues[i]));
                        continue;
                    }
                    localNameSpace.setTypedVariable(this.paramNames[k], paramType, argValues[i], this.paramModifiers[k]);
                    continue;
                }
                catch (UtilEvalError e2) {
                    throw e2.toEvalError("Typed method parameter assignment", callerInfo, callstack);
                }
            }
            if (argValues[i] == Primitive.VOID) {
                throw new EvalError("Undefined variable or class name, parameter: " + this.paramNames[k] + " to method: " + this.name, callerInfo, callstack);
            }
            try {
                localNameSpace.setLocalVariable(this.paramNames[k], argValues[i], interpreter.getStrictJava());
                continue;
            }
            catch (UtilEvalError e3) {
                throw e3.toEvalError("Typed method parameter assignment", callerInfo, callstack);
            }
        }
        if (varArgs != null) {
            try {
                localNameSpace.setTypedVariable(this.paramNames[lastParamIndex], paramTypes[lastParamIndex], varArgs, this.paramModifiers[lastParamIndex]);
            }
            catch (UtilEvalError e1) {
                throw e1.toEvalError("Typed method parameter assignment", callerInfo, callstack);
            }
        }
        if (!overrideNameSpace) {
            callstack.push(localNameSpace);
        }
        Object ret = null;
        CallStack returnStack = null;
        try {
            ret = this.methodBody.eval(callstack, interpreter, true);
            returnStack = callstack.copy();
        }
        finally {
            if (!overrideNameSpace) {
                callstack.pop();
            }
        }
        ReturnControl retControl = null;
        if (ret instanceof ReturnControl) {
            retControl = (ReturnControl)ret;
            if (retControl.kind != 47) {
                throw new EvalError("'continue' or 'break' in method body", retControl.returnPoint, returnStack);
            }
            ret = retControl.value;
            if (returnType == Void.TYPE && ret != Primitive.VOID) {
                throw new EvalError("Cannot return value from void method", retControl.returnPoint, returnStack);
            }
        }
        if (returnType != null) {
            if (returnType == Void.TYPE) {
                return Primitive.VOID;
            }
            try {
                ret = Types.castObject(ret, returnType, 1);
            }
            catch (UtilEvalError e) {
                Node node = callerInfo;
                if (retControl != null) {
                    node = retControl.returnPoint;
                }
                throw e.toEvalError("Incorrect type returned from method: " + this.name + e.getMessage(), node, callstack);
            }
        }
        if ("clone".equals(this.getName()) && null != (thiz = Reflect.getClassInstanceThis(ret, className = ret.getClass().getSimpleName()))) {
            return thiz.cloneMethodImpl(callerInfo, callstack, ret);
        }
        return ret;
    }

    public boolean hasModifier(String name) {
        if (this.javaMethod != null) {
            return Reflect.hasModifier(name, this.javaMethod.getModifiers());
        }
        return this.modifiers != null && this.modifiers.hasModifier(name);
    }

    public String toString() {
        return "Method: " + StringUtil.methodString(this);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        BshMethod m = (BshMethod)o;
        if (!this.name.equals(m.name) || this.getParameterCount() != m.getParameterCount()) {
            return false;
        }
        for (int i = 0; i < this.getParameterCount(); ++i) {
            if (BshMethod.equal(this.getParameterTypes()[i], m.getParameterTypes()[i])) continue;
            return false;
        }
        return true;
    }

    protected static boolean equal(Object obj1, Object obj2) {
        return obj1 == null ? obj2 == null : obj1.equals(obj2);
    }

    public int hashCode() {
        int h = this.name.hashCode() + this.getClass().hashCode();
        for (Class<?> cparamType : this.getParameterTypes()) {
            h += 3 + (cparamType == null ? 0 : cparamType.hashCode());
        }
        return h + this.getParameterCount();
    }

    private void reloadTypes() {
        if (this.reload) {
            try {
                this.reload = false;
                if (Reflect.isGeneratedClass(this.creturnType)) {
                    this.creturnType = this.declaringNameSpace.getClass(this.creturnType.getName());
                }
                for (int i = 0; i < this.cparamTypes.length; ++i) {
                    if (!Reflect.isGeneratedClass(this.cparamTypes[i])) continue;
                    this.cparamTypes[i] = this.declaringNameSpace.getClass(this.cparamTypes[i].getName());
                }
            }
            catch (UtilEvalError utilEvalError) {
                // empty catch block
            }
        }
    }

    @Override
    public void classLoaderChanged() {
        this.reload = Reflect.isGeneratedClass(this.creturnType) || Arrays.asList(this.cparamTypes).stream().anyMatch(Reflect::isGeneratedClass);
    }
}

