/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.Capabilities;
import bsh.EvalError;
import bsh.FieldAccess;
import bsh.FileReader;
import bsh.Interpreter;
import bsh.InterpreterError;
import bsh.Invocable;
import bsh.Reflect;
import bsh.Types;
import bsh.UtilEvalError;
import bsh.util.ReferenceCache;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class BshClassManager {
    static final ReferenceCache<Class<?>, MemberCache> memberCache = new ReferenceCache<Class<?>, MemberCache>(ReferenceCache.Type.Soft, ReferenceCache.Type.Soft, 50){

        @Override
        protected MemberCache create(Class<?> key) {
            return new MemberCache(key);
        }
    };
    private Interpreter declaringInterpreter;
    protected ClassLoader externalClassLoader;
    protected final transient Map<String, Class<?>> absoluteClassCache = new ConcurrentHashMap();
    protected final transient Set<String> absoluteNonClasses = ConcurrentHashMap.newKeySet();
    protected final transient Map<String, Class<?>> associatedClasses = new ConcurrentHashMap();

    public boolean getStrictJava() {
        return null != this.declaringInterpreter && this.declaringInterpreter.getStrictJava();
    }

    public static BshClassManager createClassManager(Interpreter interpreter) {
        BshClassManager manager;
        if (Capabilities.classExists("bsh.classpath.ClassManagerImpl")) {
            try {
                Class<?> clazz = Capabilities.getExisting("bsh.classpath.ClassManagerImpl");
                manager = (BshClassManager)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalArgumentException | ReflectiveOperationException | SecurityException e) {
                throw new InterpreterError("Error loading classmanager", e);
            }
        } else {
            manager = new BshClassManager();
        }
        manager.declaringInterpreter = interpreter;
        return manager;
    }

    public boolean classExists(String name) {
        return this.classForName(name) != null;
    }

    public Class<?> classForName(String name) {
        Class<?> clas = null;
        try {
            clas = this.plainClassForName(name);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (clas == null && this.declaringInterpreter.getCompatibility()) {
            clas = this.loadSourceClass(name);
        }
        return clas;
    }

    protected Class<?> loadSourceClass(String name) {
        block10: {
            String fileName = '/' + name.replace('.', '/') + ".java";
            URL url = this.getResource(fileName);
            if (url == null) {
                return null;
            }
            try (FileReader reader = new FileReader((InputStream)url.getContent());){
                Interpreter.debug("Loading class from source file: " + fileName);
                this.declaringInterpreter.eval(reader);
            }
            catch (EvalError | IOException e) {
                if (!Interpreter.DEBUG.get().booleanValue()) break block10;
                e.printStackTrace();
            }
        }
        try {
            return this.plainClassForName(name);
        }
        catch (ClassNotFoundException e) {
            Interpreter.debug("Class not found in source file: " + name);
            return null;
        }
    }

    public Class<?> plainClassForName(String name) throws ClassNotFoundException {
        Class<?> c = null;
        c = this.externalClassLoader != null ? this.externalClassLoader.loadClass(name) : Class.forName(name);
        this.cacheClassInfo(name, c);
        return c;
    }

    public URL getResource(String path) {
        URL url = null;
        if (this.externalClassLoader != null) {
            url = this.externalClassLoader.getResource(path.substring(1));
        }
        if (url == null) {
            return Interpreter.class.getResource(path);
        }
        return url;
    }

    public InputStream getResourceAsStream(String path) {
        InputStream in = null;
        if (this.externalClassLoader != null) {
            in = this.externalClassLoader.getResourceAsStream(path.substring(1));
        }
        if (in == null) {
            return Interpreter.class.getResourceAsStream(path);
        }
        return in;
    }

    public void cacheClassInfo(String name, Class<?> value) {
        if (value != null) {
            this.absoluteClassCache.put(name, value);
            memberCache.init(value);
        } else {
            this.absoluteNonClasses.add(name);
        }
    }

    public void associateClass(Class<?> clas) {
        if (Reflect.isGeneratedClass(clas)) {
            this.associatedClasses.put(clas.getName(), clas);
        }
    }

    public Class<?> getAssociatedClass(String name) {
        return this.associatedClasses.get(name);
    }

    protected void clearCaches() {
        this.absoluteNonClasses.clear();
        this.absoluteClassCache.clear();
        memberCache.clear();
    }

    public void setClassLoader(ClassLoader externalCL) {
        this.externalClassLoader = externalCL;
        this.classLoaderChanged();
    }

    public void addClassPath(URL path) throws IOException {
    }

    public void reset() {
        this.clearCaches();
    }

    public void setClassPath(URL[] cp) throws UtilEvalError {
        throw BshClassManager.cmUnavailable();
    }

    public void reloadAllClasses() throws UtilEvalError {
        throw BshClassManager.cmUnavailable();
    }

    public void reloadClasses(String[] classNames) throws UtilEvalError {
        throw BshClassManager.cmUnavailable();
    }

    public void reloadPackage(String pack) throws UtilEvalError {
        throw BshClassManager.cmUnavailable();
    }

    protected void doSuperImport() throws UtilEvalError {
        throw BshClassManager.cmUnavailable();
    }

    protected boolean hasSuperImport() {
        return false;
    }

    protected String getClassNameByUnqName(String name) throws UtilEvalError {
        throw BshClassManager.cmUnavailable();
    }

    public void addListener(Listener l) {
    }

    public void removeListener(Listener l) {
    }

    public void dump(PrintWriter pw) {
        pw.println("BshClassManager: no class manager.");
    }

    public Class<?> defineClass(String name, byte[] code) {
        throw new InterpreterError("Can't create class (" + name + ") without class manager package.");
    }

    protected void classLoaderChanged() {
    }

    protected static UtilEvalError cmUnavailable() {
        return new Capabilities.Unavailable("ClassLoading features unavailable.");
    }

    public static interface Listener {
        public void classLoaderChanged();
    }

    static final class MemberCache {
        private final Map<String, List<Invocable>> cache = new ConcurrentHashMap<String, List<Invocable>>();
        private final Map<String, Invocable> fields = new ConcurrentHashMap<String, Invocable>();

        public MemberCache(Class<?> clazz) {
            for (Class<?> type = clazz; type != null; type = type.getSuperclass()) {
                if (Reflect.isPackageAccessible(type) && (Reflect.isPackageScope(type) && !Reflect.isPrivate(type) || Reflect.isPublic(type) || Capabilities.haveAccessibility())) {
                    for (Field field : type.getDeclaredFields()) {
                        if (!Reflect.isPublic(field) && !Capabilities.haveAccessibility()) continue;
                        this.cacheMember(Invocable.get(field));
                    }
                    for (AccessibleObject accessibleObject : type.getDeclaredMethods()) {
                        if (!Reflect.isPublic((Member)((Object)accessibleObject)) && !Capabilities.haveAccessibility()) continue;
                        if (clazz == type) {
                            this.cacheMember(Invocable.get((Method)accessibleObject));
                            continue;
                        }
                        this.cacheMember(memberCache.get(type).findMethod(((Method)accessibleObject).getName(), ((Method)accessibleObject).getParameterTypes()));
                    }
                    for (AccessibleObject accessibleObject : type.getDeclaredConstructors()) {
                        if (clazz == type) {
                            this.cacheMember(Invocable.get(accessibleObject));
                            continue;
                        }
                        this.cacheMember(memberCache.get(type).findMethod(((Constructor)accessibleObject).getName(), ((Constructor)accessibleObject).getParameterTypes()));
                    }
                }
                this.processInterfaces(type.getInterfaces());
                memberCache.init(type);
            }
        }

        private void processInterfaces(Class<?>[] interfaces) {
            for (Class<?> intr : interfaces) {
                if (Reflect.isPackageAccessible(intr)) {
                    memberCache.init(intr);
                    for (Field field : intr.getDeclaredFields()) {
                        this.cacheMember(Invocable.get(field));
                    }
                    for (AccessibleObject accessibleObject : intr.getDeclaredMethods()) {
                        if (!Reflect.isPublic((Member)((Object)accessibleObject)) && !Capabilities.haveAccessibility()) continue;
                        this.cacheMember(memberCache.get(intr).findMethod(((Method)accessibleObject).getName(), ((Method)accessibleObject).getParameterTypes()));
                    }
                }
                this.processInterfaces(intr.getInterfaces());
            }
        }

        private boolean cacheMember(FieldAccess member) {
            if (!this.hasField(member.getName())) {
                return null == this.fields.put(member.getName(), member);
            }
            return false;
        }

        private boolean cacheMember(Invocable member) {
            if (null == member) {
                return false;
            }
            if (!member.isGetter() && !member.isSetter()) {
                return this.cacheMember(member.getName(), member);
            }
            String name = member.getName();
            String propName = name.replaceFirst("[gs]et|is", "");
            if (propName.length() == 1 || Character.isLowerCase(name.charAt(1))) {
                char[] ch = propName.toCharArray();
                ch[0] = Character.toLowerCase(ch[0]);
                propName = new String(ch);
            }
            return this.cacheMember(name, member) && this.cacheMember(propName, member);
        }

        private boolean cacheMember(String name, Invocable member) {
            if (!this.hasMember(name)) {
                return null == this.cache.put(name, Collections.singletonList(member));
            }
            if (this.memberCount(name) == 1) {
                this.cache.put(name, new ArrayList<Invocable>(this.members(name)));
            }
            return this.members(name).add(member);
        }

        private Invocable findBest(List<Invocable> list, Class<?>[] types) {
            if (list.isEmpty()) {
                return null;
            }
            if (list.size() == 1) {
                return list.get(0);
            }
            return Reflect.findMostSpecificInvocable(types, list);
        }

        public Invocable findMethod(String name, Object ... args) {
            return this.findMethod(name, Types.getTypes(args));
        }

        public Invocable findMethod(String name, Class<?> ... types) {
            if (!this.hasMember(name)) {
                return null;
            }
            return this.findBest(this.members(name), types);
        }

        public Invocable findStaticMethod(String name) {
            if (!this.hasMember(name)) {
                return null;
            }
            return this.members(name).stream().filter(Invocable::isStatic).findFirst().get();
        }

        public Invocable findGetter(String propName) {
            if (this.hasMember(propName)) {
                for (Invocable property : this.members(propName)) {
                    if (!property.isGetter()) continue;
                    return property;
                }
            }
            return null;
        }

        public Invocable findSetter(String propName) {
            if (this.hasMember(propName)) {
                for (Invocable property : this.members(propName)) {
                    if (!property.isSetter()) continue;
                    return property;
                }
            }
            return null;
        }

        public int findMemberIndex(String name, Class<?>[] types) {
            return Reflect.findMostSpecificInvocableIndex(types, this.members(name));
        }

        public List<Invocable> members(String name) {
            return this.cache.get(name);
        }

        public int memberCount(String name) {
            return this.members(name).size();
        }

        public boolean hasMember(String name) {
            return this.cache.containsKey(name);
        }

        public boolean hasField(String name) {
            return this.fields.containsKey(name);
        }

        public Invocable findField(String name) {
            if (!this.hasField(name)) {
                return null;
            }
            return this.fields.get(name);
        }
    }
}

