/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BSHBlock;
import bsh.BSHIfStatement;
import bsh.CallStack;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.Node;
import bsh.ParserConstants;
import bsh.Primitive;
import bsh.ReturnControl;
import bsh.SimpleNode;

class BSHWhileStatement
extends SimpleNode
implements ParserConstants {
    boolean isDoStatement;
    String label;

    BSHWhileStatement(int id) {
        super(id);
    }

    @Override
    public Object eval(CallStack callstack, Interpreter interpreter) throws EvalError {
        Node body;
        Node condExp;
        int numChild = this.jjtGetNumChildren();
        if (this.isDoStatement) {
            condExp = this.jjtGetChild(1);
            body = this.jjtGetChild(0);
        } else {
            condExp = this.jjtGetChild(0);
            body = numChild > 1 ? this.jjtGetChild(1) : null;
        }
        boolean doOnceFlag = this.isDoStatement;
        while (!Thread.interrupted() && (doOnceFlag || BSHIfStatement.evaluateCondition(condExp, callstack, interpreter))) {
            Object ret;
            doOnceFlag = false;
            if (body == null || !((ret = body instanceof BSHBlock ? ((BSHBlock)body).eval(callstack, interpreter, null) : body.eval(callstack, interpreter)) instanceof ReturnControl)) continue;
            ReturnControl control = (ReturnControl)ret;
            if (!(null == control.label || null != this.label && this.label.equals(control.label))) {
                return ret;
            }
            if (control.kind == 47) {
                return ret;
            }
            if (control.kind != 13) continue;
            break;
        }
        return Primitive.VOID;
    }

    @Override
    public String toString() {
        return super.toString() + ": " + this.label + ": do=" + this.isDoStatement;
    }
}

