/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BSHPrimaryExpression;
import bsh.CallStack;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.LHS;
import bsh.Node;
import bsh.Operators;
import bsh.ParserConstants;
import bsh.Primitive;
import bsh.SimpleNode;
import bsh.UtilEvalError;

class BSHUnaryExpression
extends SimpleNode
implements ParserConstants {
    public int kind;
    public boolean postfix = false;

    BSHUnaryExpression(int id) {
        super(id);
    }

    @Override
    public Object eval(CallStack callstack, Interpreter interpreter) throws EvalError {
        Node node = this.jjtGetChild(0);
        try {
            if (this.kind == 102 || this.kind == 103) {
                LHS lhs = ((BSHPrimaryExpression)node).toLHS(callstack, interpreter);
                return this.lhsUnaryOperation(lhs, interpreter.getStrictJava());
            }
            return this.unaryOperation(node.eval(callstack, interpreter), this.kind);
        }
        catch (UtilEvalError e) {
            throw e.toEvalError(this, callstack);
        }
    }

    private Object lhsUnaryOperation(LHS lhs, boolean strictJava) throws UtilEvalError {
        Interpreter.debug("lhsUnaryOperation");
        Object prevalue = lhs.getValue();
        Object postvalue = this.unaryOperation(prevalue, this.kind);
        Object retVal = this.postfix ? prevalue : postvalue;
        lhs.assign(postvalue, strictJava);
        return retVal;
    }

    private Object unaryOperation(Object op, int kind) throws UtilEvalError {
        if (op instanceof Boolean) {
            Object object = op = (Boolean)op != false ? Primitive.TRUE : Primitive.FALSE;
        }
        if (!(op instanceof Primitive)) {
            throw new UtilEvalError("Unary operation " + tokenImage[kind] + " inappropriate for object");
        }
        return Operators.unaryOperation((Primitive)op, kind);
    }

    @Override
    public String toString() {
        return super.toString() + ": " + tokenImage[this.kind];
    }
}

