/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BSHType;
import bsh.BSHVariableDeclarator;
import bsh.CallStack;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.LHS;
import bsh.Modifiers;
import bsh.NameSpace;
import bsh.Primitive;
import bsh.Reflect;
import bsh.SimpleNode;
import bsh.UtilEvalError;
import bsh.Variable;

class BSHTypedVariableDeclaration
extends SimpleNode {
    private static final long serialVersionUID = 1L;
    public Modifiers modifiers = new Modifiers(3);
    private BSHVariableDeclarator[] bvda;

    BSHTypedVariableDeclaration(int id) {
        super(id);
    }

    private BSHType getTypeNode() {
        return (BSHType)this.jjtGetChild(0);
    }

    Class<?> evalType(CallStack callstack, Interpreter interpreter) throws EvalError {
        BSHType typeNode = this.getTypeNode();
        return typeNode.getType(callstack, interpreter);
    }

    BSHVariableDeclarator[] getDeclarators() {
        if (null != this.bvda) {
            return this.bvda;
        }
        int n = this.jjtGetNumChildren();
        int start = 1;
        this.bvda = new BSHVariableDeclarator[n - start];
        for (int i = start; i < n; ++i) {
            this.bvda[i - start] = (BSHVariableDeclarator)this.jjtGetChild(i);
        }
        return this.bvda;
    }

    @Override
    public Object eval(CallStack callstack, Interpreter interpreter) throws EvalError {
        Object value = Primitive.VOID;
        try {
            NameSpace namespace = callstack.top();
            BSHType typeNode = this.getTypeNode();
            Class<?> type = typeNode.getType(callstack, interpreter);
            BSHVariableDeclarator[] bvda = this.getDeclarators();
            for (int i = 0; i < bvda.length; ++i) {
                BSHVariableDeclarator dec = bvda[i];
                value = dec.eval(typeNode, this.modifiers, callstack, interpreter);
                try {
                    LHS lhs = null;
                    if (namespace.isClass) {
                        lhs = null != namespace.classInstance ? new LHS(namespace.classInstance, Reflect.resolveJavaField(namespace.classStatic, dec.name, this.modifiers.hasModifier("static"))) : new LHS(namespace.classStatic, Reflect.resolveJavaField(namespace.classStatic, dec.name, this.modifiers.hasModifier("static")));
                    }
                    if (null != lhs && null != lhs.field) {
                        Variable var = new Variable(dec.name, type, lhs);
                        var.modifiers = this.modifiers;
                        var.setValue(value, 1);
                        namespace.setVariableImpl(var);
                    } else {
                        if (interpreter.getStrictJava() && value instanceof Primitive && ((Primitive)value).isNumber()) {
                            value = Primitive.castNumberStrictJava(type, ((Primitive)value).numberValue());
                        }
                        namespace.setTypedVariable(dec.name, type, value, this.modifiers);
                        if (!namespace.isMethod) {
                            interpreter.getClassManager().addListener(namespace.getVariableImpl(dec.name, false));
                        }
                    }
                    value = namespace.getVariable(dec.name);
                    continue;
                }
                catch (UtilEvalError e) {
                    throw e.toEvalError(this, callstack);
                }
            }
        }
        catch (EvalError e) {
            throw e.reThrow("Typed variable declaration");
        }
        return value;
    }

    @Override
    public String toString() {
        return super.toString() + ": " + this.modifiers;
    }
}

