/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BSHBlock;
import bsh.BSHMultiCatch;
import bsh.BSHTryWithResources;
import bsh.BlockNameSpace;
import bsh.CallStack;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.InterpreterError;
import bsh.Modifiers;
import bsh.NameSpace;
import bsh.Node;
import bsh.Primitive;
import bsh.ReturnControl;
import bsh.SimpleNode;
import bsh.TargetError;
import bsh.Types;
import bsh.UtilEvalError;
import java.util.ArrayList;
import java.util.List;

class BSHTryStatement
extends SimpleNode {
    final int blockId = BlockNameSpace.blockCount.incrementAndGet();
    BSHTryWithResources tryWithResources = null;

    BSHTryStatement(int id) {
        super(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object eval(CallStack callstack, Interpreter interpreter) throws EvalError {
        Object ret;
        Throwable thrown;
        block36: {
            List<Throwable> tlist;
            int i = 0;
            if (this.jjtGetChild(i) instanceof BSHTryWithResources) {
                this.tryWithResources = (BSHTryWithResources)this.jjtGetChild(i++);
                this.tryWithResources.eval(callstack, interpreter);
            }
            BSHBlock tryBlock = (BSHBlock)this.jjtGetChild(i++);
            ArrayList<BSHMultiCatch> catchParams = new ArrayList<BSHMultiCatch>();
            ArrayList<BSHBlock> catchBlocks = new ArrayList<BSHBlock>();
            int nchild = this.jjtGetNumChildren();
            Node node = null;
            while (i < nchild && (node = this.jjtGetChild(i++)) instanceof BSHMultiCatch) {
                catchParams.add((BSHMultiCatch)node);
                catchBlocks.add((BSHBlock)this.jjtGetChild(i++));
                node = null;
            }
            BSHBlock finallyBlock = null;
            if (node != null) {
                finallyBlock = (BSHBlock)node;
            }
            thrown = null;
            ret = null;
            int callstackDepth = callstack.depth();
            try {
                Interpreter.debug("Evaluate try block");
                try {
                    ret = tryBlock.eval(callstack, interpreter);
                }
                catch (OutOfMemoryError ome) {
                    throw new TargetError(ome.toString(), ome, tryBlock, callstack, false);
                }
            }
            catch (TargetError e) {
                try {
                    Interpreter.debug("Exception from try block: ", e);
                    thrown = e.getTarget();
                    while (callstack.depth() > callstackDepth) {
                        callstack.pop();
                    }
                }
                catch (Throwable throwable) {
                    while (null != thrown && thrown.getCause() instanceof TargetError) {
                        thrown = ((TargetError)thrown.getCause()).getTarget();
                    }
                    if (null != this.tryWithResources) {
                        Interpreter.debug("Try with resources: autoClose");
                        List<Throwable> tlist2 = this.tryWithResources.autoClose();
                        for (Throwable t : tlist2) {
                            if (null == thrown || thrown == t) continue;
                            thrown.addSuppressed(t);
                        }
                    }
                    throw throwable;
                }
                while (null != thrown && thrown.getCause() instanceof TargetError) {
                    thrown = ((TargetError)thrown.getCause()).getTarget();
                }
                if (null != this.tryWithResources) {
                    Interpreter.debug("Try with resources: autoClose");
                    tlist = this.tryWithResources.autoClose();
                    for (Throwable t : tlist) {
                        if (null == thrown || thrown == t) continue;
                        thrown.addSuppressed(t);
                    }
                }
            }
            while (null != thrown && thrown.getCause() instanceof TargetError) {
                thrown = ((TargetError)thrown.getCause()).getTarget();
            }
            if (null != this.tryWithResources) {
                Interpreter.debug("Try with resources: autoClose");
                tlist = this.tryWithResources.autoClose();
                for (Throwable t : tlist) {
                    if (null == thrown || thrown == t) continue;
                    thrown.addSuppressed(t);
                }
            }
            try {
                if (thrown == null) break block36;
                Interpreter.debug("Try catch thrown: ", thrown);
                Class<?> thrownType = thrown.getClass();
                int n = catchParams.size();
                for (i = 0; i < n; ++i) {
                    BSHMultiCatch mc = (BSHMultiCatch)catchParams.get(i);
                    Modifiers modifiers = new Modifiers(4);
                    if (mc.isFinal()) {
                        modifiers.addModifier("final");
                    }
                    mc.eval(callstack, interpreter);
                    if (mc.isUntyped() && interpreter.getStrictJava()) {
                        throw new EvalError("(Strict Java) Untyped catch block", this, callstack);
                    }
                    Class<?> mcType = null;
                    if (!mc.isUntyped()) {
                        boolean found = false;
                        for (Class<?> cType : mc.getTypes()) {
                            found = Types.isBshAssignable(cType, thrownType);
                            if (!found) continue;
                            mcType = cType;
                            break;
                        }
                        if (!found) continue;
                    }
                    BSHBlock cb = (BSHBlock)catchBlocks.get(i);
                    NameSpace enclosingNameSpace = callstack.top();
                    BlockNameSpace cbNameSpace = new BlockNameSpace(callstack.top(), this.blockId);
                    try {
                        if (mcType == BSHMultiCatch.UNTYPED) {
                            cbNameSpace.setBlockVariable(mc.name, thrown);
                        } else {
                            cbNameSpace.setTypedVariable(mc.name, mcType, (Object)thrown, modifiers);
                        }
                    }
                    catch (UtilEvalError e) {
                        throw new InterpreterError("Unable to set var in catch block namespace.");
                    }
                    callstack.swap(cbNameSpace);
                    try {
                        ret = cb.eval(callstack, interpreter, true);
                    }
                    finally {
                        callstack.swap(enclosingNameSpace);
                    }
                    thrown = null;
                    break;
                }
            }
            finally {
                Object result;
                if (finallyBlock != null && (result = finallyBlock.eval(callstack, interpreter)) instanceof ReturnControl) {
                    return result;
                }
            }
        }
        if (null != thrown) {
            throw new TargetError(thrown, (Node)this, callstack);
        }
        return ret instanceof ReturnControl ? ret : Primitive.VOID;
    }
}

