/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BSHAllocationExpression;
import bsh.BSHAmbiguousName;
import bsh.BSHArguments;
import bsh.BSHType;
import bsh.BshArray;
import bsh.CallStack;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.InterpreterError;
import bsh.LHS;
import bsh.Node;
import bsh.Primitive;
import bsh.Reflect;
import bsh.ReflectError;
import bsh.SafeNavigate;
import bsh.SimpleNode;
import bsh.Types;
import bsh.UtilEvalError;
import java.lang.reflect.Array;
import java.util.List;
import java.util.Map;

class BSHPrimarySuffix
extends SimpleNode {
    public static final int CLASS = 6;
    public static final int INDEX = 1;
    public static final int NAME = 2;
    public static final int PROPERTY = 3;
    public static final int NEW = 4;
    public int operation;
    Object index;
    public String field;
    public boolean slice = false;
    public boolean step = false;
    public boolean hasLeftIndex = false;
    public boolean hasRightIndex = false;
    public boolean safeNavigate = false;

    BSHPrimarySuffix(int id) {
        super(id);
    }

    public Object doSuffix(Object obj, boolean toLHS, CallStack callstack, Interpreter interpreter) throws EvalError {
        if (this.operation == 6) {
            if (obj instanceof BSHType) {
                if (toLHS) {
                    throw new EvalError("Can't assign .class", this, callstack);
                }
                return ((BSHType)obj).getType(callstack, interpreter);
            }
            throw new EvalError("Attempt to use .class suffix on non class.", this, callstack);
        }
        if (obj instanceof Node) {
            obj = obj instanceof BSHAmbiguousName ? ((BSHAmbiguousName)obj).toObject(callstack, interpreter) : ((Node)obj).eval(callstack, interpreter);
        } else if (obj instanceof LHS) {
            try {
                obj = ((LHS)obj).getValue();
            }
            catch (UtilEvalError e) {
                throw e.toEvalError(this, callstack);
            }
        }
        try {
            switch (this.operation) {
                case 1: {
                    return this.doIndex(obj, toLHS, callstack, interpreter);
                }
                case 2: {
                    return this.doName(obj, toLHS, callstack, interpreter);
                }
                case 3: {
                    return this.doProperty(toLHS, obj, callstack, interpreter);
                }
                case 4: {
                    return this.doNewInner(obj, toLHS, callstack, interpreter);
                }
            }
            throw new InterpreterError("Unknown suffix type");
        }
        catch (ReflectError e) {
            throw new EvalError("reflection error: " + e, this, callstack, e);
        }
    }

    private Object doNewInner(Object obj, boolean toLHS, CallStack callstack, Interpreter interpreter) throws EvalError {
        BSHAllocationExpression alloc = (BSHAllocationExpression)this.jjtGetChild(0);
        if (Reflect.isGeneratedClass(obj.getClass())) {
            callstack.pop();
            callstack.push(Reflect.getThisNS(obj));
            return alloc.eval(callstack, interpreter);
        }
        return alloc.constructFromEnclosingInstance(obj, callstack, interpreter);
    }

    private Object doName(Object obj, boolean toLHS, CallStack callstack, Interpreter interpreter) throws EvalError, ReflectError {
        if (this.safeNavigate && Primitive.NULL == obj) {
            throw SafeNavigate.doAbort();
        }
        if (this.field.equals("length") && obj.getClass().isArray()) {
            if (toLHS) {
                throw new EvalError("Can't assign array length", this, callstack);
            }
            return new Primitive(Array.getLength(obj));
        }
        if (this.jjtGetNumChildren() == 0) {
            if (toLHS) {
                try {
                    return Reflect.getLHSObjectField(obj, this.field);
                }
                catch (Throwable t) {
                    return new LHS(obj, (Object)this.field);
                }
            }
            try {
                return Reflect.getObjectFieldValue(obj, this.field);
            }
            catch (Throwable t) {
                try {
                    return Reflect.getObjectProperty(obj, this.field);
                }
                catch (Throwable tt) {
                    return Primitive.VOID;
                }
            }
        }
        Object[] oa = ((BSHArguments)this.jjtGetChild(0)).getArguments(callstack, interpreter);
        return Reflect.invokeObjectMethod(obj, this.field, oa, interpreter, callstack, this);
    }

    static int getIndexAux(Object obj, int idx, CallStack callstack, Interpreter interpreter, Node callerInfo) throws EvalError {
        int index;
        try {
            Object indexVal = callerInfo.jjtGetChild(idx).eval(callstack, interpreter);
            if (!(indexVal instanceof Primitive)) {
                indexVal = Types.castObject(indexVal, Integer.TYPE, 1);
            }
            index = (Integer)Primitive.castWrapper(Integer.TYPE, indexVal);
        }
        catch (Exception e) {
            Interpreter.debug("doIndex: " + e);
            throw new EvalError("Array index does not evaluate to an integer.", callerInfo, callstack, e);
        }
        return index;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object doIndex(Object obj, boolean toLHS, CallStack callstack, Interpreter interpreter) throws EvalError {
        int index;
        int length;
        block31: {
            if (!interpreter.getStrictJava()) {
                if (Types.isPropertyTypeMap(obj)) {
                    Object object;
                    Object key = this.jjtGetChild(0).eval(callstack, interpreter);
                    if (toLHS) {
                        object = new LHS(obj, key);
                        return object;
                    }
                    object = Reflect.getObjectProperty(obj, key);
                    return object;
                }
                if (Types.isPropertyTypeEntry(obj)) {
                    Object key = this.jjtGetChild(0).eval(callstack, interpreter);
                    if (!toLHS) return Reflect.getObjectProperty(obj, key);
                    if (!key.equals(((Map.Entry)obj).getKey())) throw new EvalError("No such property: " + key, this, callstack);
                    return new LHS(obj);
                }
            }
            Class<?> cls = obj.getClass();
            if (!(!interpreter.getStrictJava() && obj instanceof List || cls.isArray())) {
                throw new EvalError("Not an array or List type", this, callstack);
            }
            length = obj instanceof List ? ((List)obj).size() : Array.getLength(obj);
            index = length + 1;
            if (!interpreter.getStrictJava() && Types.isPropertyTypeEntryList(cls)) {
                Object key = this.jjtGetChild(0).eval(callstack, interpreter);
                int idx = 0;
                if ((key instanceof Primitive && ((Primitive)key).isNumber() || Primitive.isWrapperType(key.getClass())) && length > (idx = ((Integer)Primitive.castWrapper(Integer.TYPE, key)).intValue()) && -length < idx) {
                    index = idx;
                    break block31;
                } else {
                    if (!toLHS) return Reflect.getObjectProperty(obj, key);
                    return new LHS(Reflect.getEntryForKey(key, (Map.Entry[])obj));
                }
            }
            if (index > length) {
                index = BSHPrimarySuffix.getIndexAux(obj, 0, callstack, interpreter, this);
            }
        }
        if (!interpreter.getStrictJava()) {
            if (0 > index) {
                index = length + index;
            }
            if (this.slice) {
                if (toLHS) {
                    throw new EvalError("cannot assign to array slice", this, callstack);
                }
                int rindex = 0;
                int stepby = 0;
                if (this.step) {
                    Integer step = null;
                    if (this.hasLeftIndex && this.hasRightIndex && this.jjtGetNumChildren() == 3) {
                        step = BSHPrimarySuffix.getIndexAux(obj, 2, callstack, interpreter, this);
                    } else if (!(this.hasLeftIndex && this.hasRightIndex || this.jjtGetNumChildren() != 2)) {
                        step = BSHPrimarySuffix.getIndexAux(obj, 1, callstack, interpreter, this);
                    } else if (!this.hasLeftIndex && !this.hasRightIndex) {
                        step = BSHPrimarySuffix.getIndexAux(obj, 0, callstack, interpreter, this);
                        index = 0;
                    }
                    if (null != step) {
                        if (step == 0) {
                            throw new EvalError("array slice step cannot be zero", this, callstack);
                        }
                        stepby = step;
                    }
                }
                if (this.hasLeftIndex && this.hasRightIndex) {
                    rindex = BSHPrimarySuffix.getIndexAux(obj, 1, callstack, interpreter, this);
                } else if (!this.hasRightIndex) {
                    rindex = length;
                } else {
                    rindex = index;
                    index = 0;
                }
                if (0 > rindex) {
                    rindex = length + rindex;
                }
                if (!obj.getClass().isArray()) return BshArray.slice((List)obj, index, rindex, stepby);
                return BshArray.slice(obj, index, rindex, stepby);
            }
        } else if (this.slice) {
            throw new EvalError("expected ']' but found ':'", this, callstack);
        }
        if (toLHS) {
            return new LHS(obj, index);
        }
        try {
            return BshArray.getIndex(obj, index);
        }
        catch (UtilEvalError e) {
            throw e.toEvalError("Error array get index", this, callstack);
        }
    }

    private Object doProperty(boolean toLHS, Object obj, CallStack callstack, Interpreter interpreter) throws EvalError {
        if (obj == Primitive.VOID) {
            throw new EvalError("Attempt to access property on undefined variable or class name", this, callstack);
        }
        if (obj instanceof Primitive) {
            throw new EvalError("Attempt to access property on a primitive", this, callstack);
        }
        Object value = this.jjtGetChild(0).eval(callstack, interpreter);
        if (!(value instanceof String)) {
            throw new EvalError("Property expression must be a String or identifier.", this, callstack);
        }
        if (toLHS) {
            return new LHS(obj, (Object)((String)value));
        }
        try {
            Object val = Reflect.getObjectProperty(obj, (String)value);
            return null == val ? Primitive.NULL : Primitive.unwrap(val);
        }
        catch (ReflectError e) {
            throw new EvalError("No such property: " + value, this, callstack, e);
        }
    }

    @Override
    public String toString() {
        if (this.operation == 1) {
            return super.toString() + ":INDEX [" + this.hasLeftIndex + ":" + this.slice + " " + this.hasRightIndex + ":" + this.step + "]";
        }
        if (this.operation == 2) {
            return super.toString() + ":NAME " + this.field;
        }
        if (this.operation == 3) {
            return super.toString() + ":PROPERTY {}";
        }
        if (this.operation == 4) {
            return super.toString() + ":NEW new";
        }
        if (this.operation == 6) {
            return super.toString() + ":CLASS class";
        }
        return super.toString() + ":NO OPERATION";
    }
}

