/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BSHAmbiguousName;
import bsh.BSHBlock;
import bsh.BSHFormalParameters;
import bsh.BSHReturnStatement;
import bsh.BSHReturnType;
import bsh.BshMethod;
import bsh.CallStack;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.Modifiers;
import bsh.NameSpace;
import bsh.Node;
import bsh.Primitive;
import bsh.SimpleNode;

class BSHMethodDeclaration
extends SimpleNode {
    public String name;
    BSHReturnType returnTypeNode;
    BSHFormalParameters paramsNode;
    BSHBlock blockNode;
    int firstThrowsClause;
    public Modifiers modifiers = new Modifiers(2);
    Class<?> returnType;
    int numThrows = 0;
    boolean isVarArgs;
    private boolean isScriptedObject;

    BSHMethodDeclaration(int id) {
        super(id);
    }

    synchronized void insureNodesParsed() {
        Node crnt;
        if (this.paramsNode != null) {
            return;
        }
        Node firstNode = this.jjtGetChild(0);
        this.firstThrowsClause = 1;
        if (firstNode instanceof BSHReturnType) {
            this.returnTypeNode = (BSHReturnType)firstNode;
            this.paramsNode = (BSHFormalParameters)this.jjtGetChild(1);
            if (this.jjtGetNumChildren() > 2 + this.numThrows) {
                this.blockNode = (BSHBlock)this.jjtGetChild(2 + this.numThrows);
            }
            ++this.firstThrowsClause;
        } else {
            this.paramsNode = (BSHFormalParameters)this.jjtGetChild(0);
            this.blockNode = (BSHBlock)this.jjtGetChild(1 + this.numThrows);
        }
        if (null != this.blockNode && this.blockNode.jjtGetNumChildren() > 0 && (crnt = this.blockNode.jjtGetChild(this.blockNode.jjtGetNumChildren() - 1)) instanceof BSHReturnStatement) {
            while (crnt.hasNext()) {
                if (!((crnt = (Node)crnt.next()) instanceof BSHAmbiguousName)) continue;
                this.isScriptedObject = ((BSHAmbiguousName)crnt).text.startsWith("this");
            }
        }
        this.paramsNode.insureParsed();
        this.isVarArgs = this.paramsNode.isVarArgs;
    }

    Class<?> evalReturnType(CallStack callstack, Interpreter interpreter) throws EvalError {
        this.insureNodesParsed();
        if (this.returnTypeNode != null) {
            return this.returnTypeNode.evalReturnType(callstack, interpreter);
        }
        return null;
    }

    String getReturnTypeDescriptor(CallStack callstack, Interpreter interpreter, String defaultPackage) {
        this.insureNodesParsed();
        if (this.returnTypeNode == null) {
            return null;
        }
        return this.returnTypeNode.getTypeDescriptor(callstack, interpreter, defaultPackage);
    }

    BSHReturnType getReturnTypeNode() {
        this.insureNodesParsed();
        return this.returnTypeNode;
    }

    @Override
    public Object eval(CallStack callstack, Interpreter interpreter) throws EvalError {
        this.returnType = this.evalReturnType(callstack, interpreter);
        this.evalNodes(callstack, interpreter);
        NameSpace namespace = callstack.top();
        BshMethod bshMethod = new BshMethod(this, namespace, this.modifiers, this.isScriptedObject);
        if (!namespace.isMethod && !namespace.isClass) {
            interpreter.getClassManager().addListener(bshMethod);
        } else if (namespace.isMethod && !this.paramsNode.isListener()) {
            interpreter.getClassManager().addListener(this.paramsNode);
            this.paramsNode.setListener(true);
        }
        namespace.setMethod(bshMethod);
        return Primitive.VOID;
    }

    private void evalNodes(CallStack callstack, Interpreter interpreter) throws EvalError {
        int i;
        this.insureNodesParsed();
        for (i = this.firstThrowsClause; i < this.numThrows + this.firstThrowsClause; ++i) {
            ((BSHAmbiguousName)this.jjtGetChild(i)).toClass(callstack, interpreter);
        }
        this.paramsNode.eval(callstack, interpreter);
        if (interpreter.getStrictJava()) {
            for (i = 0; i < this.paramsNode.paramTypes.length; ++i) {
                if (this.paramsNode.paramTypes[i] != null) continue;
                throw new EvalError("(Strict Java Mode) Undeclared argument type, parameter: " + this.paramsNode.getParamNames()[i] + " in method: " + this.name, this, null);
            }
            if (this.returnType == null) {
                throw new EvalError("(Strict Java Mode) Undeclared return type for method: " + this.name, this, null);
            }
        }
    }

    @Override
    public String toString() {
        return super.toString() + ": " + this.name;
    }
}

