/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BSHAmbiguousName;
import bsh.BshMethod;
import bsh.CallStack;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.LHS;
import bsh.Name;
import bsh.NameSpace;
import bsh.Primitive;
import bsh.Reflect;
import bsh.SimpleNode;
import bsh.UtilEvalError;

class BSHImportDeclaration
extends SimpleNode {
    private static final long serialVersionUID = 1L;
    public boolean importPackage;
    public boolean staticImport;
    public boolean superImport;

    BSHImportDeclaration(int id) {
        super(id);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object eval(CallStack callstack, Interpreter interpreter) throws EvalError {
        NameSpace namespace = callstack.top();
        if (this.superImport) {
            try {
                namespace.doSuperImport();
                return Primitive.VOID;
            }
            catch (UtilEvalError e) {
                throw e.toEvalError(this, callstack);
            }
        }
        BSHAmbiguousName ambigName = (BSHAmbiguousName)this.jjtGetChild(0);
        if (this.staticImport) {
            if (this.importPackage) {
                Class<?> clas = ambigName.toClass(callstack, interpreter);
                namespace.importStatic(clas);
                return Primitive.VOID;
            }
            Object obj = null;
            Class<?> clas = null;
            String name = Name.suffix(ambigName.text, 1);
            try {
                clas = namespace.getClass(Name.prefix(ambigName.text));
                obj = Reflect.staticMethodImport(clas, name);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (null != clas && null == obj) {
                    obj = Reflect.getLHSStaticField(clas, name);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (null == obj) {
                    obj = ambigName.toObject(callstack, interpreter);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (obj instanceof BshMethod) {
                namespace.setMethod((BshMethod)obj);
                return Primitive.VOID;
            }
            if (!(obj instanceof LHS)) {
                obj = ambigName.toLHS(callstack, interpreter);
            }
            if (!(obj instanceof LHS) || !((LHS)obj).isStatic()) throw new EvalError(ambigName.text + " is not a static member of a class", this, callstack);
            namespace.setVariableImpl(((LHS)obj).getVariable());
            return Primitive.VOID;
        }
        String name = ambigName.text;
        if (this.importPackage) {
            namespace.importPackage(name);
            return Primitive.VOID;
        } else {
            namespace.importClass(name);
        }
        return Primitive.VOID;
    }

    @Override
    public String toString() {
        return super.toString() + ": static=" + this.staticImport + ", *=" + this.importPackage + ", super import=" + this.superImport;
    }
}

