/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.CallStack;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.Node;
import bsh.Primitive;
import bsh.ReturnControl;
import bsh.SimpleNode;

class BSHIfStatement
extends SimpleNode {
    boolean isClosed;

    BSHIfStatement(int id) {
        super(id);
    }

    @Override
    public Object eval(CallStack callstack, Interpreter interpreter) throws EvalError {
        Object ret = null;
        if (BSHIfStatement.evaluateCondition(this.jjtGetChild(0), callstack, interpreter)) {
            if (!this.isClosed) {
                ret = this.jjtGetChild(1).eval(callstack, interpreter);
            }
        } else if (this.jjtGetNumChildren() > 2) {
            ret = this.jjtGetChild(2).eval(callstack, interpreter);
        } else if (this.isClosed) {
            ret = this.jjtGetChild(1).eval(callstack, interpreter);
        }
        if (ret instanceof ReturnControl) {
            return ret;
        }
        return Primitive.VOID;
    }

    public static boolean evaluateCondition(Node condExp, CallStack callstack, Interpreter interpreter) throws EvalError {
        Object obj = condExp.eval(callstack, interpreter);
        if (obj == Primitive.VOID) {
            throw new EvalError("Condition evaluates to void type", condExp, callstack);
        }
        obj = Primitive.castWrapper(Boolean.TYPE, obj);
        return (Boolean)obj;
    }
}

