/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BSHFormalParameter;
import bsh.BshClassManager;
import bsh.CallStack;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.Modifiers;
import bsh.SimpleNode;

class BSHFormalParameters
extends SimpleNode
implements BshClassManager.Listener {
    private String[] paramNames;
    private Modifiers[] paramModifiers;
    private boolean listener;
    Class<?>[] paramTypes;
    int numArgs;
    String[] typeDescriptors;
    boolean isVarArgs;

    BSHFormalParameters(int id) {
        super(id);
    }

    void insureParsed() {
        if (this.paramNames != null) {
            return;
        }
        this.numArgs = this.jjtGetNumChildren();
        String[] paramNames = new String[this.numArgs];
        Modifiers[] paramModifiers = new Modifiers[this.numArgs];
        for (int i = 0; i < this.numArgs; ++i) {
            BSHFormalParameter param = (BSHFormalParameter)this.jjtGetChild(i);
            this.isVarArgs = param.isVarArgs;
            paramNames[i] = param.name;
            paramModifiers[i] = new Modifiers(4);
            if (!param.isFinal) continue;
            paramModifiers[i].addModifier("final");
        }
        this.paramNames = paramNames;
        this.paramModifiers = paramModifiers;
    }

    public Modifiers[] getParamModifiers() {
        this.insureParsed();
        return this.paramModifiers;
    }

    public String[] getParamNames() {
        this.insureParsed();
        return this.paramNames;
    }

    public String[] getTypeDescriptors(CallStack callstack, Interpreter interpreter, String defaultPackage) {
        if (this.typeDescriptors != null) {
            return this.typeDescriptors;
        }
        this.insureParsed();
        String[] typeDesc = new String[this.numArgs];
        for (int i = 0; i < this.numArgs; ++i) {
            BSHFormalParameter param = (BSHFormalParameter)this.jjtGetChild(i);
            typeDesc[i] = param.getTypeDescriptor(callstack, interpreter, defaultPackage);
        }
        this.typeDescriptors = typeDesc;
        return typeDesc;
    }

    @Override
    public Object eval(CallStack callstack, Interpreter interpreter) throws EvalError {
        if (this.paramTypes != null) {
            return this.paramTypes;
        }
        this.insureParsed();
        Class[] paramTypes = new Class[this.numArgs];
        for (int i = 0; i < this.numArgs; ++i) {
            BSHFormalParameter param = (BSHFormalParameter)this.jjtGetChild(i);
            paramTypes[i] = (Class)param.eval(callstack, interpreter);
        }
        this.paramTypes = paramTypes;
        return paramTypes;
    }

    public boolean isListener() {
        return this.listener;
    }

    public void setListener(boolean listener) {
        this.listener = listener;
    }

    @Override
    public void classLoaderChanged() {
        this.paramTypes = null;
    }
}

