/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BSHBlock;
import bsh.BSHIfStatement;
import bsh.BlockNameSpace;
import bsh.CallStack;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.NameSpace;
import bsh.Node;
import bsh.ParserConstants;
import bsh.Primitive;
import bsh.ReturnControl;
import bsh.SimpleNode;

class BSHForStatement
extends SimpleNode
implements ParserConstants {
    final int blockId = BlockNameSpace.blockCount.incrementAndGet();
    public boolean hasForInit;
    public boolean hasExpression;
    public boolean hasForUpdate;
    String label;

    BSHForStatement(int id) {
        super(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object eval(CallStack callstack, Interpreter interpreter) throws EvalError {
        int i = 0;
        Node forInit = this.hasForInit ? this.jjtGetChild(i++) : null;
        Node expression = this.hasExpression ? this.jjtGetChild(i++) : null;
        Node forUpdate = this.hasForUpdate ? this.jjtGetChild(i++) : null;
        Node statement = i < this.jjtGetNumChildren() ? this.jjtGetChild(i) : null;
        NameSpace enclosingNameSpace = callstack.top();
        BlockNameSpace forNameSpace = new BlockNameSpace(enclosingNameSpace, this.blockId);
        callstack.swap(forNameSpace);
        try {
            if (this.hasForInit) {
                forInit.eval(callstack, interpreter);
            }
            while (!(Thread.interrupted() || this.hasExpression && !BSHIfStatement.evaluateCondition(expression, callstack, interpreter))) {
                if (statement != null) {
                    Object ret;
                    Object object = ret = statement instanceof BSHBlock ? ((BSHBlock)statement).eval(callstack, interpreter, null) : statement.eval(callstack, interpreter);
                    if (ret instanceof ReturnControl) {
                        ReturnControl control = (ReturnControl)ret;
                        if (!(null == control.label || null != this.label && this.label.equals(control.label))) {
                            Object object2 = ret;
                            return object2;
                        }
                        if (control.kind == 47) {
                            Object object3 = ret;
                            return object3;
                        }
                        if (control.kind == 13) break;
                    }
                }
                if (!this.hasForUpdate) continue;
                forUpdate.eval(callstack, interpreter);
            }
            Primitive primitive = Primitive.VOID;
            return primitive;
        }
        finally {
            callstack.swap(enclosingNameSpace);
        }
    }

    @Override
    public String toString() {
        return super.toString() + ": " + this.label + ": " + this.hasForInit + " ; " + this.hasExpression + " ; " + this.hasForUpdate;
    }
}

