/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BSHBlock;
import bsh.BSHType;
import bsh.BlockNameSpace;
import bsh.CallStack;
import bsh.CollectionManager;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.Modifiers;
import bsh.NameSpace;
import bsh.Node;
import bsh.ParserConstants;
import bsh.Primitive;
import bsh.ReturnControl;
import bsh.SimpleNode;
import bsh.UtilEvalError;
import java.util.Iterator;

class BSHEnhancedForStatement
extends SimpleNode
implements ParserConstants {
    final int blockId = BlockNameSpace.blockCount.incrementAndGet();
    String varName;
    String label;
    boolean isFinal = false;

    BSHEnhancedForStatement(int id) {
        super(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object eval(CallStack callstack, Interpreter interpreter) throws EvalError {
        Node statement;
        Node expression;
        Modifiers modifiers = new Modifiers(4);
        if (this.isFinal) {
            modifiers.addModifier("final");
        }
        Class<?> elementType = null;
        NameSpace enclosingNameSpace = callstack.top();
        Node firstNode = this.jjtGetChild(0);
        int nodeCount = this.jjtGetNumChildren();
        if (firstNode instanceof BSHType) {
            elementType = ((BSHType)firstNode).getType(callstack, interpreter);
            expression = this.jjtGetChild(1);
            statement = nodeCount > 2 ? this.jjtGetChild(2) : null;
        } else {
            expression = firstNode;
            statement = nodeCount > 1 ? this.jjtGetChild(1) : null;
        }
        Object iteratee = expression.eval(callstack, interpreter);
        CollectionManager cm = CollectionManager.getCollectionManager();
        Iterator<?> iterator = cm.getBshIterator(iteratee);
        try {
            while (!Thread.interrupted() && iterator.hasNext()) {
                Object ret;
                try {
                    NameSpace eachNameSpace = BlockNameSpace.getInstance(enclosingNameSpace, this.blockId);
                    callstack.swap(eachNameSpace);
                    Object value = iterator.next();
                    if (value == null) {
                        value = Primitive.NULL;
                    }
                    eachNameSpace.setTypedVariable(this.varName, elementType, value, modifiers);
                }
                catch (UtilEvalError e) {
                    throw e.toEvalError("for loop iterator variable:" + this.varName, this, callstack);
                }
                if (statement == null || !((ret = statement instanceof BSHBlock ? ((BSHBlock)statement).eval(callstack, interpreter, null) : statement.eval(callstack, interpreter)) instanceof ReturnControl)) continue;
                ReturnControl control = (ReturnControl)ret;
                if (!(null == control.label || null != this.label && this.label.equals(control.label))) {
                    Object object = ret;
                    return object;
                }
                if (control.kind == 47) {
                    Object object = ret;
                    return object;
                }
                if (control.kind != 13) continue;
            }
            Primitive primitive = Primitive.VOID;
            return primitive;
        }
        finally {
            callstack.swap(enclosingNameSpace);
        }
    }

    @Override
    public String toString() {
        return super.toString() + ": " + this.label + ": " + this.varName + ", final=" + this.isFinal;
    }
}

