/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BSHClassDeclaration;
import bsh.BSHEnumConstant;
import bsh.BlockNameSpace;
import bsh.CallStack;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.NameSpace;
import bsh.Node;
import bsh.Primitive;
import bsh.ReturnControl;
import bsh.SimpleNode;
import java.util.ArrayList;

class BSHBlock
extends SimpleNode {
    final int blockId = BlockNameSpace.blockCount.incrementAndGet();
    public boolean isSynchronized = false;
    public boolean isStatic = false;
    private boolean hasClassDeclaration = false;
    private boolean isFirst = true;

    BSHBlock(int id) {
        super(id);
    }

    @Override
    public Object eval(CallStack callstack, Interpreter interpreter) throws EvalError {
        return this.eval(callstack, interpreter, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object eval(CallStack callstack, Interpreter interpreter, Boolean overrideNamespace) throws EvalError {
        if (this.isSynchronized) {
            Object syncValue;
            Node exp = this.jjtGetChild(0);
            Object object = syncValue = exp.eval(callstack, interpreter);
            synchronized (object) {
                return this.evalBlock(callstack, interpreter, overrideNamespace, null);
            }
        }
        return this.evalBlock(callstack, interpreter, overrideNamespace, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object evalBlock(CallStack callstack, Interpreter interpreter, Boolean overrideNamespace, NodeFilter nodeFilter) throws EvalError {
        Object ret = Primitive.VOID;
        NameSpace enclosingNameSpace = null == overrideNamespace ? callstack.swap(BlockNameSpace.getInstance(callstack.top(), this.blockId)) : (overrideNamespace == false ? callstack.swap(new BlockNameSpace(callstack.top(), this.blockId)) : null);
        int startChild = this.isSynchronized ? 1 : 0;
        int numChildren = this.jjtGetNumChildren();
        try {
            if (this.isFirst || this.hasClassDeclaration) {
                for (int i = startChild; i < numChildren; ++i) {
                    Node node = this.jjtGetChild(i);
                    if (nodeFilter != null && !nodeFilter.isVisible(node) || !(node instanceof BSHClassDeclaration)) continue;
                    this.hasClassDeclaration = true;
                    node.eval(callstack, interpreter);
                }
            }
            ArrayList<Node> enumBlocks = null;
            for (int i = startChild; i < numChildren; ++i) {
                Node node = this.jjtGetChild(i);
                if (node instanceof BSHClassDeclaration || nodeFilter != null && !nodeFilter.isVisible(node)) continue;
                if (node instanceof BSHEnumConstant) {
                    if (enumBlocks == null) {
                        enumBlocks = new ArrayList<Node>();
                    }
                    enumBlocks.add(node);
                    continue;
                }
                ret = node.eval(callstack, interpreter);
                if (ret instanceof ReturnControl) break;
            }
            if (enumBlocks != null) {
                while (!enumBlocks.isEmpty()) {
                    ((Node)enumBlocks.remove(0)).eval(callstack, interpreter);
                }
            }
            Primitive primitive = ret;
            return primitive;
        }
        finally {
            this.isFirst = false;
            if (null != enclosingNameSpace) {
                callstack.swap(enclosingNameSpace);
            }
        }
    }

    @Override
    public String toString() {
        return super.toString() + ": static=" + this.isStatic + ", synchronized=" + this.isSynchronized;
    }

    public static interface NodeFilter {
        public boolean isVisible(Node var1);
    }
}

