/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BSHPrimaryExpression;
import bsh.CallStack;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.InterpreterError;
import bsh.LHS;
import bsh.Operators;
import bsh.ParserConstants;
import bsh.Primitive;
import bsh.SafeNavigate;
import bsh.SimpleNode;
import bsh.UtilEvalError;

class BSHAssignment
extends SimpleNode
implements ParserConstants {
    private static final long serialVersionUID = 1L;
    public Integer operator;

    BSHAssignment(int id) {
        super(id);
    }

    @Override
    public Object eval(CallStack callstack, Interpreter interpreter) throws EvalError {
        if (null == this.operator) {
            try {
                return this.jjtGetChild(0).eval(callstack, interpreter);
            }
            catch (SafeNavigate aborted) {
                return Primitive.NULL;
            }
        }
        BSHPrimaryExpression lhsNode = (BSHPrimaryExpression)this.jjtGetChild(0);
        boolean strictJava = interpreter.getStrictJava();
        LHS lhs = lhsNode.toLHS(callstack, interpreter);
        Object lhsValue = null;
        if (this.operator != 85) {
            try {
                lhsValue = lhs.getValue();
            }
            catch (UtilEvalError e) {
                throw e.toEvalError(this, callstack);
            }
        }
        if (this.operator == 146 && Primitive.NULL != lhsValue) {
            return lhsValue;
        }
        Object rhs = this.jjtGetChild(1).eval(callstack, interpreter);
        if (rhs == Primitive.VOID) {
            throw new EvalError("illegal void assignment", this, callstack);
        }
        try {
            switch (this.operator) {
                case 85: {
                    if (lhs.isFinal()) {
                        lhs.getVariable().setValue(rhs, 1);
                        return rhs;
                    }
                    return lhs.assign(rhs, strictJava);
                }
                case 146: {
                    return lhs.assign(rhs, strictJava);
                }
                case 124: {
                    if (Primitive.NULL == lhsValue && lhs.getType() == String.class) {
                        lhsValue = "null";
                    }
                    return lhs.assign(this.operation(lhsValue, rhs, 104), strictJava);
                }
                case 125: {
                    return lhs.assign(this.operation(lhsValue, rhs, 105), strictJava);
                }
                case 126: {
                    return lhs.assign(this.operation(lhsValue, rhs, 106), strictJava);
                }
                case 127: {
                    return lhs.assign(this.operation(lhsValue, rhs, 107), strictJava);
                }
                case 128: 
                case 129: {
                    return lhs.assign(this.operation(lhsValue, rhs, 108), strictJava);
                }
                case 130: 
                case 131: {
                    return lhs.assign(this.operation(lhsValue, rhs, 110), strictJava);
                }
                case 132: 
                case 133: {
                    return lhs.assign(this.operation(lhsValue, rhs, 112), strictJava);
                }
                case 134: 
                case 135: {
                    return lhs.assign(this.operation(lhsValue, rhs, 114), strictJava);
                }
                case 136: 
                case 137: {
                    return lhs.assign(this.operation(lhsValue, rhs, 116), strictJava);
                }
                case 138: 
                case 139: {
                    return lhs.assign(this.operation(lhsValue, rhs, 118), strictJava);
                }
                case 140: 
                case 141: {
                    return lhs.assign(this.operation(lhsValue, rhs, 120), strictJava);
                }
                case 142: 
                case 143: {
                    return lhs.assign(this.operation(lhsValue, rhs, 122), strictJava);
                }
            }
            throw new InterpreterError("unimplemented operator in assignment BSH");
        }
        catch (UtilEvalError e) {
            throw e.toEvalError(this, callstack);
        }
    }

    private Object operation(Object lhs, Object rhs, int kind) throws UtilEvalError {
        if (lhs instanceof String || lhs.getClass().isArray()) {
            return Operators.arbitraryObjectsBinaryOperation(lhs, rhs, kind);
        }
        if (rhs == Primitive.NULL) {
            throw new UtilEvalError("Illegal use of null object or 'null' literal");
        }
        if ((lhs instanceof Boolean || lhs instanceof Character || lhs instanceof Number || lhs instanceof Primitive) && (rhs instanceof Boolean || rhs instanceof Character || rhs instanceof Number || rhs instanceof Primitive)) {
            return Operators.binaryOperation(lhs, rhs, kind);
        }
        throw new UtilEvalError("Non primitive value in operator: " + lhs.getClass() + " " + tokenImage[kind] + " " + rhs.getClass());
    }

    @Override
    public String toString() {
        return super.toString() + (null == this.operator ? "" : ": " + tokenImage[this.operator]);
    }
}

