/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class PartitionPathUtils {
    private static final BitSet CHAR_TO_ESCAPE;

    private static boolean needsEscaping(char c) {
        return c < CHAR_TO_ESCAPE.size() && CHAR_TO_ESCAPE.get(c);
    }

    public static String generatePartitionPath(LinkedHashMap<String, String> partitionSpec) {
        if (partitionSpec.isEmpty()) {
            return "";
        }
        StringBuilder suffixBuf = new StringBuilder();
        int i = 0;
        for (Map.Entry<String, String> e : partitionSpec.entrySet()) {
            if (i > 0) {
                suffixBuf.append("/");
            }
            suffixBuf.append(PartitionPathUtils.escapePathName(e.getKey()));
            suffixBuf.append('=');
            suffixBuf.append(PartitionPathUtils.escapePathName(e.getValue()));
            ++i;
        }
        suffixBuf.append("/");
        return suffixBuf.toString();
    }

    public static List<String> generateHierarchicalPartitionPaths(LinkedHashMap<String, String> partitionSpec) {
        ArrayList<String> paths = new ArrayList<String>();
        if (partitionSpec.isEmpty()) {
            return paths;
        }
        StringBuilder suffixBuf = new StringBuilder();
        for (Map.Entry<String, String> e : partitionSpec.entrySet()) {
            suffixBuf.append(PartitionPathUtils.escapePathName(e.getKey()));
            suffixBuf.append('=');
            suffixBuf.append(PartitionPathUtils.escapePathName(e.getValue()));
            suffixBuf.append("/");
            paths.add(suffixBuf.toString());
        }
        return paths;
    }

    static String escapePathName(String path) {
        if (path == null || path.length() == 0) {
            throw new RuntimeException("Path should not be null or empty: " + path);
        }
        StringBuilder sb = null;
        for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (PartitionPathUtils.needsEscaping(c)) {
                if (sb == null) {
                    sb = new StringBuilder(path.length() + 2);
                    for (int j = 0; j < i; ++j) {
                        sb.append(path.charAt(j));
                    }
                }
                PartitionPathUtils.escapeChar(c, sb);
                continue;
            }
            if (sb == null) continue;
            sb.append(c);
        }
        if (sb == null) {
            return path;
        }
        return sb.toString();
    }

    private static void escapeChar(char c, StringBuilder sb) {
        sb.append('%');
        if (c < '\u0010') {
            sb.append('0');
        }
        sb.append(Integer.toHexString(c).toUpperCase());
    }

    static {
        char[] clist;
        CHAR_TO_ESCAPE = new BitSet(128);
        for (int c = 0; c < 32; c = (int)((char)(c + 1))) {
            CHAR_TO_ESCAPE.set(c);
        }
        for (char c : clist = new char[]{'\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', '\"', '#', '%', '\'', '*', '/', ':', '=', '?', '\\', '\u007f', '{', '}', '[', ']', '^'}) {
            CHAR_TO_ESCAPE.set(c);
        }
    }
}

