/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.format.FormatReaderFactory;
import org.apache.paimon.format.FormatWriter;
import org.apache.paimon.format.FormatWriterFactory;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.fs.PositionOutputStream;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.utils.CloseableIterator;
import org.apache.paimon.utils.FileUtils;
import org.apache.paimon.utils.Filter;
import org.apache.paimon.utils.ObjectSerializer;
import org.apache.paimon.utils.ObjectsCache;
import org.apache.paimon.utils.PathFactory;
import org.apache.paimon.utils.SegmentsCache;

public abstract class ObjectsFile<T> {
    protected final FileIO fileIO;
    protected final ObjectSerializer<T> serializer;
    protected final FormatReaderFactory readerFactory;
    protected final FormatWriterFactory writerFactory;
    protected final PathFactory pathFactory;
    @Nullable
    private final ObjectsCache<String, T> cache;

    protected ObjectsFile(FileIO fileIO, ObjectSerializer<T> serializer, FormatReaderFactory readerFactory, FormatWriterFactory writerFactory, PathFactory pathFactory, @Nullable SegmentsCache<String> cache) {
        this.fileIO = fileIO;
        this.serializer = serializer;
        this.readerFactory = readerFactory;
        this.writerFactory = writerFactory;
        this.pathFactory = pathFactory;
        this.cache = cache == null ? null : new ObjectsCache<String, T>(cache, serializer, this::createIterator);
    }

    public long fileSize(String fileName) {
        try {
            return this.fileIO.getFileSize(this.pathFactory.toPath(fileName));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public List<T> read(String fileName) {
        return this.read(fileName, Filter.alwaysTrue(), Filter.alwaysTrue());
    }

    public boolean exists(String fileName) {
        try {
            return this.fileIO.exists(this.pathFactory.toPath(fileName));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public List<T> read(String fileName, Filter<InternalRow> loadFilter, Filter<InternalRow> readFilter) {
        try {
            if (this.cache != null) {
                return this.cache.read(fileName, loadFilter, readFilter);
            }
            RecordReader<InternalRow> reader = FileUtils.createFormatReader(this.fileIO, this.readerFactory, this.pathFactory.toPath(fileName));
            if (readFilter != Filter.ALWAYS_TRUE) {
                reader = reader.filter(readFilter);
            }
            ArrayList result = new ArrayList();
            reader.forEachRemaining(row -> result.add(this.serializer.fromRow((InternalRow)row)));
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read manifest list " + fileName, e);
        }
    }

    public String writeWithoutRolling(Collection<T> records) {
        return this.writeWithoutRolling(records.iterator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String writeWithoutRolling(Iterator<T> records) {
        Path path = this.pathFactory.newPath();
        try {
            try (PositionOutputStream out = this.fileIO.newOutputStream(path, false);){
                FormatWriter writer = this.writerFactory.create(out, CoreOptions.FILE_COMPRESSION.defaultValue());
                try {
                    while (records.hasNext()) {
                        writer.addElement(this.serializer.toRow(records.next()));
                    }
                }
                finally {
                    writer.flush();
                    writer.finish();
                }
            }
            return path.getName();
        }
        catch (Throwable e) {
            this.fileIO.deleteQuietly(path);
            throw new RuntimeException("Exception occurs when writing records to " + path + ". Clean up.", e);
        }
    }

    private CloseableIterator<InternalRow> createIterator(String fileName) {
        try {
            return FileUtils.createFormatReader(this.fileIO, this.readerFactory, this.pathFactory.toPath(fileName)).toCloseableIterator();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void delete(String fileName) {
        this.fileIO.deleteQuietly(this.pathFactory.toPath(fileName));
    }
}

