/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.paimon.data.BinaryArray;
import org.apache.paimon.data.BinaryMap;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.DataGetters;
import org.apache.paimon.data.Decimal;
import org.apache.paimon.data.GenericArray;
import org.apache.paimon.data.GenericMap;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalArray;
import org.apache.paimon.data.InternalMap;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.NestedRow;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.types.ArrayType;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeRoot;
import org.apache.paimon.types.DecimalType;
import org.apache.paimon.types.IntType;
import org.apache.paimon.types.LocalZonedTimestampType;
import org.apache.paimon.types.MapType;
import org.apache.paimon.types.MultisetType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.types.TimestampType;

public class InternalRowUtils {
    public static InternalRow copyInternalRow(InternalRow row, RowType rowType) {
        if (row instanceof BinaryRow) {
            return ((BinaryRow)row).copy();
        }
        if (row instanceof NestedRow) {
            return ((NestedRow)row).copy();
        }
        GenericRow ret = new GenericRow(row.getFieldCount());
        ret.setRowKind(row.getRowKind());
        for (int i = 0; i < row.getFieldCount(); ++i) {
            DataType fieldType = rowType.getTypeAt(i);
            ret.setField(i, InternalRowUtils.copy(InternalRowUtils.get(row, i, fieldType), fieldType));
        }
        return ret;
    }

    public static InternalArray copyArray(InternalArray from, DataType eleType) {
        if (from instanceof BinaryArray) {
            return ((BinaryArray)from).copy();
        }
        if (!eleType.isNullable()) {
            switch (eleType.getTypeRoot()) {
                case BOOLEAN: {
                    return new GenericArray(from.toBooleanArray());
                }
                case TINYINT: {
                    return new GenericArray(from.toByteArray());
                }
                case SMALLINT: {
                    return new GenericArray(from.toShortArray());
                }
                case INTEGER: 
                case DATE: 
                case TIME_WITHOUT_TIME_ZONE: {
                    return new GenericArray(from.toIntArray());
                }
                case BIGINT: {
                    return new GenericArray(from.toLongArray());
                }
                case FLOAT: {
                    return new GenericArray(from.toFloatArray());
                }
                case DOUBLE: {
                    return new GenericArray(from.toDoubleArray());
                }
            }
        }
        Object[] newArray = new Object[from.size()];
        for (int i = 0; i < newArray.length; ++i) {
            newArray[i] = !from.isNullAt(i) ? InternalRowUtils.copy(InternalRowUtils.get(from, i, eleType), eleType) : null;
        }
        return new GenericArray(newArray);
    }

    private static InternalMap copyMap(InternalMap map, DataType keyType, DataType valueType) {
        if (map instanceof BinaryMap) {
            return ((BinaryMap)map).copy();
        }
        HashMap<Object, Object> javaMap = new HashMap<Object, Object>();
        InternalArray keys = map.keyArray();
        InternalArray values = map.valueArray();
        for (int i = 0; i < keys.size(); ++i) {
            javaMap.put(InternalRowUtils.copy(InternalRowUtils.get(keys, i, keyType), keyType), InternalRowUtils.copy(InternalRowUtils.get(values, i, valueType), valueType));
        }
        return new GenericMap(javaMap);
    }

    public static Object copy(Object o, DataType type) {
        if (o instanceof BinaryString) {
            return ((BinaryString)o).copy();
        }
        if (o instanceof InternalRow) {
            return InternalRowUtils.copyInternalRow((InternalRow)o, (RowType)type);
        }
        if (o instanceof InternalArray) {
            return InternalRowUtils.copyArray((InternalArray)o, ((ArrayType)type).getElementType());
        }
        if (o instanceof InternalMap) {
            if (type instanceof MapType) {
                return InternalRowUtils.copyMap((InternalMap)o, ((MapType)type).getKeyType(), ((MapType)type).getValueType());
            }
            return InternalRowUtils.copyMap((InternalMap)o, ((MultisetType)type).getElementType(), new IntType());
        }
        if (o instanceof Decimal) {
            return ((Decimal)o).copy();
        }
        return o;
    }

    public static Object get(DataGetters dataGetters, int pos, DataType fieldType) {
        if (dataGetters.isNullAt(pos)) {
            return null;
        }
        switch (fieldType.getTypeRoot()) {
            case BOOLEAN: {
                return dataGetters.getBoolean(pos);
            }
            case TINYINT: {
                return dataGetters.getByte(pos);
            }
            case SMALLINT: {
                return dataGetters.getShort(pos);
            }
            case INTEGER: 
            case DATE: 
            case TIME_WITHOUT_TIME_ZONE: {
                return dataGetters.getInt(pos);
            }
            case BIGINT: {
                return dataGetters.getLong(pos);
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                TimestampType timestampType = (TimestampType)fieldType;
                return dataGetters.getTimestamp(pos, timestampType.getPrecision());
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                LocalZonedTimestampType lzTs = (LocalZonedTimestampType)fieldType;
                return dataGetters.getTimestamp(pos, lzTs.getPrecision());
            }
            case FLOAT: {
                return Float.valueOf(dataGetters.getFloat(pos));
            }
            case DOUBLE: {
                return dataGetters.getDouble(pos);
            }
            case CHAR: 
            case VARCHAR: {
                return dataGetters.getString(pos);
            }
            case DECIMAL: {
                DecimalType decimalType = (DecimalType)fieldType;
                return dataGetters.getDecimal(pos, decimalType.getPrecision(), decimalType.getScale());
            }
            case ARRAY: {
                return dataGetters.getArray(pos);
            }
            case MAP: 
            case MULTISET: {
                return dataGetters.getMap(pos);
            }
            case ROW: {
                return dataGetters.getRow(pos, ((RowType)fieldType).getFieldCount());
            }
            case BINARY: 
            case VARBINARY: {
                return dataGetters.getBinary(pos);
            }
        }
        throw new UnsupportedOperationException("Unsupported type: " + fieldType);
    }

    public static InternalArray toStringArrayData(List<String> list) {
        return new GenericArray(list.stream().map(BinaryString::fromString).toArray());
    }

    public static List<String> fromStringArrayData(InternalArray arrayData) {
        ArrayList<String> list = new ArrayList<String>(arrayData.size());
        for (int i = 0; i < arrayData.size(); ++i) {
            list.add(arrayData.isNullAt(i) ? null : arrayData.getString(i).toString());
        }
        return list;
    }

    public static long castToIntegral(Decimal dec) {
        BigDecimal bd = dec.toBigDecimal();
        bd = bd.setScale(0, RoundingMode.DOWN);
        return bd.longValue();
    }

    public static InternalRow.FieldGetter[] createFieldGetters(List<DataType> fieldTypes) {
        InternalRow.FieldGetter[] fieldGetters = new InternalRow.FieldGetter[fieldTypes.size()];
        for (int i = 0; i < fieldTypes.size(); ++i) {
            fieldGetters[i] = InternalRowUtils.createNullCheckingFieldGetter(fieldTypes.get(i), i);
        }
        return fieldGetters;
    }

    public static InternalRow.FieldGetter createNullCheckingFieldGetter(DataType dataType, int index) {
        InternalRow.FieldGetter getter = InternalRow.createFieldGetter(dataType, index);
        if (dataType.isNullable()) {
            return getter;
        }
        return row -> {
            if (row.isNullAt(index)) {
                return null;
            }
            return getter.getFieldOrNull(row);
        };
    }

    public static int compare(Object x, Object y, DataTypeRoot type) {
        int ret;
        switch (type) {
            case DECIMAL: {
                Decimal xDD = (Decimal)x;
                Decimal yDD = (Decimal)y;
                ret = xDD.compareTo(yDD);
                break;
            }
            case TINYINT: {
                ret = Byte.compare((Byte)x, (Byte)y);
                break;
            }
            case SMALLINT: {
                ret = Short.compare((Short)x, (Short)y);
                break;
            }
            case INTEGER: 
            case DATE: 
            case TIME_WITHOUT_TIME_ZONE: {
                ret = Integer.compare((Integer)x, (Integer)y);
                break;
            }
            case BIGINT: {
                ret = Long.compare((Long)x, (Long)y);
                break;
            }
            case FLOAT: {
                ret = Float.compare(((Float)x).floatValue(), ((Float)y).floatValue());
                break;
            }
            case DOUBLE: {
                ret = Double.compare((Double)x, (Double)y);
                break;
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                Timestamp xDD1 = (Timestamp)x;
                Timestamp yDD1 = (Timestamp)y;
                ret = xDD1.compareTo(yDD1);
                break;
            }
            case BINARY: 
            case VARBINARY: {
                ret = InternalRowUtils.byteArrayCompare((byte[])x, (byte[])y);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return ret;
    }

    private static int byteArrayCompare(byte[] array1, byte[] array2) {
        int i = 0;
        for (int j = 0; i < array1.length && j < array2.length; ++i, ++j) {
            int a = array1[i] & 0xFF;
            int b = array2[j] & 0xFF;
            if (a == b) continue;
            return a - b;
        }
        return array1.length - array2.length;
    }
}

