/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import java.util.List;
import javax.annotation.Nullable;
import org.apache.paimon.KeyValue;
import org.apache.paimon.casting.CastFieldGetter;
import org.apache.paimon.format.FileFormatDiscover;
import org.apache.paimon.format.FormatReaderFactory;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.schema.IndexCastMapping;
import org.apache.paimon.schema.KeyValueFieldsExtractor;
import org.apache.paimon.schema.SchemaEvolutionUtil;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.Projection;

public class BulkFormatMapping {
    @Nullable
    private final int[] indexMapping;
    @Nullable
    private final CastFieldGetter[] castMapping;
    private final FormatReaderFactory bulkFormat;

    public BulkFormatMapping(int[] indexMapping, @Nullable CastFieldGetter[] castMapping, FormatReaderFactory bulkFormat) {
        this.indexMapping = indexMapping;
        this.castMapping = castMapping;
        this.bulkFormat = bulkFormat;
    }

    @Nullable
    public int[] getIndexMapping() {
        return this.indexMapping;
    }

    @Nullable
    public CastFieldGetter[] getCastMapping() {
        return this.castMapping;
    }

    public FormatReaderFactory getReaderFactory() {
        return this.bulkFormat;
    }

    public static BulkFormatMappingBuilder newBuilder(FileFormatDiscover formatDiscover, KeyValueFieldsExtractor extractor, int[][] keyProjection, int[][] valueProjection, @Nullable List<Predicate> filters) {
        return new BulkFormatMappingBuilder(formatDiscover, extractor, keyProjection, valueProjection, filters);
    }

    public static class BulkFormatMappingBuilder {
        private final FileFormatDiscover formatDiscover;
        private final KeyValueFieldsExtractor extractor;
        private final int[][] keyProjection;
        private final int[][] valueProjection;
        @Nullable
        private final List<Predicate> filters;

        private BulkFormatMappingBuilder(FileFormatDiscover formatDiscover, KeyValueFieldsExtractor extractor, int[][] keyProjection, int[][] valueProjection, @Nullable List<Predicate> filters) {
            this.formatDiscover = formatDiscover;
            this.extractor = extractor;
            this.keyProjection = keyProjection;
            this.valueProjection = valueProjection;
            this.filters = filters;
        }

        public BulkFormatMapping build(String formatIdentifier, TableSchema tableSchema, TableSchema dataSchema) {
            List<DataField> tableKeyFields = this.extractor.keyFields(tableSchema);
            List<DataField> tableValueFields = this.extractor.valueFields(tableSchema);
            int[][] tableProjection = KeyValue.project(this.keyProjection, this.valueProjection, tableKeyFields.size());
            List<DataField> dataKeyFields = this.extractor.keyFields(dataSchema);
            List<DataField> dataValueFields = this.extractor.valueFields(dataSchema);
            RowType keyType = new RowType(dataKeyFields);
            RowType valueType = new RowType(dataValueFields);
            RowType dataRecordType = KeyValue.schema(keyType, valueType);
            int[][] dataKeyProjection = SchemaEvolutionUtil.createDataProjection(tableKeyFields, dataKeyFields, this.keyProjection);
            int[][] dataValueProjection = SchemaEvolutionUtil.createDataProjection(tableValueFields, dataValueFields, this.valueProjection);
            int[][] dataProjection = KeyValue.project(dataKeyProjection, dataValueProjection, dataKeyFields.size());
            IndexCastMapping indexCastMapping = SchemaEvolutionUtil.createIndexCastMapping(Projection.of(tableProjection).toTopLevelIndexes(), tableKeyFields, tableValueFields, Projection.of(dataProjection).toTopLevelIndexes(), dataKeyFields, dataValueFields);
            List<Predicate> dataFilters = tableSchema.id() == dataSchema.id() ? this.filters : SchemaEvolutionUtil.createDataFilters(tableSchema.fields(), dataSchema.fields(), this.filters);
            return new BulkFormatMapping(indexCastMapping.getIndexMapping(), indexCastMapping.getCastMapping(), this.formatDiscover.discover(formatIdentifier).createReaderFactory(dataRecordType, dataProjection, dataFilters));
        }
    }
}

