/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.source.snapshot;

import org.apache.paimon.table.source.snapshot.SnapshotReader;
import org.apache.paimon.table.source.snapshot.StartingScanner;
import org.apache.paimon.utils.SnapshotManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContinuousLatestStartingScanner
implements StartingScanner {
    private static final Logger LOG = LoggerFactory.getLogger(ContinuousLatestStartingScanner.class);

    @Override
    public StartingScanner.Result scan(SnapshotManager snapshotManager, SnapshotReader snapshotReader) {
        Long startingSnapshotId = snapshotManager.latestSnapshotId();
        if (startingSnapshotId == null) {
            LOG.debug("There is currently no snapshot. Wait for the snapshot generation.");
            return new StartingScanner.NoSnapshot();
        }
        return new StartingScanner.NextSnapshot(startingSnapshotId + 1L);
    }
}

