/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.stats;

import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.GenericArray;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalArray;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.format.FieldStats;
import org.apache.paimon.stats.FieldStatsArraySerializer;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.SerializationUtils;

public class BinaryTableStats {
    @Nullable
    private InternalRow row;
    @Nullable
    private FieldStats[] cacheArray;
    @Nullable
    private BinaryRow cacheMin;
    @Nullable
    private BinaryRow cacheMax;
    @Nullable
    private Long[] cacheNullCounts;

    public BinaryTableStats(InternalRow row) {
        this.row = row;
    }

    public BinaryTableStats(BinaryRow cacheMin, BinaryRow cacheMax, Long[] cacheNullCounts) {
        this(cacheMin, cacheMax, cacheNullCounts, null);
    }

    public BinaryTableStats(BinaryRow cacheMin, BinaryRow cacheMax, Long[] cacheNullCounts, @Nullable FieldStats[] cacheArray) {
        this.cacheMin = cacheMin;
        this.cacheMax = cacheMax;
        this.cacheNullCounts = cacheNullCounts;
        this.cacheArray = cacheArray;
    }

    public FieldStats[] fields(FieldStatsArraySerializer converter) {
        return this.fields(converter, null);
    }

    public FieldStats[] fields(FieldStatsArraySerializer converter, @Nullable Long rowCount) {
        if (this.cacheArray == null) {
            this.cacheArray = converter.fromBinary(this, rowCount);
        }
        return this.cacheArray;
    }

    public BinaryRow min() {
        if (this.cacheMin == null) {
            Preconditions.checkNotNull(this.row);
            this.cacheMin = SerializationUtils.deserializeBinaryRow(this.row.getBinary(0));
        }
        return this.cacheMin;
    }

    public BinaryRow max() {
        if (this.cacheMax == null) {
            Preconditions.checkNotNull(this.row);
            this.cacheMax = SerializationUtils.deserializeBinaryRow(this.row.getBinary(1));
        }
        return this.cacheMax;
    }

    public Long[] nullCounts() {
        if (this.cacheNullCounts == null) {
            Preconditions.checkNotNull(this.row);
            InternalArray internalArray = this.row.getArray(2);
            Long[] array = new Long[internalArray.size()];
            for (int i = 0; i < array.length; ++i) {
                array[i] = internalArray.isNullAt(i) ? null : Long.valueOf(internalArray.getLong(i));
            }
            return array;
        }
        return this.cacheNullCounts;
    }

    public InternalRow toRowData() {
        return this.row == null ? GenericRow.of(SerializationUtils.serializeBinaryRow(this.min()), SerializationUtils.serializeBinaryRow(this.max()), new GenericArray((Object[])this.nullCounts())) : this.row;
    }

    public static BinaryTableStats fromRowData(InternalRow row) {
        return new BinaryTableStats(row);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BinaryTableStats that = (BinaryTableStats)o;
        return Objects.equals(this.min(), that.min()) && Objects.equals(this.max(), that.max()) && Arrays.equals((Object[])this.nullCounts(), (Object[])that.nullCounts());
    }

    public int hashCode() {
        int result = Objects.hash(this.min(), this.max());
        result = 31 * result + Arrays.hashCode((Object[])this.nullCounts());
        return result;
    }
}

