/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.sort.zorder;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import org.apache.paimon.data.Decimal;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.types.ArrayType;
import org.apache.paimon.types.BigIntType;
import org.apache.paimon.types.BinaryType;
import org.apache.paimon.types.BooleanType;
import org.apache.paimon.types.CharType;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeVisitor;
import org.apache.paimon.types.DateType;
import org.apache.paimon.types.DecimalType;
import org.apache.paimon.types.DoubleType;
import org.apache.paimon.types.FloatType;
import org.apache.paimon.types.IntType;
import org.apache.paimon.types.LocalZonedTimestampType;
import org.apache.paimon.types.MapType;
import org.apache.paimon.types.MultisetType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.types.SmallIntType;
import org.apache.paimon.types.TimeType;
import org.apache.paimon.types.TimestampType;
import org.apache.paimon.types.TinyIntType;
import org.apache.paimon.types.VarBinaryType;
import org.apache.paimon.types.VarCharType;
import org.apache.paimon.utils.ZOrderByteUtils;

public class ZIndexer
implements Serializable {
    private final Set<RowProcessor> functionSet;
    private final int[] fieldsIndex;
    private final int totalBytes;
    private transient ByteBuffer reuse;

    public ZIndexer(RowType rowType, List<String> orderColumns) {
        List<String> fields = rowType.getFieldNames();
        this.fieldsIndex = new int[orderColumns.size()];
        for (int i = 0; i < this.fieldsIndex.length; ++i) {
            int index = fields.indexOf(orderColumns.get(i));
            if (index == -1) {
                throw new IllegalArgumentException("Can't find column: " + orderColumns.get(i) + " in row type fields: " + fields);
            }
            this.fieldsIndex[i] = index;
        }
        this.functionSet = this.constructFunctionMap(rowType.getFields());
        this.totalBytes = 8 * this.fieldsIndex.length;
    }

    public void open() {
        this.reuse = ByteBuffer.allocate(this.totalBytes);
        this.functionSet.forEach(RowProcessor::open);
    }

    public int size() {
        return this.totalBytes;
    }

    public byte[] index(InternalRow row) {
        byte[][] columnBytes = new byte[this.fieldsIndex.length][];
        int index = 0;
        for (RowProcessor f : this.functionSet) {
            columnBytes[index++] = f.zvalue(row);
        }
        return ZOrderByteUtils.interleaveBits(columnBytes, this.totalBytes, this.reuse);
    }

    public Set<RowProcessor> constructFunctionMap(List<DataField> fields) {
        LinkedHashSet<RowProcessor> zorderFunctionSet = new LinkedHashSet<RowProcessor>();
        for (int index : this.fieldsIndex) {
            DataField field = fields.get(index);
            zorderFunctionSet.add(ZIndexer.zmapColumnToCalculator(field, index));
        }
        return zorderFunctionSet;
    }

    public static RowProcessor zmapColumnToCalculator(DataField field, int index) {
        DataType type = field.type();
        return type.accept(new TypeVisitor(index));
    }

    static interface ZProcessFunction
    extends BiFunction<InternalRow, ByteBuffer, byte[]>,
    Serializable {
    }

    public static class RowProcessor
    implements Serializable {
        private transient ByteBuffer reuse;
        private final ZProcessFunction process;

        public RowProcessor(ZProcessFunction process) {
            this.process = process;
        }

        public void open() {
            this.reuse = ByteBuffer.allocate(8);
        }

        public byte[] zvalue(InternalRow o) {
            return (byte[])this.process.apply(o, this.reuse);
        }
    }

    public static class TypeVisitor
    implements DataTypeVisitor<RowProcessor> {
        private final int fieldIndex;

        public TypeVisitor(int index) {
            this.fieldIndex = index;
        }

        @Override
        public RowProcessor visit(CharType charType) {
            InternalRow.FieldGetter fieldGetter = InternalRow.createFieldGetter(charType, this.fieldIndex);
            return new RowProcessor((row, reuse) -> {
                Object o = fieldGetter.getFieldOrNull((InternalRow)row);
                return o == null ? ZOrderByteUtils.NULL_BYTES : ZOrderByteUtils.stringToOrderedBytes(o.toString(), 8, reuse).array();
            });
        }

        @Override
        public RowProcessor visit(VarCharType varCharType) {
            InternalRow.FieldGetter fieldGetter = InternalRow.createFieldGetter(varCharType, this.fieldIndex);
            return new RowProcessor((row, reuse) -> {
                Object o = fieldGetter.getFieldOrNull((InternalRow)row);
                return o == null ? ZOrderByteUtils.NULL_BYTES : ZOrderByteUtils.stringToOrderedBytes(o.toString(), 8, reuse).array();
            });
        }

        @Override
        public RowProcessor visit(BooleanType booleanType) {
            InternalRow.FieldGetter fieldGetter = InternalRow.createFieldGetter(booleanType, this.fieldIndex);
            return new RowProcessor((row, reuse) -> {
                Object o = fieldGetter.getFieldOrNull((InternalRow)row);
                if (o == null) {
                    return ZOrderByteUtils.NULL_BYTES;
                }
                ZOrderByteUtils.reuse(reuse, 8);
                reuse.put(0, (byte)((Boolean)o != false ? -127 : 0));
                return reuse.array();
            });
        }

        @Override
        public RowProcessor visit(BinaryType binaryType) {
            InternalRow.FieldGetter fieldGetter = InternalRow.createFieldGetter(binaryType, this.fieldIndex);
            return new RowProcessor((row, reuse) -> {
                Object o = fieldGetter.getFieldOrNull((InternalRow)row);
                return o == null ? ZOrderByteUtils.NULL_BYTES : ZOrderByteUtils.byteTruncateOrFill((byte[])o, 8, reuse).array();
            });
        }

        @Override
        public RowProcessor visit(VarBinaryType varBinaryType) {
            InternalRow.FieldGetter fieldGetter = InternalRow.createFieldGetter(varBinaryType, this.fieldIndex);
            return new RowProcessor((row, reuse) -> {
                Object o = fieldGetter.getFieldOrNull((InternalRow)row);
                return o == null ? ZOrderByteUtils.NULL_BYTES : ZOrderByteUtils.byteTruncateOrFill((byte[])o, 8, reuse).array();
            });
        }

        @Override
        public RowProcessor visit(DecimalType decimalType) {
            InternalRow.FieldGetter fieldGetter = InternalRow.createFieldGetter(decimalType, this.fieldIndex);
            return new RowProcessor((row, reuse) -> {
                Object o = fieldGetter.getFieldOrNull((InternalRow)row);
                return o == null ? ZOrderByteUtils.NULL_BYTES : ZOrderByteUtils.byteTruncateOrFill(((Decimal)o).toUnscaledBytes(), 8, reuse).array();
            });
        }

        @Override
        public RowProcessor visit(TinyIntType tinyIntType) {
            InternalRow.FieldGetter fieldGetter = InternalRow.createFieldGetter(tinyIntType, this.fieldIndex);
            return new RowProcessor((row, reuse) -> {
                Object o = fieldGetter.getFieldOrNull((InternalRow)row);
                return o == null ? ZOrderByteUtils.NULL_BYTES : ZOrderByteUtils.tinyintToOrderedBytes((Byte)o, reuse).array();
            });
        }

        @Override
        public RowProcessor visit(SmallIntType smallIntType) {
            InternalRow.FieldGetter fieldGetter = InternalRow.createFieldGetter(smallIntType, this.fieldIndex);
            return new RowProcessor((row, reuse) -> {
                Object o = fieldGetter.getFieldOrNull((InternalRow)row);
                return o == null ? ZOrderByteUtils.NULL_BYTES : ZOrderByteUtils.shortToOrderedBytes((Short)o, reuse).array();
            });
        }

        @Override
        public RowProcessor visit(IntType intType) {
            InternalRow.FieldGetter fieldGetter = InternalRow.createFieldGetter(intType, this.fieldIndex);
            return new RowProcessor((row, reuse) -> {
                Object o = fieldGetter.getFieldOrNull((InternalRow)row);
                return o == null ? ZOrderByteUtils.NULL_BYTES : ZOrderByteUtils.intToOrderedBytes((Integer)o, reuse).array();
            });
        }

        @Override
        public RowProcessor visit(BigIntType bigIntType) {
            InternalRow.FieldGetter fieldGetter = InternalRow.createFieldGetter(bigIntType, this.fieldIndex);
            return new RowProcessor((row, reuse) -> {
                Object o = fieldGetter.getFieldOrNull((InternalRow)row);
                return o == null ? ZOrderByteUtils.NULL_BYTES : ZOrderByteUtils.longToOrderedBytes((Long)o, reuse).array();
            });
        }

        @Override
        public RowProcessor visit(FloatType floatType) {
            InternalRow.FieldGetter fieldGetter = InternalRow.createFieldGetter(floatType, this.fieldIndex);
            return new RowProcessor((row, reuse) -> {
                Object o = fieldGetter.getFieldOrNull((InternalRow)row);
                return o == null ? ZOrderByteUtils.NULL_BYTES : ZOrderByteUtils.floatToOrderedBytes(((Float)o).floatValue(), reuse).array();
            });
        }

        @Override
        public RowProcessor visit(DoubleType doubleType) {
            InternalRow.FieldGetter fieldGetter = InternalRow.createFieldGetter(doubleType, this.fieldIndex);
            return new RowProcessor((row, reuse) -> {
                Object o = fieldGetter.getFieldOrNull((InternalRow)row);
                return o == null ? ZOrderByteUtils.NULL_BYTES : ZOrderByteUtils.doubleToOrderedBytes((Double)o, reuse).array();
            });
        }

        @Override
        public RowProcessor visit(DateType dateType) {
            InternalRow.FieldGetter fieldGetter = InternalRow.createFieldGetter(dateType, this.fieldIndex);
            return new RowProcessor((row, reuse) -> {
                Object o = fieldGetter.getFieldOrNull((InternalRow)row);
                return o == null ? ZOrderByteUtils.NULL_BYTES : ZOrderByteUtils.intToOrderedBytes((Integer)o, reuse).array();
            });
        }

        @Override
        public RowProcessor visit(TimeType timeType) {
            InternalRow.FieldGetter fieldGetter = InternalRow.createFieldGetter(timeType, this.fieldIndex);
            return new RowProcessor((row, reuse) -> {
                Object o = fieldGetter.getFieldOrNull((InternalRow)row);
                return o == null ? ZOrderByteUtils.NULL_BYTES : ZOrderByteUtils.intToOrderedBytes((Integer)o, reuse).array();
            });
        }

        @Override
        public RowProcessor visit(TimestampType timestampType) {
            InternalRow.FieldGetter fieldGetter = InternalRow.createFieldGetter(timestampType, this.fieldIndex);
            return new RowProcessor((row, reuse) -> {
                Object o = fieldGetter.getFieldOrNull((InternalRow)row);
                return o == null ? ZOrderByteUtils.NULL_BYTES : ZOrderByteUtils.longToOrderedBytes(((Timestamp)o).getMillisecond(), reuse).array();
            });
        }

        @Override
        public RowProcessor visit(LocalZonedTimestampType localZonedTimestampType) {
            InternalRow.FieldGetter fieldGetter = InternalRow.createFieldGetter(localZonedTimestampType, this.fieldIndex);
            return new RowProcessor((row, reuse) -> {
                Object o = fieldGetter.getFieldOrNull((InternalRow)row);
                return o == null ? ZOrderByteUtils.NULL_BYTES : ZOrderByteUtils.longToOrderedBytes(((Timestamp)o).getMillisecond(), reuse).array();
            });
        }

        @Override
        public RowProcessor visit(ArrayType arrayType) {
            throw new RuntimeException("Unsupported type");
        }

        @Override
        public RowProcessor visit(MultisetType multisetType) {
            throw new RuntimeException("Unsupported type");
        }

        @Override
        public RowProcessor visit(MapType mapType) {
            throw new RuntimeException("Unsupported type");
        }

        @Override
        public RowProcessor visit(RowType rowType) {
            throw new RuntimeException("Unsupported type");
        }
    }
}

