/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.shade.org.apache.hadoop.hive.ql.exec.vector;

import java.util.Arrays;
import org.apache.paimon.shade.org.apache.hadoop.hive.ql.exec.vector.ColumnVector;

public class BytesColumnVector
extends ColumnVector {
    public byte[][] vector;
    public int[] start;
    public int[] length;
    private byte[] buffer;
    private int nextFree;
    private byte[] smallBuffer;
    private int smallBufferNextFree;
    private int bufferAllocationCount;
    static final int DEFAULT_BUFFER_SIZE = 16384;
    static final float EXTRA_SPACE_FACTOR = 1.2f;
    static final int MAX_SIZE_FOR_SMALL_BUFFER = 0x100000;

    public BytesColumnVector() {
        this(1024);
    }

    public BytesColumnVector(int size) {
        super(ColumnVector.Type.BYTES, size);
        this.vector = new byte[size][];
        this.start = new int[size];
        this.length = new int[size];
    }

    @Override
    public void reset() {
        super.reset();
        this.initBuffer(0);
    }

    public void setRef(int elementNum, byte[] sourceBuf, int start, int length) {
        this.vector[elementNum] = sourceBuf;
        this.start[elementNum] = start;
        this.length[elementNum] = length;
    }

    public void initBuffer(int estimatedValueSize) {
        this.nextFree = 0;
        this.smallBufferNextFree = 0;
        if (this.buffer != null) {
            if (this.bufferAllocationCount > 0) {
                for (int idx = 0; idx < this.vector.length; ++idx) {
                    this.vector[idx] = null;
                }
                this.buffer = this.smallBuffer;
            }
        } else {
            int bufferSize = this.vector.length * (int)((float)estimatedValueSize * 1.2f);
            if (bufferSize < 16384) {
                bufferSize = 16384;
            }
            this.buffer = new byte[bufferSize];
            this.smallBuffer = this.buffer;
        }
        this.bufferAllocationCount = 0;
    }

    public void initBuffer() {
        this.initBuffer(0);
    }

    public int bufferSize() {
        if (this.buffer == null) {
            return 0;
        }
        return this.buffer.length;
    }

    public void setVal(int elementNum, byte[] sourceBuf, int start, int length) {
        if (this.nextFree + length > this.buffer.length) {
            this.increaseBufferSpace(length);
        }
        if (length > 0) {
            System.arraycopy(sourceBuf, start, this.buffer, this.nextFree, length);
        }
        this.vector[elementNum] = this.buffer;
        this.start[elementNum] = this.nextFree;
        this.length[elementNum] = length;
        this.nextFree += length;
    }

    public void setVal(int elementNum, byte[] sourceBuf) {
        this.setVal(elementNum, sourceBuf, 0, sourceBuf.length);
    }

    public void ensureValPreallocated(int length) {
        if (this.nextFree + length > this.buffer.length) {
            this.increaseBufferSpace(length);
        }
    }

    public byte[] getValPreallocatedBytes() {
        return this.buffer;
    }

    public int getValPreallocatedStart() {
        return this.nextFree;
    }

    public void setValPreallocated(int elementNum, int length) {
        this.vector[elementNum] = this.buffer;
        this.start[elementNum] = this.nextFree;
        this.length[elementNum] = length;
        this.nextFree += length;
    }

    public void setConcat(int elementNum, byte[] leftSourceBuf, int leftStart, int leftLen, byte[] rightSourceBuf, int rightStart, int rightLen) {
        int newLen = leftLen + rightLen;
        if (this.nextFree + newLen > this.buffer.length) {
            this.increaseBufferSpace(newLen);
        }
        this.vector[elementNum] = this.buffer;
        this.start[elementNum] = this.nextFree;
        this.length[elementNum] = newLen;
        System.arraycopy(leftSourceBuf, leftStart, this.buffer, this.nextFree, leftLen);
        this.nextFree += leftLen;
        System.arraycopy(rightSourceBuf, rightStart, this.buffer, this.nextFree, rightLen);
        this.nextFree += rightLen;
    }

    public void increaseBufferSpace(int nextElemLength) {
        if (nextElemLength > 0x100000) {
            byte[] newBuffer = new byte[nextElemLength];
            ++this.bufferAllocationCount;
            if (this.smallBuffer == this.buffer) {
                this.smallBufferNextFree = this.nextFree;
            }
            this.buffer = newBuffer;
            this.nextFree = 0;
        } else {
            if (this.smallBuffer != this.buffer) {
                this.buffer = this.smallBuffer;
                this.nextFree = this.smallBufferNextFree;
            }
            if (this.nextFree + nextElemLength > this.buffer.length) {
                int newLength;
                for (newLength = this.smallBuffer.length * 2; newLength < nextElemLength; newLength *= 2) {
                    if (newLength >= 0) continue;
                    throw new RuntimeException("Overflow of newLength. smallBuffer.length=" + this.smallBuffer.length + ", nextElemLength=" + nextElemLength);
                }
                this.smallBuffer = new byte[newLength];
                ++this.bufferAllocationCount;
                this.smallBufferNextFree = 0;
                this.buffer = this.smallBuffer;
                this.nextFree = 0;
            }
        }
    }

    @Override
    public void copySelected(boolean selectedInUse, int[] sel, int size, ColumnVector outputColVector) {
        BytesColumnVector output = (BytesColumnVector)outputColVector;
        boolean[] outputIsNull = output.isNull;
        output.isRepeating = false;
        if (this.isRepeating) {
            if (this.noNulls || !this.isNull[0]) {
                outputIsNull[0] = false;
                output.setVal(0, this.vector[0], this.start[0], this.length[0]);
            } else {
                outputIsNull[0] = true;
                output.noNulls = false;
            }
            output.isRepeating = true;
            return;
        }
        if (this.noNulls) {
            if (selectedInUse) {
                if (!outputColVector.noNulls) {
                    for (int j = 0; j != size; ++j) {
                        int i = sel[j];
                        outputIsNull[i] = false;
                        output.setVal(i, this.vector[i], this.start[i], this.length[i]);
                    }
                } else {
                    for (int j = 0; j != size; ++j) {
                        int i = sel[j];
                        output.setVal(i, this.vector[i], this.start[i], this.length[i]);
                    }
                }
            } else {
                if (!outputColVector.noNulls) {
                    Arrays.fill(outputIsNull, false);
                    outputColVector.noNulls = true;
                }
                for (int i = 0; i != size; ++i) {
                    output.setVal(i, this.vector[i], this.start[i], this.length[i]);
                }
            }
        } else if (selectedInUse) {
            for (int j = 0; j < size; ++j) {
                int i = sel[j];
                if (!this.isNull[i]) {
                    output.isNull[i] = false;
                    output.setVal(i, this.vector[i], this.start[i], this.length[i]);
                    continue;
                }
                output.isNull[i] = true;
                output.noNulls = false;
            }
        } else {
            for (int i = 0; i < size; ++i) {
                if (!this.isNull[i]) {
                    output.isNull[i] = false;
                    output.setVal(i, this.vector[i], this.start[i], this.length[i]);
                    continue;
                }
                output.isNull[i] = true;
                output.noNulls = false;
            }
        }
    }

    @Override
    public void flatten(boolean selectedInUse, int[] sel, int size) {
        this.flattenPush();
        if (this.isRepeating) {
            this.isRepeating = false;
            if (this.noNulls || !this.isNull[0]) {
                if (selectedInUse) {
                    for (int j = 1; j < size; ++j) {
                        int i = sel[j];
                        this.setRef(i, this.vector[0], this.start[0], this.length[0]);
                    }
                } else {
                    for (int i = 1; i < size; ++i) {
                        this.setRef(i, this.vector[0], this.start[0], this.length[0]);
                    }
                }
            }
            this.flattenRepeatingNulls(selectedInUse, sel, size);
        }
        this.flattenNoNulls(selectedInUse, sel, size);
    }

    public void fill(byte[] value) {
        this.isRepeating = true;
        this.isNull[0] = false;
        this.setVal(0, value, 0, value.length);
    }

    public void fillWithNulls() {
        this.noNulls = false;
        this.isRepeating = true;
        this.vector[0] = null;
        this.isNull[0] = true;
    }

    @Override
    public void setElement(int outputElementNum, int inputElementNum, ColumnVector inputColVector) {
        if (this.isRepeating && outputElementNum != 0) {
            throw new AssertionError((Object)"Output column number expected to be 0 when isRepeating");
        }
        if (inputColVector.isRepeating) {
            inputElementNum = 0;
        }
        if (!this.noNulls && this.isNull[outputElementNum]) {
            return;
        }
        if (inputColVector.noNulls || !inputColVector.isNull[inputElementNum]) {
            BytesColumnVector in = (BytesColumnVector)inputColVector;
            this.setVal(outputElementNum, in.vector[inputElementNum], in.start[inputElementNum], in.length[inputElementNum]);
        } else {
            this.isNull[outputElementNum] = true;
            this.noNulls = false;
        }
    }

    @Override
    public void init() {
        this.initBuffer(0);
    }

    public String toString(int row) {
        if (this.isRepeating) {
            row = 0;
        }
        if (this.noNulls || !this.isNull[row]) {
            return new String(this.vector[row], this.start[row], this.length[row]);
        }
        return null;
    }

    @Override
    public void stringifyValue(StringBuilder buffer, int row) {
        if (this.isRepeating) {
            row = 0;
        }
        if (this.noNulls || !this.isNull[row]) {
            buffer.append('\"');
            buffer.append(new String(this.vector[row], this.start[row], this.length[row]));
            buffer.append('\"');
        } else {
            buffer.append("null");
        }
    }

    @Override
    public void ensureSize(int size, boolean preserveData) {
        super.ensureSize(size, preserveData);
        if (size > this.vector.length) {
            int[] oldStart = this.start;
            this.start = new int[size];
            int[] oldLength = this.length;
            this.length = new int[size];
            byte[][] oldVector = this.vector;
            this.vector = new byte[size][];
            if (preserveData) {
                if (this.isRepeating) {
                    this.vector[0] = oldVector[0];
                    this.start[0] = oldStart[0];
                    this.length[0] = oldLength[0];
                } else {
                    System.arraycopy(oldVector, 0, this.vector, 0, oldVector.length);
                    System.arraycopy(oldStart, 0, this.start, 0, oldStart.length);
                    System.arraycopy(oldLength, 0, this.length, 0, oldLength.length);
                }
            }
        }
    }

    @Override
    public void shallowCopyTo(ColumnVector otherCv) {
        BytesColumnVector other = (BytesColumnVector)otherCv;
        super.shallowCopyTo(other);
        other.nextFree = this.nextFree;
        other.vector = this.vector;
        other.start = this.start;
        other.length = this.length;
        other.buffer = this.buffer;
    }
}

