/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.security;

import java.util.concurrent.Callable;
import org.apache.hadoop.conf.Configuration;
import org.apache.paimon.annotation.Public;
import org.apache.paimon.options.Options;
import org.apache.paimon.security.HadoopModule;
import org.apache.paimon.security.HadoopSecurityContext;
import org.apache.paimon.security.SecurityConfiguration;
import org.apache.paimon.utils.HadoopUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Public
public class SecurityContext {
    private static final Logger LOG = LoggerFactory.getLogger(SecurityContext.class);
    private static HadoopSecurityContext installedContext;

    public static void install(Options options) throws Exception {
        HadoopModule module;
        SecurityConfiguration config = new SecurityConfiguration(options);
        if (config.isLegal() && (module = SecurityContext.createModule(config)) != null) {
            module.install();
            installedContext = new HadoopSecurityContext();
        }
    }

    public static <T> T runSecured(Callable<T> securedCallable) throws Exception {
        return installedContext != null ? installedContext.runSecured(securedCallable) : securedCallable.call();
    }

    private static HadoopModule createModule(SecurityConfiguration securityConfig) {
        if (!SecurityContext.isHadoopCommonOnClasspath(HadoopModule.class.getClassLoader())) {
            LOG.info("Cannot create Hadoop Security Module because Hadoop cannot be found in the Classpath.");
            return null;
        }
        try {
            Configuration hadoopConfiguration = HadoopUtils.getHadoopConfiguration(securityConfig.getOptions());
            return new HadoopModule(securityConfig, hadoopConfiguration);
        }
        catch (LinkageError e) {
            LOG.warn("Cannot create Hadoop Security Module due to an error that happened while instantiating the module. No security module will be loaded.", (Throwable)e);
            return null;
        }
    }

    public static boolean isHadoopCommonOnClasspath(ClassLoader classLoader) {
        try {
            LOG.debug("Checking whether hadoop common dependency in on classpath.");
            Class.forName("org.apache.hadoop.conf.Configuration", false, classLoader);
            Class.forName("org.apache.hadoop.security.UserGroupInformation", false, classLoader);
            LOG.debug("Hadoop common dependency found on classpath.");
            return true;
        }
        catch (ClassNotFoundException e) {
            LOG.debug("Hadoop common dependency cannot be found on classpath.");
            return false;
        }
    }
}

