/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.reader;

import java.io.Closeable;
import java.io.IOException;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.paimon.annotation.Public;
import org.apache.paimon.reader.RecordReaderIterator;
import org.apache.paimon.utils.CloseableIterator;
import org.apache.paimon.utils.ConsumerWithIOException;
import org.apache.paimon.utils.Filter;

@Public
public interface RecordReader<T>
extends Closeable {
    @Nullable
    public RecordIterator<T> readBatch() throws IOException;

    @Override
    public void close() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void forEachRemaining(Consumer<? super T> action) throws IOException {
        try {
            RecordIterator<T> batch;
            while ((batch = this.readBatch()) != null) {
                T record;
                while ((record = batch.next()) != null) {
                    action.accept(record);
                }
                batch.releaseBatch();
            }
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void forIOEachRemaining(ConsumerWithIOException<? super T> action) throws IOException {
        try {
            RecordIterator<T> batch;
            while ((batch = this.readBatch()) != null) {
                T record;
                while ((record = batch.next()) != null) {
                    action.accept(record);
                }
                batch.releaseBatch();
            }
        }
        finally {
            this.close();
        }
    }

    default public <R> RecordReader<R> transform(final Function<T, R> function) {
        final RecordReader thisReader = this;
        return new RecordReader<R>(){

            @Override
            @Nullable
            public RecordIterator<R> readBatch() throws IOException {
                RecordIterator iterator = thisReader.readBatch();
                if (iterator == null) {
                    return null;
                }
                return iterator.transform(function);
            }

            @Override
            public void close() throws IOException {
                thisReader.close();
            }
        };
    }

    default public RecordReader<T> filter(final Filter<T> filter) {
        final RecordReader thisReader = this;
        return new RecordReader<T>(){

            @Override
            @Nullable
            public RecordIterator<T> readBatch() throws IOException {
                RecordIterator iterator = thisReader.readBatch();
                if (iterator == null) {
                    return null;
                }
                return iterator.filter(filter);
            }

            @Override
            public void close() throws IOException {
                thisReader.close();
            }
        };
    }

    default public CloseableIterator<T> toCloseableIterator() {
        return new RecordReaderIterator(this);
    }

    public static interface RecordIterator<T> {
        @Nullable
        public T next() throws IOException;

        public void releaseBatch();

        default public <R> RecordIterator<R> transform(final Function<T, R> function) {
            final RecordIterator thisIterator = this;
            return new RecordIterator<R>(){

                @Override
                @Nullable
                public R next() throws IOException {
                    Object next = thisIterator.next();
                    if (next == null) {
                        return null;
                    }
                    return function.apply(next);
                }

                @Override
                public void releaseBatch() {
                    thisIterator.releaseBatch();
                }
            };
        }

        default public RecordIterator<T> filter(final Filter<T> filter) {
            final RecordIterator thisIterator = this;
            return new RecordIterator<T>(){

                @Override
                @Nullable
                public T next() throws IOException {
                    Object next;
                    do {
                        if ((next = thisIterator.next()) != null) continue;
                        return null;
                    } while (!filter.test(next));
                    return next;
                }

                @Override
                public void releaseBatch() {
                    thisIterator.releaseBatch();
                }
            };
        }
    }
}

