/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.predicate;

import java.util.List;
import java.util.Optional;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.format.FieldStats;
import org.apache.paimon.predicate.FieldRef;
import org.apache.paimon.predicate.FunctionVisitor;
import org.apache.paimon.predicate.LeafFunction;
import org.apache.paimon.predicate.NullFalseLeafBinaryFunction;
import org.apache.paimon.types.DataType;

public class StartsWith
extends NullFalseLeafBinaryFunction {
    public static final StartsWith INSTANCE = new StartsWith();

    private StartsWith() {
    }

    @Override
    public boolean test(DataType type, Object field, Object patternLiteral) {
        BinaryString fieldString = (BinaryString)field;
        return fieldString.startsWith((BinaryString)patternLiteral);
    }

    @Override
    public boolean test(DataType type, long rowCount, FieldStats fieldStats, Object patternLiteral) {
        BinaryString min = (BinaryString)fieldStats.minValue();
        BinaryString max = (BinaryString)fieldStats.maxValue();
        BinaryString pattern = (BinaryString)patternLiteral;
        return !(!min.startsWith(pattern) && min.compareTo(pattern) > 0 || !max.startsWith(pattern) && max.compareTo(pattern) < 0);
    }

    @Override
    public Optional<LeafFunction> negate() {
        return Optional.empty();
    }

    @Override
    public <T> T visit(FunctionVisitor<T> visitor, FieldRef fieldRef, List<Object> literals) {
        return visitor.visitStartsWith(fieldRef, literals.get(0));
    }
}

