/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.operation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.paimon.Snapshot;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.index.IndexFileHandler;
import org.apache.paimon.index.IndexFileMeta;
import org.apache.paimon.manifest.IndexManifestEntry;
import org.apache.paimon.manifest.ManifestEntry;
import org.apache.paimon.manifest.ManifestFile;
import org.apache.paimon.manifest.ManifestFileMeta;
import org.apache.paimon.manifest.ManifestList;
import org.apache.paimon.shade.guava30.com.google.common.collect.Iterables;
import org.apache.paimon.utils.FileStorePathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FileDeletionBase {
    private static final Logger LOG = LoggerFactory.getLogger(FileDeletionBase.class);
    protected final FileIO fileIO;
    protected final FileStorePathFactory pathFactory;
    protected final ManifestFile manifestFile;
    protected final ManifestList manifestList;
    protected final IndexFileHandler indexFileHandler;
    protected final Map<BinaryRow, Set<Integer>> deletionBuckets;

    public FileDeletionBase(FileIO fileIO, FileStorePathFactory pathFactory, ManifestFile manifestFile, ManifestList manifestList, IndexFileHandler indexFileHandler) {
        this.fileIO = fileIO;
        this.pathFactory = pathFactory;
        this.manifestFile = manifestFile;
        this.manifestList = manifestList;
        this.indexFileHandler = indexFileHandler;
        this.deletionBuckets = new HashMap<BinaryRow, Set<Integer>>();
    }

    public abstract void cleanUnusedDataFiles(Snapshot var1, Predicate<ManifestEntry> var2);

    public abstract void cleanUnusedManifests(Snapshot var1, Set<String> var2);

    public void cleanDataDirectories() {
        if (this.deletionBuckets.isEmpty()) {
            return;
        }
        HashMap<Integer, Set> deduplicate = new HashMap<Integer, Set>();
        for (Map.Entry<BinaryRow, Set<Integer>> entry : this.deletionBuckets.entrySet()) {
            for (Integer bucket : entry.getValue()) {
                this.tryDeleteEmptyDirectory(this.pathFactory.bucketPath(entry.getKey(), bucket));
            }
            List<Path> hierarchicalPaths = this.pathFactory.getHierarchicalPartitionPath(entry.getKey());
            int hierarchies = hierarchicalPaths.size();
            if (hierarchies == 0 || !this.tryDeleteEmptyDirectory(hierarchicalPaths.get(hierarchies - 1))) continue;
            for (int hierarchy = 0; hierarchy < hierarchies - 1; ++hierarchy) {
                Path path = hierarchicalPaths.get(hierarchy);
                deduplicate.computeIfAbsent(hierarchy, i -> new HashSet()).add(path);
            }
        }
        for (int hierarchy = deduplicate.size() - 1; hierarchy >= 0; --hierarchy) {
            ((Set)deduplicate.get(hierarchy)).forEach(this::tryDeleteEmptyDirectory);
        }
        this.deletionBuckets.clear();
    }

    protected void recordDeletionBuckets(ManifestEntry entry) {
        this.deletionBuckets.computeIfAbsent(entry.partition(), p -> new HashSet()).add(entry.bucket());
    }

    protected void cleanUnusedManifests(Snapshot snapshot, Set<String> skippingSet, boolean deleteChangelog) {
        String indexManifest;
        ArrayList<ManifestFileMeta> toExpireManifests = new ArrayList<ManifestFileMeta>();
        toExpireManifests.addAll(this.tryReadManifestList(snapshot.baseManifestList()));
        toExpireManifests.addAll(this.tryReadManifestList(snapshot.deltaManifestList()));
        for (ManifestFileMeta manifest : toExpireManifests) {
            String fileName = manifest.fileName();
            if (skippingSet.contains(fileName)) continue;
            this.manifestFile.delete(fileName);
            skippingSet.add(fileName);
        }
        if (!skippingSet.contains(snapshot.baseManifestList())) {
            this.manifestList.delete(snapshot.baseManifestList());
        }
        if (!skippingSet.contains(snapshot.deltaManifestList())) {
            this.manifestList.delete(snapshot.deltaManifestList());
        }
        if (deleteChangelog && snapshot.changelogManifestList() != null) {
            for (ManifestFileMeta manifest : this.tryReadManifestList(snapshot.changelogManifestList())) {
                this.manifestFile.delete(manifest.fileName());
            }
            this.manifestList.delete(snapshot.changelogManifestList());
        }
        if ((indexManifest = snapshot.indexManifest()) != null && this.indexFileHandler.existsManifest(indexManifest)) {
            for (IndexManifestEntry entry : this.indexFileHandler.readManifest(indexManifest)) {
                if (skippingSet.contains(entry.indexFile().fileName())) continue;
                this.indexFileHandler.deleteIndexFile(entry);
            }
            if (!skippingSet.contains(indexManifest)) {
                this.indexFileHandler.deleteManifest(indexManifest);
            }
        }
    }

    protected List<ManifestFileMeta> tryReadManifestList(String manifestListName) {
        try {
            return this.manifestList.read(manifestListName);
        }
        catch (Exception e) {
            LOG.warn("Failed to read manifest list file " + manifestListName, (Throwable)e);
            return Collections.emptyList();
        }
    }

    public Iterable<ManifestEntry> tryReadManifestEntries(String manifestListName) {
        return this.readManifestEntries(this.tryReadManifestList(manifestListName));
    }

    protected Iterable<ManifestEntry> tryReadDataManifestEntries(Snapshot snapshot) {
        List<ManifestFileMeta> manifestFileMetas = this.tryReadManifestList(snapshot.baseManifestList());
        manifestFileMetas.addAll(this.tryReadManifestList(snapshot.deltaManifestList()));
        return this.readManifestEntries(manifestFileMetas);
    }

    protected Iterable<ManifestEntry> readManifestEntries(List<ManifestFileMeta> manifestFileMetas) {
        final Queue files = manifestFileMetas.stream().map(ManifestFileMeta::fileName).collect(Collectors.toCollection(LinkedList::new));
        return Iterables.concat(() -> new Iterator<Iterable<ManifestEntry>>(){

            @Override
            public boolean hasNext() {
                return files.size() > 0;
            }

            @Override
            public Iterable<ManifestEntry> next() {
                String file = (String)files.poll();
                try {
                    return FileDeletionBase.this.manifestFile.read(file);
                }
                catch (Exception e) {
                    LOG.warn("Failed to read manifest file " + file, (Throwable)e);
                    return Collections.emptyList();
                }
            }
        });
    }

    protected void addMergedDataFiles(Map<BinaryRow, Map<Integer, Set<String>>> dataFiles, Snapshot snapshot) {
        Iterable<ManifestEntry> entries = this.tryReadDataManifestEntries(snapshot);
        for (ManifestEntry entry : ManifestEntry.mergeEntries(entries)) {
            dataFiles.computeIfAbsent(entry.partition(), p -> new HashMap()).computeIfAbsent(entry.bucket(), b -> new HashSet()).add(entry.file().fileName());
        }
    }

    protected boolean containsDataFile(Map<BinaryRow, Map<Integer, Set<String>>> dataFiles, ManifestEntry testee) {
        Set<String> fileNames;
        Map<Integer, Set<String>> buckets = dataFiles.get(testee.partition());
        if (buckets != null && (fileNames = buckets.get(testee.bucket())) != null) {
            return fileNames.contains(testee.file().fileName());
        }
        return false;
    }

    public Set<String> manifestSkippingSet(Snapshot skippingSnapshot) {
        return this.manifestSkippingSet(Collections.singletonList(skippingSnapshot));
    }

    public Set<String> manifestSkippingSet(List<Snapshot> skippingSnapshots) {
        HashSet<String> skippingSet = new HashSet<String>();
        for (Snapshot skippingSnapshot : skippingSnapshots) {
            skippingSet.add(skippingSnapshot.baseManifestList());
            skippingSet.add(skippingSnapshot.deltaManifestList());
            skippingSnapshot.dataManifests(this.manifestList).stream().map(ManifestFileMeta::fileName).forEach(skippingSet::add);
            String indexManifest = skippingSnapshot.indexManifest();
            if (indexManifest == null) continue;
            skippingSet.add(indexManifest);
            this.indexFileHandler.readManifest(indexManifest).stream().map(IndexManifestEntry::indexFile).map(IndexFileMeta::fileName).forEach(skippingSet::add);
        }
        return skippingSet;
    }

    private boolean tryDeleteEmptyDirectory(Path path) {
        try {
            this.fileIO.delete(path, false);
            return true;
        }
        catch (IOException e) {
            LOG.debug("Failed to delete directory '{}'. Check whether it is empty.", (Object)path);
            return false;
        }
    }
}

