/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.operation;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.casting.CastExecutor;
import org.apache.paimon.casting.CastExecutors;
import org.apache.paimon.casting.DefaultValueRow;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.predicate.PredicateBuilder;
import org.apache.paimon.predicate.PredicateReplaceVisitor;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.RowType;
import org.apache.paimon.types.VarCharType;
import org.apache.paimon.utils.Projection;

public class DefaultValueAssigner {
    private final RowType rowType;
    private final Map<String, String> defaultValues;
    private boolean needToAssign;
    private int[][] project;
    private DefaultValueRow defaultValueRow;

    private DefaultValueAssigner(Map<String, String> defaultValues, RowType rowType) {
        this.defaultValues = defaultValues;
        this.needToAssign = defaultValues.size() > 0;
        this.rowType = rowType;
    }

    public DefaultValueAssigner handleProject(int[][] project) {
        this.project = project;
        if (project != null) {
            List<String> projected = Projection.of(project).project(this.rowType).getFieldNames();
            this.needToAssign = this.defaultValues.keySet().stream().anyMatch(projected::contains);
        }
        return this;
    }

    public boolean needToAssign() {
        return this.needToAssign;
    }

    public RecordReader<InternalRow> assignFieldsDefaultValue(RecordReader<InternalRow> reader) {
        if (!this.needToAssign) {
            return reader;
        }
        if (this.defaultValueRow == null) {
            this.defaultValueRow = this.createDefaultValueRow();
        }
        return reader.transform(this.defaultValueRow::replaceRow);
    }

    @VisibleForTesting
    DefaultValueRow createDefaultValueRow() {
        List<DataField> fields = this.project != null ? Projection.of(this.project).project(this.rowType).getFields() : this.rowType.getFields();
        GenericRow row = new GenericRow(fields.size());
        for (int i = 0; i < fields.size(); ++i) {
            DataField dataField = fields.get(i);
            String defaultValueStr = this.defaultValues.get(dataField.name());
            if (defaultValueStr == null) continue;
            CastExecutor<?, ?> resolve = CastExecutors.resolve(VarCharType.STRING_TYPE, dataField.type());
            if (resolve == null) {
                throw new RuntimeException("Default value do not support the type of " + dataField.type());
            }
            Object defaultValue = resolve.cast(BinaryString.fromString(defaultValueStr));
            row.setField(i, defaultValue);
        }
        return DefaultValueRow.from(row);
    }

    public Predicate handlePredicate(Predicate filters) {
        Predicate result = filters;
        if (!this.defaultValues.isEmpty() && filters != null) {
            PredicateReplaceVisitor deletePredicateWithFieldNameVisitor = predicate -> {
                if (this.defaultValues.containsKey(predicate.fieldName())) {
                    return Optional.empty();
                }
                return Optional.of(predicate);
            };
            ArrayList<Predicate> filterWithouDefaultValueField = new ArrayList<Predicate>();
            List<Predicate> predicates = PredicateBuilder.splitAnd(filters);
            for (Predicate predicate2 : predicates) {
                predicate2.visit(deletePredicateWithFieldNameVisitor).ifPresent(filterWithouDefaultValueField::add);
            }
            result = !filterWithouDefaultValueField.isEmpty() ? PredicateBuilder.and(filterWithouDefaultValueField) : null;
        }
        return result;
    }

    public static DefaultValueAssigner create(TableSchema schema) {
        CoreOptions coreOptions = new CoreOptions(schema.options());
        Map<String, String> defaultValues = coreOptions.getFieldDefaultValues();
        return new DefaultValueAssigner(defaultValues, schema.logicalRowType());
    }
}

