/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.metrics;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.paimon.metrics.Counter;
import org.apache.paimon.metrics.Gauge;
import org.apache.paimon.metrics.Histogram;
import org.apache.paimon.metrics.Metric;
import org.apache.paimon.metrics.MetricGroup;
import org.apache.paimon.metrics.Metrics;
import org.apache.paimon.metrics.SimpleCounter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMetricGroup
implements MetricGroup {
    protected static final Logger LOG = LoggerFactory.getLogger(MetricGroup.class);
    protected Map<String, String> tags;
    private boolean closed = false;
    private final ConcurrentHashMap<String, Metric> metrics = new ConcurrentHashMap();

    public AbstractMetricGroup(Map<String, String> tags) {
        this.tags = tags;
        Metrics.getInstance().addGroup(this);
    }

    @Override
    public Map<String, String> getAllTags() {
        return this.tags;
    }

    @Override
    public String getMetricIdentifier(String metricName, String delimiter) {
        return String.join((CharSequence)delimiter, this.getGroupName(), metricName);
    }

    @Override
    public Counter counter(String name) {
        return this.counter(name, new SimpleCounter());
    }

    @Override
    public <C extends Counter> C counter(String name, C counter) {
        return (C)((Counter)this.addMetric(name, counter));
    }

    @Override
    public <T, G extends Gauge<T>> G gauge(String name, G gauge) {
        return (G)((Gauge)this.addMetric(name, gauge));
    }

    @Override
    public <H extends Histogram> H histogram(String name, H histogram) {
        return (H)((Histogram)this.addMetric(name, histogram));
    }

    protected Metric addMetric(String metricName, Metric metric) {
        if (metric == null) {
            LOG.warn("Ignoring attempted registration of a metric due to being null for name {}.", (Object)metricName);
            return null;
        }
        if (!this.isClosed()) {
            switch (metric.getMetricType()) {
                case COUNTER: 
                case GAUGE: 
                case HISTOGRAM: {
                    Metric prior = this.metrics.put(metricName, metric);
                    if (prior == null) break;
                    this.metrics.put(metricName, prior);
                    LOG.warn("Name collision: Group already contains a Metric with the name '" + metricName + "'. The new added Metric will not be reported.");
                    break;
                }
                default: {
                    LOG.warn("Cannot add unknown metric type {}. This indicates that the paimon does not support this metric type.", (Object)metric.getClass().getName());
                }
            }
        }
        return this.metrics.get(metricName);
    }

    @Override
    public Map<String, Metric> getMetrics() {
        return Collections.unmodifiableMap(this.metrics);
    }

    @Override
    public abstract String getGroupName();

    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.metrics.clear();
        }
    }

    public final boolean isClosed() {
        return this.closed;
    }
}

