/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.mergetree;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.paimon.KeyValue;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.io.KeyValueFileReaderFactory;
import org.apache.paimon.mergetree.DropDeleteReader;
import org.apache.paimon.mergetree.MergeSorter;
import org.apache.paimon.mergetree.SortedRun;
import org.apache.paimon.mergetree.compact.ConcatRecordReader;
import org.apache.paimon.mergetree.compact.MergeFunction;
import org.apache.paimon.mergetree.compact.MergeFunctionWrapper;
import org.apache.paimon.mergetree.compact.ReducerMergeFunctionWrapper;
import org.apache.paimon.reader.RecordReader;

public class MergeTreeReaders {
    private MergeTreeReaders() {
    }

    public static RecordReader<KeyValue> readerForMergeTree(List<List<SortedRun>> sections, boolean dropDelete, KeyValueFileReaderFactory readerFactory, Comparator<InternalRow> userKeyComparator, MergeFunction<KeyValue> mergeFunction, MergeSorter mergeSorter) throws IOException {
        ArrayList readers = new ArrayList();
        for (List<SortedRun> section : sections) {
            readers.add(() -> MergeTreeReaders.readerForSection(section, readerFactory, userKeyComparator, new ReducerMergeFunctionWrapper(mergeFunction), mergeSorter));
        }
        DropDeleteReader reader = ConcatRecordReader.create(readers);
        if (dropDelete) {
            reader = new DropDeleteReader(reader);
        }
        return reader;
    }

    public static <T> RecordReader<T> readerForSection(List<SortedRun> section, KeyValueFileReaderFactory readerFactory, Comparator<InternalRow> userKeyComparator, MergeFunctionWrapper<T> mergeFunctionWrapper, MergeSorter mergeSorter) throws IOException {
        ArrayList<ConcatRecordReader.ReaderSupplier<KeyValue>> readers = new ArrayList<ConcatRecordReader.ReaderSupplier<KeyValue>>();
        for (SortedRun run : section) {
            readers.add(() -> MergeTreeReaders.readerForRun(run, readerFactory));
        }
        return mergeSorter.mergeSort(readers, userKeyComparator, mergeFunctionWrapper);
    }

    public static RecordReader<KeyValue> readerForRun(SortedRun run, KeyValueFileReaderFactory readerFactory) throws IOException {
        ArrayList readers = new ArrayList();
        for (DataFileMeta file : run.files()) {
            readers.add(() -> readerFactory.createRecordReader(file.schemaId(), file.fileName(), file.level()));
        }
        return ConcatRecordReader.create(readers);
    }
}

