/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.memory;

import java.util.List;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.memory.MemoryOwner;
import org.apache.paimon.memory.MemorySegment;
import org.apache.paimon.memory.MemorySegmentPool;
import org.apache.paimon.shade.guava30.com.google.common.collect.Iterators;
import org.apache.paimon.utils.Preconditions;

public class MemoryPoolFactory {
    private final MemorySegmentPool innerPool;
    private final int totalPages;
    private Iterable<MemoryOwner> owners;

    public MemoryPoolFactory(MemorySegmentPool innerPool) {
        this.innerPool = innerPool;
        this.totalPages = innerPool.freePages();
    }

    public MemoryPoolFactory addOwners(Iterable<MemoryOwner> newOwners) {
        if (this.owners == null) {
            this.owners = newOwners;
        } else {
            Iterable<MemoryOwner> currentOwners = this.owners;
            this.owners = () -> Iterators.concat(currentOwners.iterator(), newOwners.iterator());
        }
        return this;
    }

    public void notifyNewOwner(MemoryOwner owner) {
        Preconditions.checkNotNull(this.owners);
        owner.setMemoryPool(this.createSubPool(owner));
    }

    @VisibleForTesting
    public Iterable<MemoryOwner> memoryOwners() {
        return this.owners;
    }

    MemorySegmentPool createSubPool(MemoryOwner owner) {
        return new OwnerMemoryPool(owner);
    }

    private void preemptMemory(MemoryOwner owner) {
        long maxMemory = -1L;
        MemoryOwner max = null;
        for (MemoryOwner other : this.owners) {
            if (other == owner || other.memoryOccupancy() <= maxMemory) continue;
            maxMemory = other.memoryOccupancy();
            max = other;
        }
        if (max != null) {
            try {
                max.flushMemory();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private class OwnerMemoryPool
    implements MemorySegmentPool {
        private final MemoryOwner owner;
        private int allocatedPages = 0;

        public OwnerMemoryPool(MemoryOwner owner) {
            this.owner = owner;
        }

        @Override
        public int pageSize() {
            return MemoryPoolFactory.this.innerPool.pageSize();
        }

        @Override
        public void returnAll(List<MemorySegment> memory) {
            this.allocatedPages -= memory.size();
            MemoryPoolFactory.this.innerPool.returnAll(memory);
        }

        @Override
        public int freePages() {
            return MemoryPoolFactory.this.totalPages - this.allocatedPages;
        }

        @Override
        public MemorySegment nextSegment() {
            MemorySegment segment = MemoryPoolFactory.this.innerPool.nextSegment();
            if (segment == null) {
                MemoryPoolFactory.this.preemptMemory(this.owner);
                segment = MemoryPoolFactory.this.innerPool.nextSegment();
            }
            if (segment != null) {
                ++this.allocatedPages;
            }
            return segment;
        }
    }
}

